import java.io.*;
import java.util.*;
import java.text.*;

/** Klasa tworzca skorowidz.
*   @author Koffman and Wolfgang
* */

public class IndexGenerator {

  // pole danych
  /** Drzewo przechowujce skorowidz. */
  private TreeSet < String > index;

  // metody
  public IndexGenerator() {
    index = new TreeSet < String > ();
  }

  /** Odczytuje kady wyraz z pliku danych bR i zapamituje go wraz z numerem
      wiersza w drzewie.
      koc: Kady wyraz zamieniony na mae litery wraz z numerem wiersza
            znajduje si w drzewie index.
      @param bR Referencja do pliku z danymi.
      @throws IOException
   */
  public void buildIndex(BufferedReader bR) throws IOException {
    DecimalFormat threeDigits = new DecimalFormat("000");
    int lineNum = 0; // numer wiersza
    String nextLine; // dane poszczeglnych wierszy
    // Odczytywanie wierszy a do koca pliku.
    while ( (nextLine = bR.readLine()) != null) {
      lineNum++;
      // Otworzenie obiektu StringTokenizer dla aktualnego wiersza danych.
      // Znakami oddzielajcymi wyrazy s znaki przestankowe i spacja.
      StringTokenizer tokens =
          new StringTokenizer(nextLine, " ,.:-!?/%");
      // Wstaw poszczeglne tokeny do drzewa.
      while (tokens.hasMoreTokens()) {
        String next = tokens.nextToken().toLowerCase();
        index.add(String.format("%s, %3d", next, lineNum));
      }
    }
  }

  /** Wywietl skorowidz, po jednym wyrazie w wierszu. */
  public void showIndex() {
    // Wykorzystanie iteratora do dostpu do drzewa.
    for (String next : index) {
      System.out.println(next);
    }
  }
}
