import java.util.Comparator;

/** Klasa porwnujca obiekty PrintDocumentsna podstawie
*   ich rozmiaru i czasu utworzenia.
*   @author Koffman and Wolfgang
*/

public class ComparePrintDocuments
    implements Comparator < PrintDocument > {
  /** Waga rozmiaru. */
  private static final double P1 = 0.8;

  /** Waga dla czasu. */
  private static final double P2 = 0.2;

  /** Porwnuje dwa obiekty PrintDocuments.
      @param left Lewa strona porwnywania.
      @param right Prawa strona porwnywania.
      @return -1, jeli left < right; 0, jeli left == right;
              +1, jeli left > right.
   */
  public int compare(PrintDocument left, PrintDocument right) {
    return Double.compare(orderValue(left), orderValue(right));
  }

  /** Oblicza sum waon dla dokumentu do druku.
      @param pd Obiekt PrintDocument.
      @return rednia waona bazujca na rozmiarze i czasie utworzenia.
   */
  private double orderValue(PrintDocument pd) {
    return P1 * pd.getSize() + P2 * pd.getTimeStamp();
  }
}
