import java.io.*;

/** Klasa reprezentujca binarne drzewo wyszukiwania.
 *  @author Koffman and Wolfgang
 */

public class BinarySearchTree < E extends Comparable < E >>
    extends BinaryTree < E > implements SearchTree < E > {
  // pola danych
  /** Warto zwracana przez metod publiczn add(). */
  protected boolean addReturn;

  /** Warto zwracana przez metod publiczn delete(). */
  protected E deleteReturn;

  // metody
  /** Metoda uruchamiajca rekurencyjne wyszukiwanie.
      pocz: Obiekt target musi implementowa interfejs Comparable.
      @param target Poszukiwany obiekt implementujcy interfejs Comparable.
      @return Zwraca znaleziony obiekt lub warto null.
   */
  public E find(E target) {
    return find(root, target);
  }

  /** Rekurencyjna metoda poszukujca.
      @param localRoot Lokalny korze.
      @param target Poszukiwany obiekt.
      @return Zwraca znaleziony obiekt lub warto null.
   */
  private E find(Node < E > localRoot, E target) {
    if (localRoot == null)
      return null;

    // Porwnuje obiekt target z danymi zawartymi w korzeniu.
    int compResult = target.compareTo(localRoot.data);
    if (compResult == 0)
      return localRoot.data;
    else if (compResult < 0)
      return find(localRoot.left, target);
    else
      return find(localRoot.right, target);
  }

  /** Metoda uruchamiajca rekurencyjne wstawianie.
     pocz: Obiekt target musi implementowa interfejs Comparable.
     @param item Wstawiany obiekt.
     @return Warto true, jeli obiekt wstawiono. Warto false,
             jeli obiekt znajduje si ju w drzewie.
   */
  public boolean add(E item) {
    root = add(root, item);
    return addReturn;
  }

  /** Rekurencyjna metoda wstawiajca.
      koc: Pole danych addReturn ustawione na true, jeli element zosta
            wstawiony, lub warto false, jeli ju znajduje si w drzewie.
      @param localRoot Lokalny korze poddrzewa.
      @param item Obiekt do wstawienia.
      @return Nowy, lokalny korze zawierajcy wstawiony element.
   */
  private Node < E > add(Node < E > localRoot, E item) {
    if (localRoot == null) {
      // Elementu nie w drzewie  wstaw go.
      addReturn = true;
      return new Node < E > (item);
    }
    else if (item.compareTo(localRoot.data) == 0) {
      // Element jest rwny localRoot.data.
      addReturn = false;
      return localRoot;
    }
    else if (item.compareTo(localRoot.data) < 0) {
      // Element jest mniejszy od localRoot.data.
      localRoot.left = add(localRoot.left, item);
      return localRoot;
    }
    else {
      // Element jest wikszy od localRoot.data.
      localRoot.right = add(localRoot.right, item);
      return localRoot;
    }
  }

  /** Metoda uruchamiajca rekurencyjne usuwanie.
      ko: Obiektu nie ma w drzewie.
      @param target Obiekt do usunicia.
      @return Obiekt usunity z drzewa lub warto null, jeli
              obiektu nie odnaleziono w drzewie.
      @throws Wyjtek ClassCastException, jeli obiekt target nie implementuje
              interfejsu Comparable.
   */
  public E delete(E target) {
    root = delete(root, target);
    return deleteReturn;
  }

  /** Rekurencyjna metoda usuwajca.
      koc: Elementu nie ma w drzewie;
            deleteReturn jest rwne usunitemu elementowi w
            postaci jak znajdowaa si w drzewie lub ma warto null,
            jeli element nie znajdowa si w drzewie.
      @param localRoot Aktualny korze.
      @param item Element do usunicia.
      @return Zmodyfkowany lokalny korze, ktry nie zawiera ju elementu.
   */
  private Node < E > delete(Node < E > localRoot, E item) {
    if (localRoot == null) {
      // Elementu nie ma w drzewie.
      deleteReturn = null;
      return localRoot;
    }

    // Poszukiwanie elementu do usunicia.
    int compResult = item.compareTo(localRoot.data);
    if (compResult < 0) {
      // Element jest mniejszy od localRoot.data.
      localRoot.left = delete(localRoot.left, item);
      return localRoot;
    }
    else if (compResult > 0) {
      // Element jest wikszy od localRoot.data.
      localRoot.right = delete(localRoot.right, item);
      return localRoot;
    }
    else {
      // Element znajduje si w lokalnym korzeniu.
      deleteReturn = localRoot.data;
      if (localRoot.left == null) {
        // Jeli nie ma lewego dziecka, zwr prawe, ktre
        // rwnie moe mie warto null.
        return localRoot.right;
      }
      else if (localRoot.right == null) {
        // Jeli nie ma prawego dziecka, zwr lewe.
        return localRoot.left;
      }
      else {
        // Usuwany wze ma dwoje dzieci, zastp dane z wykorzystaniem
        // poprzednika w porzdku inorder.
        if (localRoot.left.right == null) {
          // Lewe dziecko nie ma prawego dziecka.
          // Zastp dane danymi z lewego dziecka.
          localRoot.data = localRoot.left.data;
          // Zastp lewe dziecko jego prawym dzieckiem.
          localRoot.left = localRoot.left.left;
          return localRoot;
        }
        else {
          // Szukaj poprzednika w porzdku inorder i
          // dane usuwanego wza informacjami z poprzednika.
          localRoot.data = findLargestChild(localRoot.left);
          return localRoot;
        }
      }
    }
  }

/**** WICZENIE ****/

  /** Znajduje wze bdcy poprzednikiem w porzdku inorder i
      zastpuje go jego lewym dzieckiem (jeli istnieje).
      koc: Poprzednik w porzdku inorder zostaje usunity z drzewa.
      @param parent Rodzic moliwego poprzednika w porzdku inorder.
                    predecessor (ip)
      @return Dane z poprzednika w porzdku inorder.
   */
  private E findLargestChild(Node < E > parent) {
    // Jeli prawe dziecko nie ma swojego prawego dziecka, jest
    // poprzednikiem w porzdku inorder.
    if (parent.right.right == null) {
      E returnValue = parent.right.data;
      parent.right = parent.right.left;
      return returnValue;
    }
    else {
      return findLargestChild(parent.right);
    }
  }

}
