import java.awt.*;

/** Klasa szukajca wyjcia z labiryntu z zastosowaniem nawrotw.
*   @author Koffman and Wolfgang
* */

public class Maze
    implements GridColors {

  /** Labirynt. */
  private TwoDimGrid maze;

  public Maze(TwoDimGrid m) {
    maze = m;
  }

  /** Metoda opakowujca. */
  public boolean findMazePath() {
    return findMazePath(0, 0); // (0, 0) to punkt pocztkowy.
  }

  /** Prbuje odnale ciek przez punkt (x, y).
      pocz: Moliwe komrki cieki s w kolorze BACKGROUND;
           komrki blokujce s w kolorze ABNORMAL.
      koc: Jeli znaleziono ciek, wszystkie komrki na niej maj
            kolor PATH; wszystkie odwiedzone komrki, ktre nie znajduj
            si na ciece maj kolor TEMPORARY.
      @param x Wsprzdna X aktualnego punktu.
      @param y Wsprzdna Y aktualnego punktu.
      @return Jeli znaleziono ciek przez punkt(x, y), zwraca warto true;
              w przeciwnym razie zwraca warto false.
   */
  public boolean findMazePath(int x, int y) {
    if (x < 0 || y < 0
        || x >= maze.getNCols() || y >= maze.getNRows())
      return false; // Komrka poza dopuszczalnymi granicami.
    else if (!maze.getColor(x, y).equals(BACKGROUND))
      return false; // Komrka to bariera lub lepy zauek.
    else if (x == maze.getNCols() - 1
             && y == maze.getNRows() - 1) {
      maze.recolor(x, y, PATH); // Komrka znajduje si na ciece
      return true; // i jest wyjciem z labiryntu.
    }
    else { // Przypadek rekurencyjny.
      // Prba odnalezienia cieki dla kadego ssiada.
      // Tymczasowo oznacza, i komrka znajduje si na ciece.
      maze.recolor(x, y, PATH);
      if (findMazePath(x - 1, y)
          || findMazePath(x + 1, y)
          || findMazePath(x, y - 1)
          || findMazePath(x, y + 1)) {
        return true;
      }
      else {
        maze.recolor(x, y, TEMPORARY); // lepy zauek.
        return false;
      }
    }
  }
}
