/** Klasa listy z metodami rekurencyjnymi.
 *  @author Koffman and Wolfgang
 *  */

public class LinkedListRec < E > {

  /** Gowa listy. */
  private Node < E > head;

  /** Klasa Node stanowica podstawowy bloczek listy jednokierunkowej. */
  private static class Node < E > {
    // pola danych
    /** Referencja do obiektu danych. */
    private E data;

    /** Referencja do nastpnego wza. */
    private Node next;

    // konstruktory
    /** Tworzy nowy wze z polem next ustawionym na null.
        @param dataItem Obiekt do umieszczenia na licie.
     */
    private Node(E dataItem) {
      data = dataItem;
      next = null;
    }

    /** Tworzy nowy wze wskazujcy na inny wze.
        @param dataItem Obiekt do umieszczenia na licie.
        @param nodeRef Referencja do wza, na ktry ma wskazywa nowy wze.
     */
    private Node(E dataItem, Node < E > nodeRef) {
      data = dataItem;
      next = nodeRef;
    }
  } // koniec klasy Node

  /** Okrela dugo listy.
       @param head Gowa listy.
       @return Rozmiar listy.
   */
  private int size(Node < E > head) {
    if (head == null)
      return 0;
    else
      return 1 + size(head.next);
  }

  /** Metoda opakowujca znajdowania rozmiaru listy.
      @return Rozmiar listy.
   */
  public int size() {
    return size(head);
  }

  /** Zwraca tekstow reprezentacj listy
      @param head Aktualna gowa listy.
      @return Stan aktualnej listy.
   */
  private String toString(Node < E > head) {
    if (head == null)
      return "";
    else
      return head.data + "\n" + toString(head.next);
  }

  /** Metoda opakowujca zwracajca tekstow reprezentacj listy.
      @return Tekstowa reprezentacja listy.
   */
  public String toString() {
    return toString(head);
  }

  /** Zastpuje wszystkie wystpienia oldObj obiektem newObj.
      koc: Wszystkie wystpienia oldObj zostay zastpione przez newObj.
      @param head Gowa listy.
      @param oldObj Usuwany obiekt.
      @param newObj Wstawiany obiekt.
   */
  private void replace(Node < E > head, E oldObj, E newObj) {
    if (head != null) {
      if (oldObj.equals(head.data))
        head.data = newObj;
      replace(head.next, oldObj, newObj);
    }
  }

  /** Metoda opakowujca dla zastpie oldObj przez newObj.
      koc: Wszystkie wystpienia oldObj zostay zastpione przez newObj.
      @param oldObj Usuwany obiekt.
      @param newObj Wstawiany obiekt.
   */
  public void replace(E oldObj, E newObj) {
    replace(head, oldObj, newObj);
  }

  /** Dodaje nowy element na kocu listy.
      @param head Gowa aktualnej listy.
      @param data Dane dla nowego wza.
   */
  private void add(Node < E > head, E data) {
    // Jeli lista ma tylko jeden element, dodaj nowy wze do niego.
    if (head.next == null)
      head.next = new Node < E > (data);
    else
      add(head.next, data); // Dodaj do reszty listy.
  }

  /** Metoda opakowujca do dodawania nowego wza na kocu listy.
      @param data Dane nowego wza.
   */
  public void add(E data) {
    if (head == null)
      head = new Node < E > (data); // Lista ma jeden wze.
    else
      add(head, data);
  }

  /** Usuwa wze z listy.
      koc: Zostao usunite pierwsze wystpnienie outData.
      @param head Gowa aktualnej listy.
      @param pred Poprzednik gowy listy.
      @param outData Dane do usunicia.
      @return Warto true, jeli elementu usunito. Warto
              w przypadku przeciwnym.
   */
  private boolean remove(Node < E > head, Node < E > pred, E outData) {
    if (head == null) // Pierwszy przypadek brzegowy.
      return false;
    else if (head.data.equals(outData)) { // Drugi przypadek brzegowy.
      pred.next = head.next; // Usunicie gowy.
      return true;
    }
    else
      return remove(head.next, head, outData);
  }

  /** Metoda otoczkowa dla usuwania wza (z LinkedListRec).
      koc: Zostao usunite pierwsze wystpnienie outData.
      @param outData Dane do usunicia.
      @return Warto true, jeli elementu usunito. Warto
              w przypadku przeciwnym
   */
  public boolean remove(E outData) {
    if (head == null)
      return false;
    else if (head.data.equals(outData)) {
      head = head.next;
      return true;
    }
    else
      return remove(head.next, head, outData);
  }

}
