import java.io.*;
import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/** Program ilustrujcy dziaanie siatki z plamami.
*   @author Koffman and Wolfgang
* */

public class BlobTest
    extends JFrame
    implements GridColors, ActionListener {

  // poledanych
  /** Dwuwumiarowa siatka przyciskw */
  private TwoDimGrid theGrid;

  /** Odczytuje plik z danymi i wypenia siatk.
   *  @param args Opcjonalny plik wejciowy z siatk.*/
  public static void main(String[] args) {
    try {
      if (args.length < 1) {
        /** Nie podano nazwy pliku. */
        String reply =
            JOptionPane.showInputDialog("Wpisz liczb wierszy");
        int nRows = Integer.parseInt(reply);
        reply =
            JOptionPane.showInputDialog("Wpisz liczb kolumn");
        int nCols = Integer.parseInt(reply);
        TwoDimGrid aGrid = new TwoDimGrid(nRows, nCols);
        new BlobTest(aGrid);
      }
      else {
        /** Utworzenie bitmapy z pliku wejciowego. */
        BufferedReader br =
            new BufferedReader(new FileReader(args[0]));

        /** Odczytaj kaduy wiersz danych do
            gridArrayList. Kady element to tablica znakw. */
        ArrayList gridArrayList = new ArrayList();
        String line;
        while ( (line = br.readLine()) != null) {
          char[] row = line.toCharArray();
          gridArrayList.add(row);
        }

        /** bitMap to tablica 2D uzyskana na podstawie gridArrayList */
        char[][] bitMap = (char[][]) gridArrayList.toArray
            (new char[gridArrayList.size()][]);
        int nRows = bitMap.length;
        int nCols = bitMap[0].length;

        /** Utwrz obiekt TwoDimGrid i zmie jego kolory zgodnie z bitmap. */
        TwoDimGrid aGrid = new TwoDimGrid(nRows, nCols);
        aGrid.recolor(bitMap, ABNORMAL);
        new BlobTest(aGrid);
      }
    }
    catch (Exception ex) {
      System.err.println("Wyjtek " + ex);
      ex.printStackTrace();
      // System.exit(1);
    }
  }

  /** Tworzy interfejs graficzny.
   *  @param aGrid Obiekt TwoDimGrid zawierajcy siatk. */
  private BlobTest(TwoDimGrid aGrid) {
    theGrid = aGrid;
    getContentPane().add(aGrid, BorderLayout.CENTER);
    Blob aBlob = new Blob(aGrid);
    JTextArea instruct = new JTextArea(2, 10);
    instruct.setText("Kliknij przycisk, by zmieni jego kolor."
                     + "\nNacinij ROZWI, gdy bdziesz gotowy.");
    getContentPane().add(instruct, BorderLayout.NORTH);
    JButton solveButton = new JButton("ROZWI");
    solveButton.addActionListener(this);
    getContentPane().add(solveButton, BorderLayout.SOUTH);
    setDefaultCloseOperation(EXIT_ON_CLOSE);
    pack();
    show();
  }

  /** Odpowiada na nacinicie przycisku rozwizywania zadania.
   *  @param e Nieuywane. */
  public void actionPerformed(ActionEvent e) {
    String reply =
        JOptionPane.showInputDialog("Wpisz wsprzdn X komrki");
    int x = Integer.parseInt(reply);
    reply =
        JOptionPane.showInputDialog("Wpisz wsprzdn Y komrki");
    int y = Integer.parseInt(reply);
    Blob aBlob = new Blob(theGrid);
    JOptionPane.showMessageDialog(null, "Dla plamy z ("
                                  + x + "," + y + ") "
                                  + "\nliczba komrek wynosi "
                                  + aBlob.countCells(x, y)
                                  + ".\nZresetuj plam i zacznij od pocztku.");
  }
}
