import java.util.*;

/** Klasa symulujca kolejk pasaerw.
 *  @author Koffman & Wolfgang
 * */

public class PassengerQueue {
  // pola danych
  /** Kolejka pasaerw. */
  private Queue < Passenger > theQueue;

  /** Liczba obsuonych pasaerw. */
  private int numServed;

  /** czny czas oczekiwania pasaerw. */
  private int totalWait;

  /** Nazwa kolejki */
  private String queueName;

  /** redni czas przychodzenia nowego pasaera. */
  private double arrivalRate;

  // konstruktor
  /** Tworzy kolejk pasaerw o podanej nazwie.
      @param queueName Nazwa tej kolejki.
   */
  public PassengerQueue(String queueName) {
    numServed = 0;
    totalWait = 0;
    this.queueName = queueName;
    theQueue = new LinkedList < Passenger > ();
  }

  /** Zwraca liczb obsuonych pasaerw.
      @return Liczba obsuonych pasaerw.
   */
  public int getNumServed() {
    return numServed;
  }

  /** Zwraca czny czas oczekiwania.
      @return czny czas oczekiwania.
   */
  public int getTotalWait() {
    return totalWait;
  }

  /** Zwraca nazw kolejki.
      @return Nazwa kolejki.
   */
  public String getQueueName() {
    return queueName;
  }

  /** Ustawia czas przybywania.
      @param arrivalRate redni czas przybywania pasaerw.
   */
  public void setArrivalRate(double arrivalRate) {
    this.arrivalRate = arrivalRate;
  }

  /** Okrela, czy kolejka jest pusta.
      @return Zwraca warto true, jeli kolejka jest pusta.
   */
  public boolean isEmpty() {
    return theQueue.isEmpty();
  }

  /** Pobiera rozmiar kolejki.
      @return Rozmiar kolejki.
   */
  public int size() {
    return theQueue.size();
  }

  /** Sprawdza, czy nastpio przybycie nowego pasaera.
      @param clock Aktualny cza symulacji.
      @param showAll Znacznik okrelajcy, czy naley wywietli
                     szczegowe informacje.
   */
  public void checkNewArrival(int clock, boolean showAll) {
    if (Math.random() < arrivalRate) {
      theQueue.add(new Passenger(clock));
      if (showAll) {
        System.out.println("Czas "
                           + clock + ": nowy pasaer w "
                           + queueName
                           + ", nowy rozmiar kolejki "
                           + theQueue.size());
      }
    }
  }

  /** Aktualizacja statystyk.
      pocz: Kolejka nie jest pusta.
      @param clock Aktualny cza symulacji.
      @param showAll Znacznik okrelajcy, czy naley wywietli
                     szczegowe informacje.
      @return Czas zakoczenia obsugi pasaera.
   */
  public int update(int clock, boolean showAll) {
    Passenger nextPassenger = theQueue.remove();
    int timeStamp = nextPassenger.getArrivalTime();
    int wait = clock - timeStamp;
    totalWait += wait;
    numServed++;
    if (showAll) {
      System.out.println("Czas " + clock
                         + ": obsuenie "
                         + queueName
                         + " ze znacznikiem czasowym "
                         + timeStamp);
    }
    return clock + nextPassenger.getProcessingTime();
  }

}
