import java.util.*;

/** Klasa preprzezentujca pasaera.
 *  @author Koffman & Wolfgang
 * */

public class Passenger {

  // pola danych
  /** Identyfikator pasaera. */
  private int passengerId;

  /** Cass potrzebny na obsuenie pasaera. */
  private int processingTime;

  /** Czas przybycia pasaera. */
  private int arrivalTime;

  /** Maksymalny czas obsugi pasaera. */
  private static int maxProcessingTime;

  /** Numer sekwencyjny dla pasaerw. */
  private static int idNum = 0;

  /** Utworzenie nowego pasaera.
      @param arrivalTime Czas przybycia pasaera. */
  public Passenger(int arrivalTime) {
    this.arrivalTime = arrivalTime;
    processingTime = 1 + (new Random()).nextInt(maxProcessingTime);
    passengerId = idNum++;
  }

  /** Pobranie czasu przybycia.
      @return Czas przybycia. */
  public int getArrivalTime() {
    return arrivalTime;
  }

  /** Pobranie czasu obsugi.
      @return Czas obsugi. */
  public int getProcessingTime() {
    return processingTime;
  }

  /** Pobranie identyfikatora pasaera.
      @return Identyfikator pasaera. */
  public int getId() {
    return passengerId;
  }

  /** Ustawienie maksymalnego czasu obsugi.
      @param maxProcessingTime nowa warto. */
  public static void setMaxProcessingTime(int maxProcessTime) {
    maxProcessingTime = maxProcessTime;
  }
}
