import javax.swing.*;
import java.util.*;

/** Klasa przechowujca kolejk klientw.
*   @author Koffman & Wolfgang
* */

public class MaintainQueue {

  // pole danych
  private Queue < String > customers;

  // konstruktor
  /** Utwrz pust kolejk. */
  public MaintainQueue() {
    customers = new LinkedList < String > ();
  }

  /** Przeprowadza na kolejce operacje wybrane przez klienta.
      pocz: Utworzono obiekt kolejki i umieszczono jego referencj w customers.
      koc: Obiekt customers zostaje zmodyfikowany zgodnie z wybran opcj.
   */
  public void processCustomers() {
    int choiceNum = 0;
    String[] choices = {
        "dodaj", "pobierz", "usu", "rozmiar", "pooenie", "wyjcie"};

    // Perform all operations selected by user.
    while (choiceNum < choices.length - 1) {
      // Select the next operation.
      choiceNum = JOptionPane.showOptionDialog(null,
                                               "Wybierz operacj na kolejce klientw",
                                               "Menu kolejki",
                                               JOptionPane.YES_NO_CANCEL_OPTION,
                                               JOptionPane.QUESTION_MESSAGE, null,
                                               choices, choices[0]);

      // Przetwarza dokonany wybr.
      try {
        String name;
        switch (choiceNum) {
          case 0:
            name = JOptionPane.showInputDialog
                ("Wpisz imi lub nazwisko klienta");
            customers.offer(name);
            JOptionPane.showMessageDialog(null,
                                          "Klienta " + name
                                          + " dodano do kolejki.");
            break;
          case 1:
            JOptionPane.showMessageDialog(null,
                                          "Klient " + customers.element()
                                          + " jest nastpny w kolejce.");
            break;
          case 2:
            JOptionPane.showMessageDialog(null,
                                          "Klient " + customers.remove()
                                          + " zosta usunity z kolejki.");
            break;
          case 3:
            JOptionPane.showMessageDialog(null,
                                          "Rozmiar kolejki wynosi " + customers.size());
            break;
          case 4:
            name = JOptionPane.showInputDialog
                ("Wpisz nazwisko klienta");
            int countAhead = 0;
            for (String nextName : customers) {
              if (!nextName.equals(name)) {
                countAhead++;
              }
              else {
                JOptionPane.showMessageDialog(null,
                                              "Przed klientem  " + name +
                                              " znajduje si " + countAhead + " klientw.");
                break; // Znaleziono klient, opu ptl.
              }
            }

            // Sprawd, czy klient zosta odnaleziony.
            if (countAhead == customers.size())
              JOptionPane.showMessageDialog(null,
                                            name + " nie znajduje si w kolejce.");
            break;
          case 5:
            JOptionPane.showMessageDialog(null,
                                          "Opuszczenie kolejki klientw. "
                                          +
                                          "\nAktualna liczba klientw: "
                                          + customers.size());
            break;
          default:
            JOptionPane.showMessageDialog(null,
                                          "Niepoprawy wybr.");
            break;
        }
      }
      catch (NoSuchElementException e) {
        JOptionPane.showMessageDialog(null,
                                      "Kolejka jest pusta!", "",
                                      JOptionPane.ERROR_MESSAGE);
      }
    }
  }
}
