import javax.swing.*;

/** Symuluje proces obsugi pasaerw linii lotniczej.
*   @author Koffman & Wolfgang
*/

public class AirlineCheckinSim {

  // pola danych
  /** Kolejka pasaerw uprzywilejowanych. */
  private PassengerQueue frequentFlyerQueue =
      new PassengerQueue("Pasaerowie uprzywilejowani");

  /** Kolejka zwykych pasaerw. */
  private PassengerQueue regularPassengerQueue =
      new PassengerQueue("Zwykli pasaerowie");

  /** Maksymalna liczba obsuonych pasaerw uprzywilejowanych
      przed obsueniem pasaera zwykego. */
  private int frequentFlyerMax;

  /** Maksymalny czas obsugi pasaera. */
  private int maxProcessingTime;

  /** czny czas symulacji. */
  private int totalTime;

  /** Jeli ustawione na true, wywietla bardziej szczegowe dane. */
  private boolean showAll;

  /** Zegar symulacji. */
  private int clock = 0;

  /** Czas po jakim zostanie obsuony aktualny pasaer.*/
  private int timeDone;

  /** Liczba pasaerw uprzywilejowanych obsuonych
      od ostatniego pasaera zwyczajnego. */
  private int frequentFlyersSinceRP;

  private void runSimulation() {
    for (clock = 0; clock < totalTime; clock++) {
      frequentFlyerQueue.checkNewArrival(clock, showAll);
      regularPassengerQueue.checkNewArrival(clock, showAll);
      if (clock >= timeDone) {
        startServe();
      }
    }
  }

  private void startServe() {
    if (!frequentFlyerQueue.isEmpty()
        && ( (frequentFlyersSinceRP <= frequentFlyerMax)
            || regularPassengerQueue.isEmpty())) {
      // Obsu nastpnego pasaera uprzywilejowanego.
      frequentFlyersSinceRP++;
      timeDone = frequentFlyerQueue.update(clock, showAll);
    }
    else if (!regularPassengerQueue.isEmpty()) {
      // Obsu nastpnego pasaera zwyczajnego.
      frequentFlyersSinceRP = 0;
      timeDone = regularPassengerQueue.update(clock, showAll);
    }
    else if (showAll) {
      System.out.println("Aktualny czas: " + clock
                         + ". Obsuga stoi bezczynnie.");
    }
  }

  /** Metoda prezentujca statystyki. */
  private void showStats() {
    System.out.println
        ("\nLiczba obsuonych zwykych pasaerw "
         + regularPassengerQueue.getNumServed());
    double averageWaitingTime =
        (double) regularPassengerQueue.getTotalWait()
        / (double) regularPassengerQueue.getNumServed();
    System.out.println(" ze rednim czasem oczekiwania wynoszcym "
                       + averageWaitingTime);
    System.out.println("Liczba obsuonych pasaerw uprzywilejowanych "
                       + frequentFlyerQueue.getNumServed());
    averageWaitingTime =
        (double) frequentFlyerQueue.getTotalWait()
        / (double) frequentFlyerQueue.getNumServed();
    System.out.println(" ze rednim czasem oczekiwania wynoszcym "
                       + averageWaitingTime);
    System.out.println("Liczba pasaerw uprzywilejowanych znajdujcych si w kolejce: "
                       + frequentFlyerQueue.size());
    System.out.println("Liczba zwykych pasaerw znajdujcych si w kolejce: "
                       + regularPassengerQueue.size());
  }

  /** Metoda startowa.
      @param args Nieuywane.
  */
  public static void main(String args[]) {
    AirlineCheckinSim sim = new AirlineCheckinSim();
    sim.enterData()
    sim.runSimulation();
    sim.showStats();
    System.exit(0);
  }

}
