/** Stos to struktura danych, w ktrej obiekty wstawia si i usuwa z
 *  tego samego koca (czyli ostatni wszed, pierwszy wychodzi).
 *  @author Koffman & Wolfgang
 */

public interface StackInt < E > {

  /** Umieszcza obiekt na szczycie stosu i zwraca referencj do niego.
      @param obj Obiekt do wstawienia.
      @return Wstawiony obiekt.
   */
  E push(E obj);

  /** Zwraca obiekt ze szczytu stosu bez jego zdejmowania.
      koc: Stos nie zmienia swej zawartoci.
      @return Obiekt ze szczytu stosu.
      @throws Zgasza wyjtek EmptyStackException, jeli stos jest pusty.
   */
  E peek();

  /** Zwraca obiekt ze szczytu stosu i usuwa go ze stosu.
      koc: Stos maleje o jeden element.
      @return Obiekt ze szczytu stosu.
      @throws Zgasza wyjtek EmptyStackException, jeli stos jest pusty.
   */
  E pop();

  /** Zwraca warto true, jeli stos jest pusty.
      W przeciwnym razie zwraca warto false.
      @return Zwraca warto true, jeli stos jest pusty.
   */
  boolean empty();
}
