import java.util.*;

/** Klasa z metodami sprawdzajcymi, czy wyraz jest palindromem.
*   @author Koffman & Wolfgang
* */

public class PalindromeFinder {

  /** Tekst do umieszczenia na stosie. */
  private String inputString;

  /** Stos przechowujcy znaki. */
  private Stack < Character > charStack = new Stack < Character > ();

  /** Zapamituje argument tekstowy na stosie znakw.
      @param str Tekst do umieszczenia na stosie znakw.
   */
  public PalindromeFinder(String str) {
    inputString = str;
    fillStack();
  }

  /** Metoda wypeniajca stos znakami tekstu wejciowego. */
  private void fillStack() {
    for (int i = 0; i < inputString.length(); i++) {
      charStack.push(inputString.charAt(i));
    }
  }

  /** Metoda tworzca tekst ze znakw pobranych ze stosu.
      koc: Stos est pusty.
      @return Tekst zawierajcy znaki ze stosu.
   */
  private String buildReverse() {
    StringBuilder result = new StringBuilder();
    while (!charStack.empty()) {
      // Usu wierzchoek stosu i dodaj go do wyniku.
      result.append(charStack.pop());
    }
    return result.toString();
  }

  public boolean isPalindrome() {
    return inputString.equalsIgnoreCase(buildReverse());
  }
}
