import java.util.*;

/** Niniejsza klasa implementuje niektre metody klasy ArrayList.
*   @author Koffman & Wolfgang
*/

public class KWArrayList <E> {
  // pola danych
  /** Domylna, pocztkowa pojemno. */
  private static final int INITIAL_CAPACITY = 10;

  /** Tablica danych. */
  private E[] theData;

  /** Aktualny rozmiar. */
  private int size = 0;

  /** Aktualna pojemno. */
  private int capacity = 0;

  /** Tworzy pusty obiekt KWArrayList o domylnej pojemnoci.
   */
  public KWArrayList() {
    capacity = INITIAL_CAPACITY;
    theData = (E[])new Object[capacity];
  }

  /** Dodaje element na kocu tablicy.
        @param anEntry Wstawiana warto.
   */
  public boolean add(E anEntry) {
    if (size == capacity) {
      reallocate();
    }
    theData[size] = anEntry;
    size++;
    return true;
  }

  /** Pobiera warto spod podanego indeksu.
        @param index Indeks pobieranego elementu.
        @return Zawarto spod podanego indeksu.
        @throws ArrayIndexOutOfBoundsException - jeli indeks jest
        ujemny lub ma warto wiksz od aktulanego rozmiaru.
   */
  public E get(int index) {
    if (index < 0 || index >= size) {
      throw new ArrayIndexOutOfBoundsException(index);
    }
    return theData[index];
  }

  /** Ustawia warto spod podanego indeksu.
        @param index Indeks elementu.
        @param newValue Nowa warto do zapamitania.
        @return Stara warto z danego pooenia.
        @throws ArrayIndexOutOfBoundsException - jeli indeks jest
        ujemny lub ma warto wiksz od aktulanego rozmiaru.
   */
  public E set(int index, E newValue) {
    if (index < 0 || index >= size) {
      throw new ArrayIndexOutOfBoundsException(index);
    }
    E oldValue = theData[index];
    theData[index] = newValue;
    return oldValue;
  }

  /** Usuwa element spod podanego indeksu.
        @param index Indeks usuwanego elementu.
        @return Usunita warto.
        @throws ArrayIndexOutOfBoundsException - jeli indeks jest
        ujemny lub ma warto wiksz od aktulanego rozmiaru.
   */
  public E remove(int index) {
    if (index < 0 || index >= size) {
      throw new ArrayIndexOutOfBoundsException(index);
    }
    E returnValue = theData[index];
    for (int i = index + 1; i < size; i++) {
      theData[i - 1] = theData[i];
    }
    size--;
    return returnValue;
  }

  /** Alokacja nowej tablicy.
   */
  private void reallocate() {
    capacity = 2 * capacity;
    E[] newData = (E[])new Object[capacity];
    System.arraycopy(theData, 0, newData, 0, size);
    theData = newData;
  }

  /** Pobranie aktualnego rozmiaru tablicy.
        @return Aktualny rozmiar tablicy.
   */
  public int size() {
    return size;
  }
}
