package drawableShapes;
import java.awt.*;
import javax.swing.*;

/** Rysuje zbir ksztatw zapisany w tablicy.
*   Uywa klas DrawableRectangle, DrawableCircle,
*   DrawableTriangle i AWT.
*   @author Koffman & Wolfgang
*/

public class TestDrawFigures
    extends JPanel {

  /** Tablica obiektw DrawableShapes. */
  private DrawableShape[] drawableShapes;

  /** Tworzy kilka ksztatw i oblicza ich pole oraz obwd.
   */
  private TestDrawFigures() {
    DrawableShape[] drawableShapes = {
        new DrawableCircle(50, new Point(50, 50),
                           Color.BLUE, Color.GREEN),
        new DrawableRectangle(100, 200, new Point(100, 100),
                              Color.RED, Color.YELLOW),
        new DrawableTriangle(50, 100, new Point(250, 300),
                             Color.BLACK, Color.RED),
        new DrawableRectangle(60, 50, new Point(300, 200),
                              Color.ORANGE, Color.GRAY),
        new DrawableCircle(0, new Point(0, 0),
                           Color.BLACK, Color.WHITE),
        new DrawableRectangle(0, 0, new Point(0, 0),
                              Color.BLACK, Color.WHITE),
        new DrawableTriangle(0, 0, new Point(0, 0),
                             Color.BLACK, Color.WHITE),
        new DrawableCircle( -100, new Point(300, 350),
                           Color.BLACK, Color.WHITE),
        new DrawableRectangle( -50, 50, new Point(50, 400),
                              Color.GREEN, Color.RED)
    };

    // Zapamituje referencj do tablicy obiektw.
    this.drawableShapes = drawableShapes;

    // Wywietla trzy atrybuty obiektw.
    for (int i = 0; i < drawableShapes.length; i++) {
      System.out.println("\n" + drawableShapes[i]);
      System.out.println
          ("Area: "
           + drawableShapes[i].computeArea()
           + ", perimeter: "
           + drawableShapes[i].computePerimeter());
    }
  }

  /** Metoda startowa. Tworzy okno i obiekt TestDrawFigures a nastpnie
      umieszcza TestDrawFigures w oknie.
      @param args Argumenty wiersza polece (nieuywane).
   */
  public static void main(String[] args) {
    // Tworzy okno, w ktrym zostan wywietlone figury.
    JFrame frame = new JFrame("Test rysowania figur");
    frame.setSize(400, 450);
    // Tworzy kolekcj figur w oknie.
    frame.setContentPane(new TestDrawFigures());
    // Wywietla okno i rysuje figury.
    frame.show();
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
  }

  /** Rysuje ksztaty.
      @param g rodowisko graficze.
   */
  public void paintComponent(Graphics g) {
    // Rysuje to.
    super.paintComponent(g);

    // Rysuje ksztaty.
    for (int i = 0; i < drawableShapes.length; i++) {
      drawableShapes[i].drawMe(g);
    }
  }
}
