package drawableShapes;
import java.awt.*;

/** Klasa abstrakcyjna dla obiektw, ktre mona narysowa.
 *  @author Koffman & Wolfgang
 * */

public abstract class DrawableShape
    extends Drawable
    implements ShapeInt {
  // pole danych
  /** Referencja do obiektu ksztatu. */
  protected ShapeInt theShape;

  // konstruktor
  /** Tworzy DrawableShape z podanymi parametrami.
      @param poi Pooenie pocztku.
      @param border Kolor zarysu.
      @param inter Kolor wypenienia.
      @param aShape Ksztat.
   */
  public DrawableShape(Point poi, Color border, Color inter,
                       ShapeInt aShape) {
    super(poi, border, inter);
    theShape = aShape;
  }

  // metody uywajce delegacji
  /** Obliczenie pola.
      @return Pole.
   */
  public double computeArea() {
    return theShape.computeArea();
  }

  /** Wyliczenie obwodu.
      @return Obwd.
   */
  public double computePerimeter() {
    return theShape.computePerimeter();
  }

  /** Odczytanie rozmiaru ksztatu. */
  public void readShapeData() {
    theShape.readShapeData();
  }
}

