package drawableShapes;
import java.awt.*;

/** Reprezentuje prostokt, ktry mona narysowa.
*   implementuje ShapeInt.
*   @author Koffman & Wolfgang
*/

public class DrawableRectangle
    extends DrawableShape {

  // konstruktor
  /** Tworzy prostokt o podanych wymiarach, kolorze i punkcie pocztkowym.
      @param wid Szeroko.
      @param hei Wysoko
      @param poi Wsprzdne lewego grnego naronika.
      @param border Kolor zarysu.
      @param inter Kolor wypenienia.
   */
  public DrawableRectangle(int wid, int hei,
                           Point poi, Color border, Color inter) {
    super(poi, border, inter, new Rectangle(wid, hei));
  }

  /** Rysuje prostokt.
      @param g Kontekst graficzny(ekran).
   */
  public void drawMe(Graphics g) {
    g.setColor(interiorColor);
    Rectangle rectangle = (Rectangle) theShape;
    g.fillRect(pos.x, pos.y,
               rectangle.getWidth(), rectangle.getHeight());
    g.setColor(borderColor);
    g.drawRect(pos.x, pos.y,
               rectangle.getWidth(), rectangle.getHeight());
  }

  public String toString() {
    return "Rysowalny " + theShape + super.toString();
  }
}
