package drawableShapes;
import java.awt.*;

/** Klasa zawiera wsplne atrybuty obiektw, ktre mona narysowa.
*   Konkretne podklasy musz definiowa metod drawMe().
*   @author Koffman & Wolfgang
*/
public abstract class Drawable {
    // pola danych
    /** Pooenie pocztku ksztatu. */
    protected Point pos = new Point(0, 0);
    /** Kolor zarysu. */
    protected Color borderColor = Color.black;
    /** Kolor wypenienia. */
    protected Color interiorColor = Color.white;

    // metoda abstrakcyjna
    public abstract void drawMe(Graphics g);

    // konstruktor
    /** Tworzy obiekt Drawable z podanymi parametrami.
        @param poi Pooenie pocztku.
        @param border Kolor zarysu.
        @param inter Kolor wypenienia.
    */
    public Drawable(Point poi, Color border, Color inter) {
        pos = poi;
        borderColor = border;
        interiorColor = inter;
    }

    // metody
    /** Tworzy tekstow reprezentacj klasy.
        @return Tekstowa reprezentacja klasy.
    */
    public String toString() {
        return "\nwsprzdna x wynosi " + pos.x
               + ", wsprzdna y wynosi " + pos.y
               + "\nkolor zarysu to " + borderColor
               + "\nkolor wypenienia to " + interiorColor;
    }
}
