/** Klasa oblicza sinus i kosinus dla kta wyraonego w stopniach.
    Wynikiem jest liczba cakowita reprezentujca sinus lub kosinus
    pomnoony przez 10 tysicy. Na przykad wynik 7071 reprezentuje
    warto 7071e-4 lub 0.7071.
    @author Koffman & Wolfgang
 */

public class SinCos {
  /** Oblicza sinus konta w stopniach.
      @param x Kt w stopniach.
      @return Sinus kta.
   */
  public static int sin(int x) {
    if (x < 0) {
      x = -x;
    }
    x = x % 360;
    if (0 <= x && x <= 45) {
      return sin0to45(x);
    }
    else if (45 <= x && x <= 90) {
      return sin45to90(x);
    }
    else if (90 <= x && x <= 180) {
      return sin(180 - x);
    }
    else {
      return -sin(x - 180);
    }
  }

  /** Oblicza kosinus kta w stopniach.
      @param x Kt w stopniach.
      @return Kosinus podanego kta.
   */
  public static int cos(int x) {
    return sin(x + 90);
  }

  /** Oblicza sinus kta w stopniach midzy 0 a 45.
      pocz: 0 <= x < 45
      @param x Kt.
      @return Sinus kta x.
   */
  private static int sin0to45(int x) {
    // W realistycznym programie metoda ta uywaaby
    // aproksymacji wielomianowej zoptmalizowanej dla
    // stosowanego zakresu wartoci wyjciowych.
    // Kod wyliczajcy sin(x) dla x w zakresie od 0 do 45 stopni.
/**** WICZENIE ****/
  }

  /** Oblicza sinus kta w stopniach midzy 45 a 90.
      pocz: 45 <= x <= 90
      @param x Kt.
      @return Sinus kta x.
   */
  private static int sin45to90(int x) {
    // W realistycznym programie metoda ta uywaaby
    // aproksymacji wielomianowej zoptmalizowanej dla
    // stosowanego zakresu wartoci wyjciowych.
    // Kod wyliczajcy sin(x) dla x w zakresie od 45 do 90 stopni.
/**** WICZENIE ****/
  }

/**** WICZENIE ****/

}
