import javax.swing.*;

/** Class to provide input routines
 *  @author Koffman & Wolfgang
 */

public class MyInput {

  /** Metoda zwracajc liczb cakowit podan przez uytkownika.
    @param prompt Tekst zapytania.
    @return Odczytana warto jako typ int.
   */
  public static int readInt(String prompt) {
    while (true) { // Wykonywanie ptli a do momentu wpisania poprawnej wartoci.
      try {
        String numStr = JOptionPane.showInputDialog(prompt);
        return Integer.parseInt(numStr);
      }
      catch (NumberFormatException ex) {
        JOptionPane.showMessageDialog(
            null,
            "Podana warto nie jest liczb - sprbuj ponownie",
            "Bd", JOptionPane.ERROR_MESSAGE);
      }
    }
  }

  /** Metoda zwraca warto cakowit w podanym zakresie.
    pocz: minN <= maxN.
    @param prompt Wywietlany komunikat.
    @param minN Pocztek zakresu.
    @param maxN Koniec zakresu.
    @throws IllegalArgumentException
    @return Pierwsz liczb, ktra znajdzie si w zakresie.
   */
  public static int readInt(String prompt, int minN, int maxN) {
    if (minN > maxN) {
      throw new IllegalArgumentException(
          "W readInt() minN " + minN
          + " nie jest <= maxN " + maxN);
    }
    // Argumenty s poprawne, odczytanie wartoci.
    boolean inRange = false; // Za brak poprawnej wartoci.
    int n = 0;
    while (!inRange) { // Powtarzaj a do uzyskania poprawnej wartoci.
      try {
        String line = JOptionPane.showInputDialog(
            prompt + "\nWpisz liczb cakowit midzy "
            + minN + " i " + maxN);
        n = Integer.parseInt(line);
        inRange = (minN <= n && n <= maxN);
      }
      catch (NumberFormatException ex) {
        JOptionPane.showMessageDialog(
            null,
            "Podana warto nie jest liczb - sprbuj ponownie",
            "Bd", JOptionPane.ERROR_MESSAGE);
      }
    } // Koniec ptli.
    return n; // Warto n znajduje si w zakresie.
  }
}
