/** Interfejs ksiki telefonicznej.
 *  @author Koffman & Wolfgang
 */

public interface PhoneDirectory {

  /** Wczytuje plik danych zawierajcy ksik telefoniczn.
      Ustanawia poczenie ze rdem danych.
      @param sourceName Nazwa pliku (rda danych)
                        ze wpisami ksiki telefonicznej.
   */
  void loadData(String sourceName);

  /** Wyszukanie wpisu.
      @param name Nazwisko osoby, ktr chce si wyszuka.
      @return Numer telefonu lub null, jeli osoby nie ma w spisie.
   */
  String lookupEntry(String name);

  /** Dodaje nowy wpis lub zmienia istniejcy.
      @param name Nazwisko i imi dodawanej lub modyfikowanej osoby.
      @param number Nowy numer telefonu przypisywany osobie.
      @return Stary numer lub w przypadku nowego wpisu warto null.
   */
  String addOrChangeEntry(String name, String number);

  /** Usuwa wpis z ksiki telefonicznej.
      @param name Nazwisko i imi osoby do usunicia.
      @return Aktualny numer telefonu. Jeli osoba nie istnieje w spisie
              zwrcenie wartoci null.
   */
  String removeEntry(String name);

  /** Zapis ksiki telefonicznej.
      pocz: Ksika telefoniczna jest wypeniona danymi.
      koc: Zawarto ksiki telefonicznej zapisana w pliku w postaci
            par nazwisko-numer w kolejnych wierszach,
            pole modified zostaje zmienione na warto false.
   */
  void save();
}
