import javax.swing.*;

/** Klasa implementuje interfejs PDUserInterface i
 *  uywa klasy JOptionPane do wywietlania okien dialogowych.
 *  @author Koffman & Wolfgang
 */

public class PDGUI
    implements PDUserInterface {

  /** Referencja do obiektu PhoneDirectory zawierajcego ksik telefoniczn.
      Dostpna w sposb globalny dla metod przetwarzania polece.
   */
  private PhoneDirectory theDirectory = null;

  // metody
  /** Metoda wywietlajca menu i przetwarzajca polecenia uytkownika.
      pocz: Ksika telefoniczna istnieje i zostaa odczytana z pliku.
      koc: Ksika zostaje uaktualniona zgodnie z poleceniami uytkownika.
      @param thePhoneDirectory Referencja do obiektu PhoneDirectory
             zawierajcego ksik telefoniczn.
   */
  public void processCommands(PhoneDirectory thePhoneDirectory) {

    String[] commands = {
        "Dodaj/Zmie wpis",
        "Szukaj wpisu",
        "Kasuj wpis",
        "Zapisz ksik",
        "Wyjcie"};

    theDirectory = thePhoneDirectory;
    int choice;

    do {
      choice = JOptionPane.showOptionDialog(
          null, // brak rodzica
          "Wybierz polecenie", // tre zapytania
          "Ksika telefoniczna", // tytu okna
          JOptionPane.YES_NO_CANCEL_OPTION, // rodzaj opcji
          JOptionPane.QUESTION_MESSAGE, // typ komunikatu
          null, // ikona
          commands, // lista polece
          commands[commands.length - 1]); // domylny wybr
      switch (choice) {
        case 0:
          doAddChangeEntry();
          break;
        case 1:
          doLookupEntry();
          break;
        case 2:
          doRemoveEntry();
          break;
        case 3:
        case 4:
          doSave();
          break;
        default: // nic nie rb
      }
    }
    while (choice != commands.length - 1);
    System.exit(0);
  }

  /** Metoda dodajca lub modyfikujca wpis.
      pocz: Ksika telefoniczna istnieje i zostaa odczytana z pliku.
      koc: Zostaje dodana nowa osoba lub jeli istniaa, zmienia si jej
            numer telefonu, zmienna modified zostaje ustawiona na true.
   */
  private void doAddChangeEntry() {
    // Proba o podanie nazwiska.
    String newName = JOptionPane.showInputDialog("Wpisz nazwisko");
    if (newName == null) {
      return; // Anulowano okno dialogowe.
    }
    // Proba o podanie numeru telefonu.
    String newNumber = JOptionPane.showInputDialog("Wpisz numer telefonu");
    if (newNumber == null) {
      return; // Anulowano okno dialogowe.
    }
    // Wstaw lub zmie par nazwisko-numer.
    String oldNumber = theDirectory.addOrChangeEntry(newName,
        newNumber);
    String message = null;
    if (oldNumber == null) { // nowy wpis
      message = newName + " zosta dodany do spisu."
          + "\nNowy numer: " + newNumber;
    }
    else { // zmiana wpisu
      message = "Numer dla " + newName + " zosta zmieniony."
          + "\nStary numer: " + oldNumber
          + "\nNowy numer: " + newNumber;
    }
    // Wywietl komunikat potwierdzenia.
    JOptionPane.showMessageDialog(null, message);
  }

  /** Metoda wyszukujca wpis.
      pocz: Ksika telefoniczna zostaa wypeniona danymi.
      koc: Nie dokonuje zmian w ksice.
   */
  private void doLookupEntry() {
    // Proba o podanie nazwiska.
    String theName = JOptionPane.showInputDialog("Wpisz nazwisko");
    if (theName == null) {
      return; // Anulowano okno dialogowe.
    }
    // Wyszukanie nazwiska.
    String theNumber = theDirectory.lookupEntry(theName);
    String message = null;
    if (theNumber != null) { // znaleziono nazwisko
      message = "Numer telefonu do " + theName + " to " + theNumber;
    }
    else { // nazwiska nie znaleziono
      message = theName + " nie zosta znaleziony w ksice telefonicznej.";
    }
    // Wywietlenie wyniku.
    JOptionPane.showMessageDialog(null, message);
  }

  /** Metoda usuwajca wpis.
       pocz: Ksika jest wypeniona danymi.
       koc: Podane nazwisko zostaje usunite, zmienna modifed przyjmuje warto true.
   */
  private void doRemoveEntry() {
/**** WICZENIE ****/
  }

  /** Metoda zapisujca zawarto ksiki w pliku.
      pocz: Ksika jest wypeniona danymi.
      koc: Aktualna zawarto ksiki telefonicznej zostaje umieszczona w pliku.
   */
  private void doSave() {
    theDirectory.save();
  }

}
