import java.io.*;

 /** Jest to implementacja interfejsu PhoneDirectory, ktra
  *   uywa tablicy do przechowywania wpisw.
  *   @author Koffman & Wolfgang
  */

public class ArrayBasedPD
    implements PhoneDirectory {

  // pola danych

  /** Pocztkowy rozmiar tablicy. */
  private static final int INITIAL_CAPACITY = 100;

  /** Aktualny rozmiar tablicy. */
  private int capacity = INITIAL_CAPACITY;

  /** Liczba wpisw znajdujcych si w tablicy. */
  private int size = 0;

  /** Tablica zawierajca wpisy. */
  private DirectoryEntry[] theDirectory =
      new DirectoryEntry[capacity];

  /** Plik danych zawierajcy ksik telefoniczn. */
  private String sourceName = null;

  /** Zmienna logiczna wskazujca, czy zawarto tablicy wpisw
      ulega zmianie od ostatniego odczytu lub zapisu. */
  private boolean modified = false;

  /** Metoda odczytuje dane z pliku.
       pocz:  Miejsce przechowywania wpisw zostao utworzone i jest puste.
        Jeli plik istnieje, w kolejnych wierszach zawiera na przemian
        nazwiska i numery telefonw osb.
       koc: Dane z pliku zostay wczytane do tablicy z ksik telefoniczn.
       @param sourceName Nazwa pliku danych.
   */
  public void loadData(String sourceName) {
    // Zapamitaj nazw pliku danych.
    this.sourceName = sourceName;
    try {
      // Utwrz obiekt BufferedReader dla pliku.
      BufferedReader in = new BufferedReader(
          new FileReader(sourceName));
      String name;
      String number;

      // Odczytaj nazwisko i numer telefonu a nastpnie dodaje nowy wpis.
      while ( (name = in.readLine()) != null) {
        // Odczytaj nazwisko i numer z kolejnych wierszy.
        if ( (number = in.readLine()) == null) {
          break; // Nie udao si odczyta numeru - koniec ptli.
        }
        // Dodanie wpisu dla pobranego nazwiska i numeru.
        add(name, number);
      }

      // Zamknicie pliku.
      in.close();
    }
    catch (FileNotFoundException ex) {
      // Nic nie rb - nie ma danych do zaadowania.
      return;
    }
    catch (IOException ex) {
      System.err.println("Zaadowanie ksiki telefonicznej nie powiodo si.");
      ex.printStackTrace();
      System.exit(1);
    }
  }

  /** Dodaje nowy wpis lub zmienia istniejcy.
      @param name Nazwisko i imi dodawanej lub modyfikowanej osoby.
      @param number Nowy numer telefonu przypisywany osobie.
      @return Stary numer lub w przypadku nowego wpisu warto null.
   */
  public String addOrChangeEntry(String name, String number) {
    String oldNumber = null;
    int index = find(name);
    if (index > -1) {
      oldNumber = theDirectory[index].getNumber();
      theDirectory[index].setNumber(number);
    }
    else {
      add(name, number);
    }
    modified = true;
    return oldNumber;
  }

  /** Wyszukanie wpisu.
      @param name Nazwisko osoby, ktr chce si wyszuka.
      @return Numer telefonu lub null, jeli osoby nie ma w spisie.
   */
  public String lookupEntry(String name) {
    int index = find(name);
    if (index > -1) {
      return theDirectory[index].getNumber();
    }
    else {
      return null;
    }
  }

  /** Zapis ksiki telefonicznej.
      pocz: Ksika telefoniczna jest wypeniona danymi.
      koc: Zawarto ksiki telefonicznej zapisana w pliku w postaci
            par nazwisko-numer w kolejnych wierszach,
            pole modified zostaje zmienione na warto false.
   */
  public void save() {
    if (modified) { // Jeli nie dokonano modyfikacji, nic nie rb.
      try {
        // Tworzy obiekt PrintWriter dla pliku.
        PrintWriter out = new PrintWriter(
            new FileWriter(sourceName));

        // Zapisuje poszczeglne wpisy do pliku.
        for (int i = 0; i < size; i++) {
          // Zapisuje nazwisko i imi.
          out.println(theDirectory[i].getName());
          // Zapisuje numer telefonu.
          out.println(theDirectory[i].getNumber());
        }

        // Zamyka plik i ustawia pole modified.
        out.close();
        modified = false;
      }
      catch (Exception ex) {
        System.err.println("Nie udao si zapisa ksiki telefonicznej!");
        ex.printStackTrace();
        System.exit(1);
      }
    }
  }

  /** Znajduje wpis w ksikce telefonicznej.
      @param name Nazwisko do odnalezienia.
      @return Indeks wpisuj zawierajcy dane nazwisko.
              Jeli nazwiska nie w spisie, zwraca -1.
   */
  private int find(String name) {
    for (int i = 0; i < size; i++) {
      if (theDirectory[i].getName().equals(name)) {
        return i;
      }
    }
    return -1; // Nazwiska nie odnaleziono.
  }

  /** Dodaje nowy wpis do ksiki telefonicznej.
      @param name Naziwsko nowej osoby.
      @param number Numer telefonu nowej osoby.
   */
  private void add(String name, String number) {
    if (size >= capacity) {
      reallocate();
    }
    theDirectory[size] = new DirectoryEntry(name, number);
    size++;
  }

  /** Alokacja tablicy o dwukrotnie wikszym rozmiarze. */
  private void reallocate() {
    capacity *= 2;
    DirectoryEntry[] newDirectory = new DirectoryEntry[capacity];
    System.arraycopy(theDirectory, 0, newDirectory, 0,
                     theDirectory.length);
    theDirectory = newDirectory;
  }

/**** WICZENIE ****/
}
