/** Interfejs definiujcy drzewo wyszukiwania.
 *  @author Koffman and Wolfgang
 * */

public interface SearchTree < E
    extends Comparable < E >> {
  /** Wstawia element w odpowiednim miejscu drzewa.
      @param item Element do wstawienia.
      @return Warto true, jeli element wstawiono. Warto false,
      jeli znajdowa si ju w drzewie.
   */
  boolean add(E item);

  /** Sprawdza, czy element znajduje si w drzwie.
      @param target Poszukiwany element.
      @return Warto true, jeli element jest w drzewie. W przeciwnym razie false.
   */
  boolean contains(E target);

  /** Znajduje obiekt w drzewie.
      @param target Poszukiwany element.
      @return Referencja do obiektu z drzewa, ktry zwraca warto true, jeli
      jest porwnywany metod compareTo() z target. W przeciwnym razie
      zostaje zwrcona warto null.
   */
  E find(E target);

  /** Usuwa element z drzewa.
      @param targetElement do usunicia
      @return Referencja do obiektu z drzewa, ktry zwraca warto true, jeli
      jest porwnywany metod compareTo() z target. W przeciwnym razie
      zostaje zwrcona warto null.
      koc: Elementu target nie ma w drzewie.
   */
  E delete(E target);

  /** Usuwa element z drzewa.
      @param targetElement do usunicia
      @return Warto true, jeli element by w drzewie. W przeciwnym razie false.
      koc: Elementu target nie ma w drzewie.
   */
  boolean remove(E target);
}
