import java.io.*;

/** Klasa drzewa binarnego przechowujca obiekty typu E.
*   @author Koffman and Wolfgang
* */

public class BinaryTree < E > implements Serializable {

  /** Klasa implementujca wze drzewa. */
  protected static class Node < E >
      implements Serializable {
    // pola danych
    /** Informacje przechowywane w wle. */
    protected E data;

    /** Referencja do lewego dziecka. */
    protected Node < E > left;

    /** Referencja do prawego dziecka. */
    protected Node < E > right;

    // konstruktor
    /** Tworzy nowy wze z danymi bez dzieci.
        @param data Dane do umieszczenia w wle.
     */
    public Node(E data) {
      this.data = data;
      left = null;
      right = null;
    }

    // metody
    /** Zwraca tekst reprezentujcy dane.
        @return Tekst preprezentujcy pole danych.
     */
    public String toString() {
      return data.toString();
    }
  }

  // pole danych
  /** Korze drzewa binarnego. */
  protected Node < E > root;

  public BinaryTree() {
    root = null;
  }

  protected BinaryTree(Node < E > root) {
    this.root = root;
  }

  /** Tworzy nowe drzewo binarne z danymi data wewntrz korzenia, leftTree
      jako lewym poddrzewem i rightTree jako prawym poddrzewem.
   */
  public BinaryTree(E data, BinaryTree < E > leftTree,
                    BinaryTree < E > rightTree) {
    root = new Node < E > (data);
    if (leftTree != null) {
      root.left = leftTree.root;
    }
    else {
      root.left = null;
    }
    if (rightTree != null) {
      root.right = rightTree.root;
    }
    else {
      root.right = null;
    }
  }

  /** Zwraca lewe poddrzwo.
      @return Zwraca lewe poddrzewo lub warto null, jeli korze lub lewe
      poddrzewo jest rwne null.
   */
  public BinaryTree < E > getLeftSubtree() {
    if (root != null && root.left != null) {
      return new BinaryTree < E > (root.left);
    }
    else {
      return null;
    }
  }

  /** Zwraca prawe poddrzwo.
      @return Zwraca prawe poddrzewo lub warto null, jeli korze lub prawe
      poddrzewo jest rwne null.
    */
    public BinaryTree<E> getRightSubtree() {
        if (root != null && root.right != null) {
            return new BinaryTree<E>(root.right);
        } else {
            return null;
        }
    }


/**** WICZENIE ****/

  /** Sprawdza, czy drzewo jest liciem.
      @return Zwraca warto true, jeli drzewo nie ma dzieci.
   */
  public boolean isLeaf() {
    return (root.left == null && root.right == null);
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    preOrderTraverse(root, 1, sb);
    return sb.toString();
  }

  /** Dokonuje przejcia przez drzewo w porzdku preorder.
      @param node Lokalny korze.
      @param depth Gbia.
      @param sb Bufor tekstowy zapamitujcy dane wyjciowe.
   */
  private void preOrderTraverse(Node < E > node, int depth,
                                StringBuilder sb) {
    for (int i = 1; i < depth; i++) {
      sb.append("  ");
    }
    if (node == null) {
      sb.append("null\n");
    }
    else {
      sb.append(node.toString());
      sb.append("\n");
      preOrderTraverse(node.left, depth + 1, sb);
      preOrderTraverse(node.right, depth + 1, sb);
    }
  }

  /** Metoda odczytujca drzewo binarne.
      pocz: Wejcia zawiera tekst przejcia przez drzewo w porzdku preorder.
           Wiersz "null" wskazuje puste drzewo.
      @param bR Plik wejciowy.
      @return Drzewo binarne.
      @throws Wyjtek IOException w przypadku bdu wejcia-wyjcia.
   */
  public static BinaryTree < String >
      readBinaryTree(BufferedReader bR) throws IOException {
    //Odczytaj wiersz i pozbad si pocztkwych i kocowych znakw spacji.
    String data = bR.readLine().trim();
    if (data.equals("null")) {
      return null;
    }
    else {
      BinaryTree < String > leftTree = readBinaryTree(bR);
      BinaryTree < String > rightTree = readBinaryTree(bR);
      return new BinaryTree < String > (data, leftTree, rightTree);
    }
  }

}
