import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import java.util.*;

/** Klasa TwoDimGrid to dwuwymiarowa tablica komrek.
 *  Kady przycisk moe by zmieniany mdzy doma kolorami:
 *  wystarczy go klikn. Ewentualnie kolor przycisku
 *  moe zmieni program wykonujcy zadania.
 *  @author Koffman and Wolfgang
* */

public class TwoDimGrid
    extends JPanel
    implements GridColors {

  // pola danych
  /** Zalecany rozmiar przycisku. */
  private static final int PREFERED_BUTTON_SIZE = 60;

  /** Domylna liczba wierszy. */
  private static final int DEFAULT_COLS = 20;

  /** Domylna liczba kolumn. */
  private static final int DEFAULT_ROWS = 20;

  /** Dwuwumiarowa siatka przyciskw. */
  private JButton[][] theGrid;

  /** Liczba wierszy. */
  private int nRows;

  /** Liczba kolumn. */
  private int nCols;

  // konstruktor
  /** Tworzy obiekt TwoDimGrid o podanych wymiarach i kolorach.
   *  @param nRows Liczba wierszy.
   *  @param nCols Liczba kolumn.
   */
  public TwoDimGrid(int nRows, int nCols) {
    this.nRows = nRows;
    this.nCols = nCols;
    setPreferredSize(new Dimension(nCols * PREFERED_BUTTON_SIZE,
                                   nRows * PREFERED_BUTTON_SIZE));
    setLayout(new GridLayout(nRows, nCols));
    theGrid = new JButton[nCols][];
    for (int i = 0; i != nCols; ++i) {
      theGrid[i] = new JButton[nRows];
      for (int j = 0; j != nRows; ++j) {
        theGrid[i][j] = new JButton(i + ", " + j);
        theGrid[i][j].setBackground(BACKGROUND);
        theGrid[i][j].addActionListener
            (new ToggleColor(theGrid[i][j]));
      }
    }

    // Dodanie przycisku do paneli przyciskw.
    for (int j = 0; j != nRows; ++j) {
      for (int i = 0; i != nCols; ++i) {
        add(theGrid[i][j]);
      }
    }
  }

  // metody ustawiajce i pobierajce
  /** Pobiera liczb kolumn.
   *  @return nCols */
  public int getNCols() {
    return nCols;
  }

  /** Pobiera liczb wierszy.
   *  @return nRows */
  public int getNRows() {
    return nRows;
  }

  /** Pobiera kolor z podanych wsprzdnych.
   *  @param x Numer kolumny.
   *  @param y Numer wiersza.
   *  @return Kolor na podanych wsprzdnych. */
  public Color getColor(int x, int y) {
    return theGrid[x][y].getBackground();
  }

  /** Zmienia kolor dla podanych wsprzdnych.
   *  @param x Numer kolumny.
   *  @param y Numer wiersza.
   * @param newColor Nowy kolor przycisku. */
  public void recolor(int x, int y, Color newColor) {
    theGrid[x][y].setBackground(newColor);
  }

  /** Ustawia kolor kadego kwadratu siatki, ktry odpowiada
   *  elementom tablicy z wartoci 1.
   *  @param bitMap Tablica 0 i 1 o takich samych wymiarach jak siatka.
   *  @param aColor Kolor do ustawienia.
   *  @throws Wyjtek ArrayIndexOutOfBounds, jeli rozmiary siatki i tablicy
   *  rni si.  */
  public void recolor(char[][] bitMap, Color aColor) {
    for (int i = 0; i != bitMap.length; ++i) {
      for (int j = 0; j != bitMap[i].length; ++j) {
        if (bitMap[i][j] == '1') {
          theGrid[j][i].setBackground(aColor);
        }
      }
    }
  }

  public void recolor(Color tempColor, Color newColor) {
    for (int i = 0; i != getNCols(); ++i) {
      for (int j = 0; j != getNRows(); ++j) {
        if (theGrid[i][j].getBackground().equals(tempColor))
          theGrid[i][j].setBackground(newColor);
      }
    }
  }

  // klasa wewntrzna
  /** Klasa ActionListener zmieniajca kolor po dokonaniu kliknicia. */
  private class ToggleColor
      implements ActionListener {
    // pole danych
    /** Sprawdzany przycisk. */
    private JButton me;

    // konstruktor
    /** Tworzy obiekt ToggleColor object dla podanego przycisku.
     *  @param theButton Przycisk, do ktrego docza si zdarzenie. */
    public ToggleColor(JButton theButton) {
      me = theButton;
    }

    // metoda
    /** Akcja wywoywana w odpowiedzi na kliknicie.
     *  @param e Ignorowanie obiektu zdarzenia. */
    public void actionPerformed(ActionEvent e) {
      if (me.getBackground().equals(BACKGROUND)) {
        me.setBackground(ABNORMAL);
      }
      else {
        me.setBackground(BACKGROUND);
      }
    }
  }
}
