/* Klasa metod rekurencyjnych.
   @author Koffman and Wolfgang
 */

public class RecursiveMethods {

  /** Rekurencjna metoda wyszukiwania binarnego (z RecursiveMethods.java).
    @param items Przeszukiwana tablica.
    @param target Poszukiwany element.
    @param first Indeks pierwszego elementu.
    @param last Indeks ostatniego elementu.
    @return Indeks znalezionego celu; w przeciwnym razie 1.
   */
  private static int binarySearch(Object[] items, Comparable target,
                                  int first, int last) {
    if (first > last)
      return -1; // Przypadek bazowy dla nieudanego wyszukiwania.
    else {
      int middle = (first + last) / 2; // Nastpny indeks do sprawdzenia.
      int compResult = target.compareTo(items[middle]);
      if (compResult == 0)
        return middle; // Przypadek bazowy udanego wyszukiwania.
      else if (compResult < 0)
        return binarySearch(items, target, first, middle - 1);
      else
        return binarySearch(items, target, middle + 1, last);
    }
  }

  /** Otoczka dla rekurencyjnej metody wyszukiwania binarnego (z RecursiveMethods.java).
      @param items Przeszukiwana tablica.
      @param target Poszukiwany element.
      @return Indeks znalezionego celu; w przeciwnym razie 1.
   */
  public static int binarySearch(Object[] items, Comparable target) {
    return binarySearch(items, target, 0, items.length - 1);
  }

  /** Rekurencyjne okrelanie dugoci (z RecursiveMethods.java).
    @param str Tekst.
    @return Dugo tekstu.
   */
  public static int length(String str) {
    if (str == null || str.equals(""))
      return 0;
    else
      return 1 + length(str.substring(1));
  }

  /** Rekurencyjne wywietlanie znakw (z RecursiveMethods.java).
      koc: Podany tekst wejciowy jest wywietlany w taki sposb, i kady
            znak znajduje si w osobnym wierszu.
      @param str Tekst.
   */
  public static void printChars(String str) {
    if (str == null || str.equals("")) {
      return;
    }
    else {
      System.out.println(str.charAt(0));
      printChars(str.substring(1));
    }
  }

  /** Rekurencyjne wywietlanie znakw (z RecursiveMethods.java).
      koc: Podany tekst wejciowy jest wywietlany w taki sposb, i kady
            znak znajduje si w osobnym wierszu. Tekst jest napisany wspak.
      @param str Tekst.
   */
  public static void printCharsReverse(String str) {
    if (str == null || str.equals("")) {
      return;
    }
    else {
      printCharsReverse(str.substring(1));
      System.out.println(str.charAt(0));
    }
  }

  /** Rekurencyjna metoda wyliczajca silni (z RecursiveMethods.java).
      pocz: n >= 0
      @param n Warto cakowita, dla ktrej zostaje wyliczona silnia.
      @return n!
   */
  public static int factorial(int n) {
    if (n == 0)
      return 1;
    else
      return n * factorial(n - 1);
  }

  /** Rekurencyjna metoda potgujca (z RecursiveMethods.java).
      pocz: n >= 0
      @param x Warto podnoszona do potgi.
      @param n Wykadnik.
      @return Warto x podniesiona do potgi n.
   */
  public static double power(double x, int n) {
    if (n == 0)
      return 1;
    else
      return x * power(x, n - 1);
  }

  /** Rekurencyjne okrelanie NWD (z RecursiveMethods.java).
      pocz: m > 0 i n > 0
      @param m Wiksza liczba.
      @param n Mniejsza liczba.
      @return Najwikszy wsplny dzielnik m i n.
   */
  public static double gcd(int m, int n) {
    if (m % n == 0)
      return n;
    else if (m < n)
      return gcd(n, m); // Zamiana argumentw.
    else
      return gcd(n, m % n);
  }

  /** Rekurencyjny sposb wyznaczania liczb Fibonacciego
      (z RecursiveMethods.java).
      pocz: n >= 1
      @param n Pozycja wyliczanej liczby Fibonacciego w cigu.
      @return Liczba Fibonacciego
   */
  public static int fibonacci(int n) {
    if (n <= 2)
      return 1;
    else
      return fibonacci(n - 1) + fibonacci(n - 2);
  }

  /** Rekurencyjna metoda wyliczania liczb Fibonacciego o zoonoci O(n)
      (z RecursiveMethods.java).
      pocz: n >= 1
      @param fibCurrent Aktualna liczba Fibonacciego
      @param fibPrevious Poprzednia liczba Fibonacciego.
      @param n Licznik liczb Fibonacciego do wyliczenia.
      @return Liczba Fibonacciego uzyskana do tej pory.
   */
  private static int fibo(int fibCurrent, int fibPrevious, int n) {
    if (n == 1)
      return fibCurrent;
    else
      return fibo(fibCurrent + fibPrevious, fibCurrent, n - 1);
  }

  /** Metoda opakowujca obliczanie liczby Fibonacciego
      (z RecursiveMethods.java).
      pocz: n >= 1
      @param n Pozycja wyliczanej liczby Fibonacciego w cigu.
      @return Liczba Fibonacciego
   */
  public static int fibonacciStart(int n) {
    return fibo(1, 0, n);
  }

  /** Rekurencyjna, liniowa metoda wyszukiwania (z RecursiveMethods.java).
    @param items Przeszukiwana tablica.
    @param target Poszukiwany element.
    @param posFirst Pooenie aktualnego pierwszego elementu.
    @return Indeks znalezionego elementu; w przeciwnym razie 1.
   */
  private static int linearSearch(Object[] items,
                                  Object target, int posFirst) {
    if (posFirst == items.length)
      return -1;
    else if (target.equals(items[posFirst]))
      return posFirst;
    else
      return linearSearch(items, target, posFirst + 1);
  }

  /** Metoda otoczkowa dla rekurencyjnej, liniowej metody wyszukiwania (z
     RecursiveMethods.java).
    @param items Przeszukiwana tablica.
    @param target Poszukiwany element.
    @return Indeks znalezionego elementu; w przeciwnym razie 1.
   */
  public static int linearSearch(Object[] items, Object target) {
    return linearSearch(items, target, 0);
  }

}
