import java.io.*;
import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/*  Klasa testujca Maze.java.
    @author Koffman and Wolfgang
 */

public class MazeTest
    extends JFrame
    implements GridColors, ActionListener {

  // pole danych
  private TwoDimGrid theGrid; // dwuwymiarowa siatka przyciskw

  /** Odczytuje dane z pliku i definiuje tablic bitMap */
  public static void main(String[] args) {
    try {
      if (args.length < 1) {
        /** Nie podano nazwy pliku. */
        String reply =
            JOptionPane.showInputDialog("Wpisz liczb wierszy");
        int nRows = Integer.parseInt(reply);
        reply =
            JOptionPane.showInputDialog("Wpisz liczb kolumn");
        int nCols = Integer.parseInt(reply);
        TwoDimGrid aGrid = new TwoDimGrid(nRows, nCols);
        new MazeTest(aGrid);
      }
      else {
        /** Utworzenie bitmapy z pliku wejciowego. */
        BufferedReader br =
            new BufferedReader(new FileReader(args[0]));

        /** Odczytaj kaduy wiersz danych do
            gridArrayList. Kady element to tablica znakw. */
        ArrayList gridArrayList = new ArrayList();
        String line;
        while ( (line = br.readLine()) != null) {
          char[] row = line.toCharArray();
          gridArrayList.add(row);
        }

        /** bitMap to tablica 2D uzyskana na podstawie gridArrayList */
        char[][] bitMap = (char[][]) gridArrayList.toArray
            (new char[gridArrayList.size()][]);
        int nRows = bitMap.length;
        int nCols = bitMap[0].length;

        /** Utwrz obiekt TwoDimGrid i zmie jego kolory zgodnie z bitmap. */
        TwoDimGrid aGrid = new TwoDimGrid(nRows, nCols);
        aGrid.recolor(bitMap, ABNORMAL);
        new MazeTest(aGrid);
      }
    }
    catch (Exception ex) {
      System.err.println("Wyjtek " + ex);
      ex.printStackTrace();
      // System.exit(1);
    }
  }

  /** Tworzy interfejs graficzny. */
  private MazeTest(TwoDimGrid aGrid) {
    theGrid = aGrid;
    getContentPane().add(aGrid, BorderLayout.CENTER);
    Blob aBlob = new Blob(aGrid);
    JTextArea instruct = new JTextArea(2, 20);
    instruct.setText("Kliknij przycisk, by zmieni jego kolor."
                     + "\nNacinij ROZWI, gdy bdziesz gotowy.");
    getContentPane().add(instruct, BorderLayout.NORTH);
    JButton solveButton = new JButton("ROZWI");
    solveButton.addActionListener(this);
    getContentPane().add(solveButton, BorderLayout.SOUTH);
    setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    pack();
    show();
  }

  public void actionPerformed(ActionEvent e) {
    Maze m = new Maze(theGrid);
    boolean found = m.findMazePath();
    if (found)
      JOptionPane.showMessageDialog(null, "Sukces - zresetuj labirynt i sprbuj ponownie.");
    else
      JOptionPane.showMessageDialog(null, "Brak cieki - zresetuj labirynt i sprbuj ponownie.");
  }
}
