import java.awt.*;

/** Klasa rozwizujca problem zliczania nietypowych komrek.
*   @author Koffman and Wolfgang
* */

public class Blob
    implements GridColors {

  /** Siatka. */
  private TwoDimGrid grid;

  /** Konstruktor. */
  public Blob(TwoDimGrid grid) {
    this.grid = grid;
  }

  /** Znajduje liczb komrek plamy o wsprzdnych (x,y).
      pocz: Nietypowe komrki maj kolor ABNORMAL;
           wszystkie inne maj kolor BACKGROUND.
      koc: Wszystkie komrki plamy przyjy kolor TEMPORARY.
      @param x Wsprzdna X komrki wewntrz plamy.
      @param y Wsprzdna Y komrki wewntrz plamy.
      @return Liczba komrek plamy zawierajcej punkt (x, y)
   */
  public int countCells(int x, int y) {
    int result;

    if (x < 0 || x >= grid.getNCols()
        || y < 0 || y >= grid.getNRows())
      return 0;
    else if (!grid.getColor(x, y).equals(ABNORMAL))
      return 0;
    else {
      grid.recolor(x, y, TEMPORARY);
      return 1
          + countCells(x - 1, y + 1) + countCells(x, y + 1)
          + countCells(x + 1, y + 1) + countCells(x - 1, y)
          + countCells(x + 1, y) + countCells(x - 1, y - 1)
          + countCells(x, y - 1) + countCells(x + 1, y - 1);
    }
  }
}
