import java.util.*;

/** Implementuje interfejs Queue za pomoc listy jednokierunkowej.
*   @author Koffman & Wolfgang
* */

public class ListQueue < E > extends AbstractQueue < E >
    implements Queue < E > {

  // pola danych
  /** Referencja do pocztku kolejki. */
  private Node < E > front;

  /** Referencja do koca kolejki. */
  private Node < E > rear;

  /** Rozmiar kolejki. */
  private int size;

  /** Klasa Node stanowica podstawowy bloczek listy jednokierunkowej. */
  private static class Node < E > {
    // pola danych
    /** Referencja do obiektu danych. */
    private E data;

    /** Referencja do nastpnego wza. */
    private Node next;

    // konstruktory
    /** Tworzy nowy wze z polem next ustawionym na null.
        @param dataItem Obiekt do umieszczenia na licie.
     */
    private Node(E dataItem) {
      data = dataItem;
      next = null;
    }

    /** Tworzy nowy wze wskazujcy na inny wze.
        @param dataItem Obiekt do umieszczenia na licie.
        @param nodeRef Referencja do wza, na ktry ma wskazywa nowy wze.
     */
    private Node(E dataItem, Node < E > nodeRef) {
      data = dataItem;
      next = nodeRef;
    }
  } // koniec klasy Node

  // metody
  /** Wstawia element na kocu kolejki.
      koc: Element zosta dodany na kocu kolejki.
      @param item Element do dodania.
      @return Warto true (wstawienie zawsze jest udane).
   */
  public boolean offer(E item) {
    // Sprawdzenie, czy kolejka jest pusta.
    if (front == null) {
      rear = new Node < E > (item);
      front = rear;
    }
    else {
      // Alokacja nowego wza na kocu, zapamitaniew nim elementu i
      // doczenie wza do koca kolejki.
      rear.next = new Node < E > (item);
      rear = rear.next;
    }
    size++;
    return true;
  }

  /** Usunicie elementu z pocztku kolejki i zwrcenie go, jeli
      kolejka nie jest pusta.
      koc: Pole front zawiera referencj do elementu, ktry wczeniej by drugi.
      @return Usuwany element w razie sukcesu, warto null w przypadku przeciwnym.
   */
  public E poll() {
    E item = peek(); // Pobranie elementu z pocztku kolejki.
    if (item == null)
      return null;
    // Usunicie go z pocztku kolejki.
    front = front.next;
    size--;
    return item; // Zwrcenie usuwanego elementu.
  }

  /** Zwraca element z pocztku kolejki bez jego usuwania.
      @return Element z pocztku w razie sukcesu, warto null w przypadku przeciwnym.
   */
  public E peek() {
    if (size == 0)
      return null;
    else
      return front.data;
  }

  // Wstaw klas Iter i pozostae wymagane metody.
/**** WICZENIE ****/
}
