import java.util.*;

/** Implementuje interfejs Queue, korzystajc z komponentu LinkedList.
*   @author Koffman & Wolfgang
* */

public class KWQueue < E >
    implements Queue < E > {

  // pole danych
  private LinkedList < E > theQueue
      = new LinkedList < E > (); // Obiekt LinkedList jako kolejka.

  /** Wstawia element na kocu kolejki.
      @param item Wstawiany element.
      @return Warto true (wstawienie zawsze jest udane).
   */
  public boolean offer(E item) {
    theQueue.addLast(item);
    return true;
  }

  /** Zwraca i usuwa element z pocztku kolejki.
      @return Usuwany element w razie sukcesu, warto null w przypadku przeciwnym.
   */
  public E poll() {
    if (size() == 0)
      return null;
    else
      return theQueue.remove(0);
  }

  /** Zwraca element z pocztku kolejki bez jego usuwania.
      @return Element z pocztku w razie sukcesu, warto null w przypadku przeciwnym.
   */
  public E peek() {
    if (size() == 0)
      return null;
    else
      return theQueue.getFirst();
  }

/**** WICZENIE ****/
}
