import java.util.*;

/** Klasa wyliczajca wyraenia w odwrotnej notacji polskiej.
*   @author Koffman & Wolfgang
* */

public class PostfixEvaluator {

  // klasa zagniedona
  /** Klasa zgaszajca bd skadniowy. */
  public static class SyntaxErrorException
      extends Exception {
    /** Konstruuje wyjtek SyntaxErrorException ze wskazanym komunikatem.
        @param message Komunikat.
     */
    SyntaxErrorException(String message) {
      super(message);
    }
  }

  // staa
  /** Lista operatorw. */
  private static final String OPERATORS = "+-*/";

  // pole danych
  /** Stos operandw. */
  private Stack < Integer > operandStack;

  // metody
  /** Wylicza aktualn operacj.
      Metoda zdejmuje ze stosu dwa operandy i stosuje dla nich operator.
      @param op Znak reprezentujcy operator.
      @return Wynik zastosowania operatora.
      @throws Zgasza wyjtek EmptyStackException, jeli prbowano zdj co
              z pustego stosu.
   */
  private int evalOp(char op) {
    // Zdejmuje ze stosu dwa operandy.
    int rhs = operandStack.pop();
    int lhs = operandStack.pop();
    int result = 0;
    // Wylicza operator.
    switch (op) {
      case '+':
        result = lhs + rhs;
        break;
      case '-':
        result = lhs - rhs;
        break;
      case '/':
        result = lhs / rhs;
        break;
      case '*':
        result = lhs * rhs;
        break;

    }
    return result;
  }

  /** Sprawdza, czy znak jest operatorem.
      @param op Testowany znak.
      @return Warto true, jeli znak jest operatorem.
   */
  private boolean isOperator(char ch) {
    return OPERATORS.indexOf(ch) != -1;
  }

  /** Wylicza wyraenie w odwrotnej notacji polskiej.
      @param expression Wyraenie do wyliczenia.
      @return Warto wyraenia.
      @throws Zgasza wyjtek SyntaxErrorException, jeli wykryto bd skadniowy.
   */
  public int eval(String expression) throws SyntaxErrorException {
    // Tworzy pusty stos.
    operandStack = new Stack < Integer > ();

    // Przetwarza tokeny.
    StringTokenizer tokens = new StringTokenizer(expression);
    try {
      while (tokens.hasMoreTokens()) {
        String nextToken = tokens.nextToken();
        // Czy rozpoczyna si od cyfry?
        if (Character.isDigit(nextToken.charAt(0))) {
          // Pobranie wartoci cakowitej.
          int value = Integer.parseInt(nextToken);
          // Umieszczenie wartoci na stosie operandw.
          operandStack.push(value);
        } // Czy to operator?
        else if (isOperator(nextToken.charAt(0))) {
          // Wyliczenie operatora.
          int result = evalOp(nextToken.charAt(0));
          // Umieszczenie wyniku na stosie operandw.
          operandStack.push(result);
        }
        else {
          // Niepoprawne znaki.
          throw new SyntaxErrorException(
              "Natknito si na nieznane znaki.");
        }
      } // Koniec ptli while.

      // Nie ma wicej tokenw - zdejmij wynik ze stosu operandw.
      int answer = operandStack.pop();
      // Stos operandw powinien by pusty.
      if (operandStack.empty()) {
        return answer;
      }
      else {
        // Wskazuje bd skadniowy.
        throw new SyntaxErrorException(
            "Bd skadniowy: stos powinien by pusty");
      }
    }
    catch (EmptyStackException ex) {
      // Prba pobrania elementu z pustego stosu.
      throw new SyntaxErrorException(
          "Bd skadniowy: stos jest pusty");
    }
  }
}
