import java.util.Stack;
import java.util.EmptyStackException;
import javax.swing.JOptionPane;

/** Klasa sprawdzajca zrwnowaenie nawisw.
*   @author Koffman & Wolfgang
* */

public class ParenChecker {

  // stae
  /** Zbir znakw nawiasw otwierajcych. */
  private static final String OPEN = "([{";

  /** Zbir znakw nawiasw zamykajcych, odpowiada kolejnoci z OPEN. */
  private static final String CLOSE = ")]}";

  /** Sprawdza podany tekst wejciowy pod ktem zrwnowaenia nawiasw.
      Metoda ta testuje tekst, by sprawdzi, czy odpowiadaj sobie kolejne
      zagniedenia nawiasw. Czy '(' odpowiada
       ')', '[' odpowiada ']' i '{' odpowiada '}'.
      @param expression Tekst zawierajcy wyraenie do sprawdzenia.
      @return Warto true, jeli wszystkie nawiasy pasuj do siebie.
   */
  public static boolean isBalanced(String expression) {
    // Tworzy pusty stos.
    Stack < Character > s = new Stack < Character > ();
    boolean balanced = true;
    try {
      int index = 0;
      while (balanced && index < expression.length()) {
        char nextCh = expression.charAt(index);
        if (isOpen(nextCh)) {
          s.push(nextCh);
        }
        else if (isClose(nextCh)) {
          char topCh = s.pop();
          balanced = OPEN.indexOf(topCh)
              == CLOSE.indexOf(nextCh);
        }
        index++;
      }
    }
    catch (EmptyStackException ex) {
      balanced = false;
    }
    return (balanced && s.empty());
  }

  /** Metoda sprawdza, czy podany znak jest nawiasem otwierajcym.
      @param ch Znak do sprawdzenia.
      @return Warto true, jeli ch jest nawiasem otwierajcym.
   */
  private static boolean isOpen(char ch) {
    return OPEN.indexOf(ch) > -1;
  }

  /** Metoda sprawdza, czy podany znak jest nawiasem zamykajcym.
      @param ch Znak do sprawdzenia.
      @return Warto true, jeli ch jest nawiasem zamykajcym.
   */
  private static boolean isClose(char ch) {
    return CLOSE.indexOf(ch) > -1;
  }

  /** Metoda pocztkowa. Prosi uytkownika o wpisanie tekstu i
      wywouje metod ParenChecker() w celu sprawdzenia zrwnowaenia nawiasw.
      @param args Nieuywane.
   */
  public static void main(String args[]) {
    String expression = JOptionPane.showInputDialog(
        "Wpisz wyraenie zawierajce nawiasy");
    if (ParenChecker.isBalanced(expression)) {
      JOptionPane.showMessageDialog(null, expression
                                    + " jest zrwnowaone");
    }
    else {
      JOptionPane.showMessageDialog(null, expression
                                    + " nie jest zrwnowaone");
    }
    System.exit(0);
  }
}
