import java.util.*;

/** Klasa ListStack<E> implementuje interfejs StackInt<E> jako
*   adapter korzystajcy z List. Implementacja ta ma funkcjonalno
*   rwnowan klasie java.util.Stack<E>, ale jej wewntrzna struktura
*   zwizana z List<E> nie jest publicznie dostpna.
*   @author Koffman & Wolfgang
*/

public class ListStack < E >
    implements StackInt < E > {

  /** Lista zawierajca dane. */
  private List < E > theData;

  /** Wykonanie pustego stosu za pomoc klasy ArrayList sucej
      jako pojemnik. */
  public ListStack() {
    theData = new ArrayList < E > ();
  }

  /** Umieszcza obiekt na stosie.
      koc: Obiekt znajduje si na szczycie stosu.
      @param obj Obiekt do umieszczenia
      @return Umieszczony obiekt.
   */
  public E push(E obj) {
    theData.add(obj);
    return obj;
  }

  /** Zwraca obiekt ze szczytu stosu bez jego zdejmowania.
      @return Obiekt ze szczytu stosu.
      @throws Zgasza wyjtek EmptyStackException, jeli stos jest pusty.
   */
  public E peek() {
    if (empty()) {
      throw new EmptyStackException();
    }
    return theData.get(theData.size() - 1);
  }

  /** Zwraca obiekt ze szczytu stosu i usuwa go ze stosu.
      koc: Stos maleje o jeden element.
      @return Obiekt ze szczytu stosu.
      @throws Zgasza wyjtek EmptyStackException, jeli stos jest pusty.
   */
  public E pop() {
    if (empty()) {
      throw new EmptyStackException();
    }
    return theData.remove(theData.size() - 1);
  }

  /** Sprawdza, czy stos jest pusty.
      @return Zwraca warto true, jeli stos jest pusty.
   */
  public boolean empty() {
    return theData.size() == 0;
  }
}
