import java.util.EmptyStackException;

/** Klasa implementujca interfejs StackInt<E> jako list.
*   @author Koffman & Wolfgang
* */

public class LinkedStack < E >
    implements StackInt < E > {

  /** Klasa Node stanowica podstawowy bloczek listy jednokierunkowej. */
  private static class Node < E > {
    // pola danych
    /** Referencja do obiektu danych. */
    private E data;

    /** Referencja do nastpnego wza. */
    private Node next;

    // konstruktory
    /** Tworzy nowy wze z polem next ustawionym na null.
        @param dataItem Obiekt do umieszczenia na licie.
     */
    private Node(E dataItem) {
      data = dataItem;
      next = null;
    }

    /** Tworzy nowy wze wskazujcy na inny wze.
        @param dataItem Obiekt do umieszczenia na licie.
        @param nodeRef Referencja do wza, na ktry ma wskazywa nowy wze.
     */
    private Node(E dataItem, Node < E > nodeRef) {
      data = dataItem;
      next = nodeRef;
    }
  } // koniec klasy Node

  // pola danych
  /** Referencja do pierwszego wza listy. */
  private Node < E > topOfStackRef = null;

  /** Umieszcza obiekt na szczycie stosu i zwraca referencj do niego.
      koc: Nowy element znajduje si na szczycie stosu.
            Pozostae elementy znajduj si poniej niego.
      @param obj Obiekt do wstawienia.
      @return Wstawiony obiekt.

   */
  public E push(E obj) {
    topOfStackRef = new Node < E > (obj, topOfStackRef);
    return obj;
  }

  /** Zwraca obiekt ze szczytu stosu i usuwa go ze stosu.
      pocz: Stos nie jest pusty.
      koc: Stos maleje o jeden element, ktry znajdowa si na jego szczycie.
      @return Obiekt ze szczytu stosu.
      @throws Zgasza wyjtek EmptyStackException, jeli stos jest pusty.
   */
  public E pop() {
    if (empty()) {
      throw new EmptyStackException();
    }
    else {
      E result = topOfStackRef.data;
      topOfStackRef = topOfStackRef.next;
      return result;
    }
  }

  /** Zwraca element ze szczytu stosu.
      pocz: Stos nie jest pusty.
      koc: stos pozostaje niezmieniony.
      @return Obiekt ze szczytu stosu.
      @throws Zgasza wyjtek EmptyStackException, jeli stos jest pusty.
   */
  public E peek() {
    if (empty()) {
      throw new EmptyStackException();
    }
    else {
      return topOfStackRef.data;
    }
  }

  /** Sprawdza, czy stos jest pusty.
      @return Zwraca warto true, jeli stos jest pusty.
   */
  public boolean empty() {
    return topOfStackRef == null;
  }
}
