import java.util.EmptyStackException;

/** Implementacja interfejsu StackInt<E> stosujca tablic.
*   @author Koffman & Wolfgang
*/

public class ArrayStack < E >
    implements StackInt < E > {

  // pola danych
  /** Miejsce dla stosu. */
  E[] theData;
  /** Indeks szczytu stosu. */
  int topOfStack = -1; // Stos jest pocztkowo pusty.
  private static final int INITIAL_CAPACITY = 10;

  /** Utworzenie pustego stosu o pocztkowej pojemnoci.
   */
  public ArrayStack() {
    theData = (E[])new Object[INITIAL_CAPACITY];
  }

  /** Wstawianie elementu naszczycie stosu.
      koc: Nowy element znajduje si naszczycie stosu.
            Wszystkie pozostae elementy znajduj si niej.
      @param obj Element do wstawienia.
      @return Wstawiony obiekt.
   */
  public E push(E obj) {
    if (topOfStack == theData.length - 1) {
      reallocate();
    }
    topOfStack++;
    theData[topOfStack] = obj;
    return obj;
  }

  /** Usuwa i zwraca element ze szczytu stosu.
      pocz: Stos nie jest pusty.
      koc: Element ze szczytu stosu zosta usunity.
            Stos pomniejszy si o jeden element.
      @return Element ze szczytu stosu.
      @throws Zgasza wyjtek EmptyStackException, jeli stos jest pusty.
   */
  public E pop() {
    if (empty()) {
      throw new EmptyStackException();
    }
    return theData[topOfStack--];
  }

/**** WICZENIE ****/
}
