import java.util.*;

/** Przechodzi przez posortowan list i wywietla jej elementy.
   *  Wywietla komunikat bdu, jeli kolejno elementw nie jest poprawna.
   *  @param testList Posortowana lista liczb cakowitych.
   *  @author Koffman & Wolfgang
*/

public class TestOrderedList {

  public static void traverseAndShow(OrderedList < Integer > testList) {
    int prevItem = testList.get(0);

    // Przechodzi przez posortowan list i wywietla kad warto,
    // ktra nie jest poprawna.
    for (int thisItem : testList) {
      System.out.println(thisItem);
      if (prevItem > thisItem)
        System.out.println("*** BD, pobrano warto "
                           + thisItem);
      prevItem = thisItem;
    }
  }

  public static void main(String[] args) {
    OrderedList < Integer > testList = new OrderedList < Integer > ();
    final int MAX_INT = 500;
    final int START_SIZE = 100;

    // Wykorzystanie generoatora liczb losowych do wypenienia listy.
    Random random = new Random();
    for (int i = 0; i < START_SIZE; i++) {
      int anInteger = random.nextInt(MAX_INT);
      testList.add(anInteger);
    }

    // Dodanie elementu na pocztku i na kocu listy.
    testList.add( -1);
    testList.add(MAX_INT + 1);
    traverseAndShow(testList); // Przejcie przez list i wywietlenie wartoci.

    // Usunicie pierwszego elementu, ostatniego elementu i elementu ze rodka listy.
    Integer first = testList.get(0);
    Integer last = testList.get(testList.size() - 1);
    Integer middle = testList.get(testList.size() / 2);
    testList.remove(first);
    testList.remove(last);
    testList.remove(middle);
    traverseAndShow(testList); // Przejcie przez list i wywietlenie wartoci.
  }
}
