import java.util.*;

/** Klasa reprezentujca posortowan list. Dane przechowywane s w polu
*   danych listy dwukierunkowej.
*   @author Koffman & Wolfgang
*/

public class OrderedList<E extends Comparable<E>>
        implements Iterable<E> {
    /** Lista zawierajca dane. */
    private LinkedList<E> theList = new LinkedList<E>();

  public OrderedList() {
    theList = new LinkedList < E > ();
  }

  /** Wstawia obj do listy, zachowujc posortowanie listy.
      pocz: Elementy listy s uoone w porzdku rosncym.
      koc: Obiekt obj zosta wstawiony do listy a lista
      nadal jest niemalejca.
      @param obj Element do wstawienia.
   */
  public void add(E obj) {
    ListIterator < E > iter = theList.listIterator();
    // Znajd pooenie odpowiednie do wstawienia elementu i wstaw obiekt.
    while (iter.hasNext()) {
      if (obj.compareTo(iter.next()) < 0) {
        // Iterator przeszed nad pierwszym elementem wikszym od
        // elementu wstawianego.
        // Cofnij iterator o jedn pozycj.
        iter.previous();
        // Wstaw element.
        iter.add(obj);
        // Zakocz ptl i metod.
        return;
      }
    }
    // asercja: Wszystkie elementy zostay sprawdzone i aden z nich nie
    // okaza si wikszy od wstawionego elementu.
    // Dodaj nowy element na kocu listy.
    iter.add(obj);
  }

  /** Zwraca element na podanej pozycji.
      @param index Ineks okrelajcy pozycj.
      @return Element na pozycji index.
   */
  E get(int index) {
    return theList.get(index);
  }

/**** WICZENIE ****/
}
