import java.util.*;

/** Klasa KWLinkedList implementuje list dwukierunkow oraz ListIterator.
 *  @author Koffman & Wolfgang
 * */

public class KWLinkedList < E > {
  // pola danych
  /** Referencja na pocztek listy (gow). */
  private Node < E > head = null;

  /** Referencja na koniec listy (ogon). */
  private Node < E > tail = null;

  /** Rozmiar listy. */
  private int size = 0;

  // metody
/**** WICZENIE ****/

  /** Dodaje element w miejscu o wskazanym indeksie.
      @param index Pooenie, w ktrym ma zosta wstawiony obiekt.
      @param obj Obiekt do wstawienia.
      @throws Wyjtek IndexOutOfBoundsException,jeli index znajduje si
              poza zakresem (i < 0 || i > size())
   */
  public void add(int index, E obj) {
    listIterator(index).add(obj);
  }

  /** Pobiera element na pozycji index.
      @param index Pooenie elementu do pobrania.
      @return Element o indeksie index.
   */
  public E get(int index) {
    return listIterator(index).next();
  }

  // klasy wewntrzne

  /** Klasa Node to podstawowy bloczek listy dwukierunkowej. */
  private static class Node < E > {
    /** Przechowywane dane. */
    private E data;

    /** Wskanik na nastpny wze. */
    private Node < E > next = null;

    /** Wskanik na poprzedni wze. */
    private Node < E > prev = null;

    /** Tworzy wze na podstawie przekazanych danych.
        @param dataItem Warto danych.
     */
    private Node(E dataItem) {
      data = dataItem;
    }
  } // koniec klasy Node

  /** Klasa wewntrzna implementujca interfejs ListIterator. */
  private class KWListIter implements ListIterator < E > {
    /** Referencja do nastpnego elementu. */
    private Node < E > nextItem;

    /** Referencja do ostatnio zwrconego elementu. */
    private Node < E > lastItemReturned;

    /** Indeks aktualnego elementu. */
    private int index = 0;

    /** Tworzy KWListIter, ktry bdzie wskazywa na i-ty element.
        @param i Indeks elementu, na ktry ma wskazywa referencja.
     */
    public KWListIter(int i) {
      // Walidacja parametru.
      if (i < 0 || i > size) {
        throw new IndexOutOfBoundsException(
            "Invalid index " + i);
      }
      lastItemReturned = null; // Nie zwrcono jeszcze elementu.
      // Przypadek szczeglny - ostatni element.
      if (i == size) {
        index = size;
        nextItem = null;
      }
      else { // Rozpoczcie od pocztku.
        nextItem = head;
        for (index = 0; index < i; index++) {
          nextItem = nextItem.next;
        }
      }
    }

    /** Sprawdza, czy moliwy jest ruch w przd.
        @return Zwraca true, jeli wywoanie next() nie spowoduje wyjtku.
     */
    public boolean hasNext() {
      return nextItem != null;
    }

    /** Przesuwa iterator w przd i zwraca nastpny element.
        @return Kolejny element listy.
        @throws Wyjtek NoSuchElementException, jeli nie ma kolejnego obiektu.
     */
    public E next() {
      if (!hasNext()) {
        throw new NoSuchElementException();
      }
      lastItemReturned = nextItem;
      nextItem = nextItem.next;
      index++;
      return lastItemReturned.data;
    }

    /** Sprawdz, czy moliwy jest ruch w ty.
        @return Warto true, jeli wywoanie previous() nie spowoduje wyjtku.
     */
    public boolean hasPrevious() {
      return (nextItem == null && size != 0)
          || nextItem.prev != null;
    }

    /** Zwraca indeks kolejnego elementu, ktry na zosta zwrcony przez metod next().
        @return Indeks elementu, ktry zostanie zwrcony przez next().
     */
    public int nextIndex() {
      return index;
    }

    /** Zwraca indeks poprzedniego elementu, ktry na zosta zwrcony przez metod previous().
        @return Indeks elementu, ktry zostanie zwrcony przez previous().
     */
    public int previousIndex() {
      return index - 1;
    }

    /** Przesuwa iterator w ty i zwraca poprzedni element.
        @return Poprzedni element listy.
        @throws Wyjtek NoSuchElementException, jeli nie ma takiego obiektu.
     */
    public E previous() {
      if (!hasPrevious()) {
        throw new NoSuchElementException();
      }
      if (nextItem == null) { // iterator za ostatnim elementem
        nextItem = tail;
      }
      else {
        nextItem = nextItem.prev;
      }
      lastItemReturned = nextItem;
      index--;
      return lastItemReturned.data;
    }

/** Dodanie nowego elementu midzy elementem, ktry zostay zwrcony
    przez metod next() i elementem, ktry zwrciaby metoda previous().
    Jeli metoda previous() zostanie wywoana po dodaniu, zostanie
    zwrcony dodany element.
    @param obj Element do wstawienia.
 */
public void add(E obj) {
  if (head == null) { // Dodanie do pustej listy.
    head = new Node < E > (obj);
    tail = head;
  }
  else if (nextItem == head) { // Wstawienie na pocztku.
    // Utworzenie wza.
    Node < E > newNode = new Node < E > (obj);
    // Poczenie go z nextItem.
    newNode.next = nextItem; // 1. krok
    // Poczenie nextItem z nowym wzem.
    nextItem.prev = newNode; // 2. krok
    // Nowy wze jest teraz gow listy.
    head = newNode; // 3. krok
  }
  else if (nextItem == null) { // Wstawienie na kocu.
    // Utworzenie wza.
    Node < E > newNode = new Node < E > (obj);
    // Poczenie tail z nowym wzem.
    tail.next = newNode; // 1. krok
    // Poczenie nowego wza z tail.
    newNode.prev = tail; // 2. krok
    // Nowy wze jest teraz nowym ogonem listy.
    tail = newNode; // 3. krok
  }
  else { // Wstawianie w rodku.
    // Utworzenie wza.
    Node < E > newNode = new Node < E > (obj);
    // Poczenie go z nextItem.prev.
    newNode.prev = nextItem.prev; // 1. krok
    nextItem.prev.next = newNode; // 2. krok
    // Poczenie go z nextItem.
    newNode.next = nextItem; // 3. krok
    nextItem.prev = newNode; // 4. krok
  }
  // Inkrementacja zmiennej index i ustawienie lastItemReturned.
  size++;
  index++;
  lastItemReturned = null;
} // koniec metody

    /** Usuwa ostatnio zwrcony element. Mona wywoa t metod tylko raz
     *  na kade wywoane metody next() lub previous().
     *  @throws Zgasza wyjtekIllegalStateException, jeli next() lub previous()
     *  nie zostao wywoane przed t metod.
     */
/**** WICZENIE ****/

  } // koniec klasy KWListIter
}
