package drawableShapes;
import javax.swing.*;

/** Reprezentuje prostokt.
*   Implementuje ShapeInt.
*   @author Koffman & Wolfgang
*/

public class Rectangle
    implements ShapeInt {

  // pola danych
  /** Szeroko prostokta. */
  private int width = 0;

  /** Wysoko prostokta. */
  private int height = 0;

  // konstruktory
  /** Tworzy prostokt o podanych wymiarach.
      @param wid Szeroko.
      @param hei Wysoko.
   */
  public Rectangle(int wid, int hei) {
    width = wid;
    height = hei;
  }
  /** Tworzy domylny prostokt.
   */
  public Rectangle() {}


  // metody
  /** Pobiera szeroko.
      @return Szeroko.
   */
  public int getWidth() {
    return width;
  }

  /** Pobiera wysoko.
      @return Wysoko.
   */
  public int getHeight() {
    return height;
  }

  /** Wylicza pole.
      @return Pole prostokta.
   */
  public double computeArea() {
    return height * width;
  }

  /** Wylicza obwd.
      @return Obwd prostokta.
   */
  public double computePerimeter() {
    return 2 * (height + width);
  }

  /** Odczytuje parametry prostokta. */
  public void readShapeData() {
    String widthStr = JOptionPane.showInputDialog
        ("Wpisz szeroko prostokta");
    width = Integer.parseInt(widthStr);
    String heightStr = JOptionPane.showInputDialog
        ("Wpisz wysoko prostokta");
    height = Integer.parseInt(heightStr);
  }

  /** Tworzy tekstow reprezentacj prostokta.
      @return Tekstowa reprezentacja prostokta.
   */
  public String toString() {
    return "Prostokt: szeroko wynosi " + width + ", wysoko wynosi " + height;
  }

}
