package drawableShapes;
import java.awt.*;

/** Reprezentuje trjkt, ktry mona narysowa.
*   Implementuje ShapeInt.
*   @author Koffman & Wolfgang
*/

public class DrawableTriangle
    extends DrawableShape {

  // konstruktor
  /** Tworzy obiekt DrawableTriangle o podanym kolorze i pooeniu.
      @param bas Podstawa.
      @param hei Wysoko.
      @param poi Pooenie dolnego lewego naronika.
      @param border Kolor konturu.
      @param inter Kolor wypenienia.
   */
  public DrawableTriangle(int bas, int hei,
                          Point poi, Color border, Color inter) {
    super(poi, border, inter, new RtTriangle(bas, hei));
  }

  // metody
  /** Rysuje trjkt, wykorzystujc przekazany kontekst graficzny.
      @param g Kontekst graficzny.
   */
  public void drawMe(Graphics g) {
    Polygon rtTri = new Polygon();
    RtTriangle triangle = (RtTriangle) theShape;
    rtTri.addPoint(pos.x, pos.y);
    rtTri.addPoint(pos.x, pos.y - triangle.getHeight());
    rtTri.addPoint(pos.x + triangle.getBase(), pos.y);
    g.setColor(interiorColor);
    g.fillPolygon(rtTri);
    g.setColor(borderColor);
    g.drawPolygon(rtTri);
  }

  /** Tworzy tekstow reprezentacj trjkta.
      @return Tekstowa reprezentacja trjkta.
  */
  public String toString() {
    return "Rysowalny " + theShape + super.toString();
  }
}
