package drawableShapes;
import java.awt.*;

/** Reprezentuje okrg, ktry mona narysowa.
*   Implementuje ShapeInt.
*   @author Koffman & Wolfgang
*/

public class DrawableCircle
    extends DrawableShape {

  // konstruktor
  /** Tworzy obiekt DrawableCircle o podanym promieniu, pooeniu i kolorze.
      @param rad Promie.
      @param poi Wsprzdne rodka.
      @param border Kolor konturu.
      @param inter Kolor wypenienia.
   */
  public DrawableCircle(int rad,
                        Point poi, Color border, Color inter) {
    super(poi, border, inter, new Circle(rad));
  }

  // metody
  /** Rysuje okrg.
      @param g Kontekst graficzny (ekran).
   */
  public void drawMe(Graphics g) {
    g.setColor(interiorColor);
    Circle circle = (Circle) theShape;
    g.fillOval(pos.x - circle.getRadius(),
               pos.y - circle.getRadius(),
               2 * circle.getRadius(), 2 * circle.getRadius());
    g.setColor(borderColor);
    g.drawOval(pos.x - circle.getRadius(),
               pos.y - circle.getRadius(),
               2 * circle.getRadius(), 2 * circle.getRadius());
  }

  /** Tworzy tekstow reprezentacj okrgu.
      @return Tekstowa reprezentacja okrgu.
   */
  public String toString() {
    return "Rysowalny " + theShape + super.toString();
  }
}
