package drawableShapes;
import javax.swing.JOptionPane;

/**
*  Oblicza pole i obwd dla wybranych figur.
*  @author Koffman and Wolfgang
*/

public class ComputeAreaAndPerim {

  /** Gwna cz programu wykonuje nastpujce kroki.
      1. Prosi uytkownika o okrelenie figury.
      2. Prosi o podanie charakterystyki wybranej figury.
      3. Oblicza obwd
      4. Oblicza pole.
      5. Wywietla wyniki
      @param args Argumenty wiersza polecenia (nieuywane)
   */
  public static void main(String args[]) {
    ShapeInt myShape;
    double perimeter;
    double area;
    myShape = getShape(); // prosi o typ figury
    myShape.readShapeData(); // odczytuje charakterystyk figury
    perimeter = myShape.computePerimeter(); // wylicza obwd
    area = myShape.computeArea(); // wylicza pole
    displayResult(area, perimeter); // wywietla wynik
    System.exit(0); // wyjcie z programu
  }

  /** Prosi uytkownika o wpisanie typu figury.
      @return Egzemplarz wybranego ksztatu.
   */
  public static ShapeInt getShape() {
    String figType = JOptionPane.showInputDialog(
        "Wpisz O dla okrgu\nWpisz P dla prostokta\n"
        + "Wpisz T dla trjkta prostoktnego");
    if (figType.equalsIgnoreCase("o")) {
      return new Circle();
    }
    else if (figType.equalsIgnoreCase("p")) {
      return new Rectangle();
    }
    else if (figType.equalsIgnoreCase("t")) {
      return new RtTriangle();
    }
    else {
      return null;
    }
  }

  /** Wywietla wynik oblicze.
      @param area Pole figury.
      @param perim Obwd figury.
   */
  private static void displayResult(double area, double perim) {
    JOptionPane.showMessageDialog(null, "Pole wynosi " + area
                                  + "\nObwd wynosi " + perim);
  }
}
