/** Zawiera metod statyczn wyszukiwania wartoci w tablicy.
 *  @author Koffman & Wolfgang
 * */

public class ArraySearch {

  /** Przeszukuje tablic wposzukiwaniu pierwszego wystpienia wartoci.
      @param x Tablica do przeszukania.
      @param target Szukana warto
      @return Indeks pierwszego wystpienia wartoci;
              przy jej braku zwrcenie -1.
   */
  public static int search(int[] x, int target) {
    for (int i = 0; i < x.length; i++) {
      if (x[i] == target)
        return i;
    }

    // celu nie znaleziono
    return -1;
  }

  /** Metoda z testami.
      @param args Argumenty wiersza polece (nieuywane).
   */
  public static void main(String[] args) {
    int[] x = {
        5, 12, 15, 4, 8, 12, 7}; // Tablica do przeszukania.

    // Szukana warto znajduje si w pierwszym elemencie.
    verify(x, 5, 0);
    // Szukana warto znajduje si w ostatnim elemencie.
    verify(x, 7, 6);
    // Szukanej wartoci nie ma w tablicy.
    verify(x, -5, -1);
    // Test wielu wystpie wartoci w tablicy.
    verify(x, 12, 1);
    // Szukana warto znajduje si w rodku tablicy.
    verify(x, 4, 3);

    // Test dla tablicy jednoelementowej.
    x = new int[1];
    x[0] = 10;
    verify(x, 10, 0);
    verify(x, -10, -1);

    // Test dla tablicy pustej.
    x = new int[0];
    verify(x, 10, -1);
  }

  /** Wywouje metod wyszukiwania z podanymi parametrami i
      weryfikuje spodziewane wyniki.
      @param x Tablica do przeszukania.
      @param target Warto do odnalezienia.
      @param expected Spodziewany wynik.
   */
  private static void verify(int[] x, int target, int expected) {
    int actual = search(x, target);
    System.out.print("search(x, " + target + ") wynosi "
                     + actual + ", oczekiwano " + expected);
    if (actual == expected)
      System.out.println(":  zaliczono");
    else
      System.out.println(":  ****oblano");
  }
}
