import java.util.*;

/** Klasa implementuje interfejs PDUserInterface i uywa
 *  konsoli do wywietlania menu i wynikw.
 *   @author Koffman & Wolfgang
 */
public class PDConsoleUI
    implements PDUserInterface {

  /** Referencja do obiektu PhoneDirectory zawierajcego ksik telefoniczn.
      Dostpna w sposb globalny dla metod przetwarzania polece.
   */
  private PhoneDirectory theDirectory = null;

  /** Obiekt Scanner odczytujcy dane z konsoli. */
  private Scanner scIn = null;

  // konstruktor
  /** Konstruktor domylny. */
  public PDConsoleUI() {
    scIn = new Scanner(System.in);
  }

  // metody
  /** Metoda wywietlajca menu i przetwarzajca polecenia uytkownika.
      pocz: Ksika telefoniczna istnieje i zostaa odczytana z pliku.
      koc: Ksika zostaje uaktualniona zgodnie z poleceniami uytkownika.
      @param thePhoneDirectory Referencja do obiektu PhoneDirectory
             zawierajcego ksik telefoniczn.
   */
  public void processCommands(PhoneDirectory thePhoneDirectory) {
    String[] commands = {
        "Dodaj/Zmie wpis",
        "Szukaj wpisu",
        "Kasuj wpis",
        "Zapisz ksik",
        "Wyjcie"};

    theDirectory = thePhoneDirectory;
    int choice;
    do {
      for (int i = 0; i < commands.length; i++) {
        System.out.println("Wybierz " + i + ": "
                           + commands[i]);
      }
      try {
        choice = scIn.nextInt(); // Odczytaj wybr.
        scIn.nextLine(); // Pomi znak nowego wiersza.
        switch (choice) {
          case 0:
            doAddChangeEntry();
            break;
          case 1:
            doLookupEntry();
            break;
          case 2:
            doRemoveEntry();
            break;
          case 3:
          case 4:
            doSave();
            break;
          default:
            System.out.println("*** Niepoprawny wybr: "
                               + choice
                               + " - sprbuj ponownie!");
        }
      }
      catch (InputMismatchException ex) {
        System.out.println("*** Niepoprawne dane - "
                           + "wpisz liczb cakowit midzy 0 a "
                           + (commands.length-1));
        scIn.nextLine(); // Pomi bdne wejcie.
        choice = -1;
      }
    }
    while (choice != commands.length - 1);
    System.exit(0);
  }

  /** Metoda dodajca lub modyfikujca wpis.
      pocz: Ksika telefoniczna istnieje i zostaa odczytana z pliku.
      koc: Zostaje dodana nowa osoba lub jeli istniaa, zmienia si jej
            numer telefonu, zmienna modified zostaje ustawiona na true.
   */
  private void doAddChangeEntry() {
    // Proba o podanie nazwiska.
    System.out.println("Wpisz nazwisko");
    String newName = scIn.nextLine();
    if (newName.equals("")) {
      return;
    }
    // Proba o podanie numeru telefonu.
    System.out.println("Wpisz numer telefonu");
    String newNumber = scIn.nextLine();
    if (newNumber.equals("")) {
      return;
    }
    // Wstaw lub zmie par nazwisko-numer.
    String oldNumber =
        theDirectory.addOrChangeEntry(newName, newNumber);
    String message;
    if (oldNumber == null) { // nowy wpis
      message = newName + " zosta dodany do spisu."
          + "\nNowy numer: " + newNumber;
    }
    else { // zmiana wpisu
      message = "Numer dla " + newName + " zosta zmieniony."
          + "\nStary numer: " + oldNumber
          + "\nNowy numer: " + newNumber;
    }
    // Wywietl komunikat potwierdzenia.
    System.out.println(message);
  }

  /** Metoda wyszukujca wpis.
      pocz: Ksika telefoniczna zostaa wypeniona danymi.
      koc: Nie dokonuje zmian w ksice.
   */
  private void doLookupEntry() {
    // Proba o podanie nazwiska.
    System.out.println("Wpisz nazwisko");
    String theName = scIn.nextLine();
    if (theName.equals("")) {
      return; // Nie podano nazwiska.
    }
    // Wyszukanie nazwiska.
    String theNumber = theDirectory.lookupEntry(theName);
    String message;
    if (theNumber != null) { // znaleziono nazwisko
      message = "Numer telefonu do " + theName + " to " + theNumber;
    }
    else { // nazwiska nie znaleziono
      message = theName + " nie zosta znaleziony w ksice telefonicznej.";
    }
    // Wywietlenie wyniku.
    System.out.println(message);
  }

  /** Metoda usuwajca wpis.
       pocz: Ksika jest wypeniona danymi.
       koc: Podane nazwisko zostaje usunite, zmienna modifed przyjmuje warto true.
   */
  private void doRemoveEntry() {
/**** WICZENIE ****/
  }

  /** Metoda zapisujca zawarto ksiki w pliku.
      pocz: Ksika jest wypeniona danymi.
      koc: Aktualna zawarto ksiki telefonicznej zostaje umieszczona w pliku.
   */
  private void doSave() {
    theDirectory.save();
  }
}
