/*---------------------------------------------------------------------------*/
    #include <stdio.h>
    #include <stdlib.h>
    #include <sys/ptrace.h>
    #include <sys/wait.h>
    #include <errno.h>
    #include <signal.h>

    #include "hware_bp.h"    /* prototypy set_bp(), unset_bp( ), itp. */

    #define DEBUG_SYSCALL    0x01
    #define DEBUG_TRACE      0x02

    unsigned long get_rva( char *c ) {
        unsigned long rva;
        while ( *c && ! isalnum( *c ) )
            c++;
        if ( c && *c )
            rva = strtoul( c, NULL, 16 );
        return(rva);
    }
    
    void print_regs( int pid ) {
        struct user_regs_struct regs;
        if (ptrace( PTRACE_GETREGS, pid, NULL, &regs) != -1 ) {
            printf("CS:IP %04X:%08X\t SS:SP %04X:%08X FLAGS %08X\n",
                regs.cs, regs.eip, regs.ss, regs.esp, regs.eflags);
            printf("EAX %08X \tEBX %08X \tECX %08X \tEDX %08X\n",
                regs.eax, regs.ebx, regs.ecx, regs.edx );
        }
        return;
    }

    void handle_sig( int pid, int signal, int flags ) {
        enum bp_status status;

        if ( signal == SIGTRAP ) {
            printf("Proces potomny zatrzymany na ");

            /* sprawdzenie czy przyczyn byy rejestry debugowania */
            status = get_bp_status( pid );
            if ( status == bp_trace ) {
                printf("ledzeniu\n");
            } else if  ( status == bp_task ){
                printf("przeczaniu zada\n");
            } else if ( status == bp_perm ) {
                printf("prbie dostpu do rejestrw debugowania \n");
            } else if ( status != bp_unk ) {
                printf("sprztowym punkcie wstrzymania\n");
            } else {
                /* nope */
                if ( flags & DEBUG_SYSCALL ) {
                    printf("wywoaniu systemowym\n");
                } else if ( flags & DEBUG_TRACE ) {
                    /* to powinno zosta wykryte przez bp_trace */
                    printf("ledzeniu\n");
                }
            }

        }
        return;
    }

    int main( int argc, char **argv) {
          int mode, pid, status, flags = 0, err = 0, cont = 1;
        char *c, line[256];

        /* sprawdzenie argumentw */
        if ( argc == 3 && argv[1][0] == '-' && argv[1][1] == 'p' ) {
            pid = strtoul( argv[2], NULL, 10 );
            mode = MODE_ATTACH;
        } else if ( argc >= 2 ) {
            mode = MODE_LAUNCH;
        } else {
            printf( "Uycie: debug [-p pid] [nazwa_pliku] [argumenty...]\n");
            return(-1);
        }

        /* uruchomienie lub doczenie si do badanego programu w zalenoci od trybu */

        if ( mode == MODE_ATTACH ) {
              printf("ledzenie PID: %x\n", pid);
              err = ptrace( PTRACE_ATTACH, pid, 0, 0);
        } else {
            if ( (pid = fork( )) < 0 ) {
                fprintf(stderr, "Bd fork( ): %s\n", strerror(errno));
                return(-2);
            } else if ( pid ) {
                  printf("Wykonywanie %s PID: %x\n", argv[1], pid);
                wait(&status);

            } else {
                err = ptrace( PTRACE_TRACEME, 0, 0, 0);
                if ( err == -1 ) {
                    fprintf(stderr, "Bd TRACEME: %s\n", 
                        strerror(errno));
                    return(-3);
                }
                return( execv(argv[1], &argv[1]) );
            }
        }

          while ( cont && err != -1 ) {
              print_regs( pid );
              printf("debug:");
              fgets( line, 256, stdin );
              for ( c = line; *c && !(isalnum(*c)) ; c++ )
                  ;
                switch (*c) {
                case 'b':
                    set_bp(pid, get_rva(++c), len_byte, bp_x);
                    break;
                case 'r':
                    unset_bp(pid, get_rva(++c));
                    break;
                case 'c':
                            err = ptrace( PTRACE_CONT, pid, NULL, NULL);
                    wait(&status);
                    break;
                case 's':
                    flags |= DEBUG_SYSCALL;
                            err = ptrace( PTRACE_SYSCALL, pid, NULL, NULL);
                    wait(&status);
                    break;
                case 'q':
                            err = ptrace( PTRACE_KILL, pid, NULL, NULL);
                    wait(&status);
                    cont = 0;
                    break;
                case 't':
                    flags |= DEBUG_TRACE;
                            err = ptrace(PTRACE_SINGLESTEP, pid, NULL, NULL);
                    wait(&status);
                    break;
                case '?':
                default:
                    printf("b [adr] - ustalenie punktu wstrzymania\n"
                         "r [adr] - usunicie punktu wstrzymania \n"
                           "c        - kontynuacja\n"
                           "s        - kontynuacja do wywoania lub wyjcia z wywoania systemowego \n"
                           "q        - unicestwienie procesu\n"
                           "t        - praca krokowa\n" );
                    break;
            }
            if ( WIFEXITED(status) ) {
                printf("Proces potomny zakoczy z %d\n", WEXITSTATUS(status));
                return(0);
            } else if ( WIFSIGNALED(status) ) {
                printf("Proces potomny otrzyma sygna %d\n", WTERMSIG(status));
                handle_sig( pid, WTERMSIG(status), flags ); 
            }
        }
        if ( err == -1 ) 
            printf("Bd: %s\n", strerror(errno));
          ptrace( PTRACE_DETACH, pid, 0, 0);
        wait(&status);
          return(0);
    }
/*-------------------------------------------------------------------*/
