/*---------------------------------------------------------------------------*/
    #include <errno.h>
    #include <fcntl.h>
    #include <stdio.h>
    #include <stdlib.h>
    #include <sys/stat.h>
    #include <sys/types.h>
    #include <unistd.h>

    #include <bfd.h>

    /* zwraca warto true w przypadku sekcji, ktre nie bd kopiowane do pliku wyjciowego */
    static int skip_section( bfd *b, asection *s ) {
        /* opuszczenie informacji debugowania */
        if ( (bfd_get_section_flags( b, s ) & SEC_DEBUGGING) ) 
            return( 1 );
        /* usunicie zbdnych rzeczy */
        if ( ! strcmp( s->name, ".comment" ) )
            return( 1 );
        if ( ! strcmp( s->name, ".note" ) )
            return( 1 );
    
        return(0);
    }

    struct COPYSECTION_DATA {
        bfd * output_bfd;
        asymbol **syms;
        int sz_syms, sym_count;
    };

    static void copy_section( bfd *infile, asection *section, PTR data ){
	long true=1;
        asection *s;
        unsigned char *buf;
        long size, count, sz_reloc;
        struct COPYSECTION_DATA *d = data;
        bfd *outfile = d->output_bfd;
        asymbol **syms = d->syms;

        if ( skip_section( infile, section ) ) 
            return;
    
        /* pobranie sekcji wyjciowej ze struktury sekcji wejciowej */
        s = section->output_section;
        /* pobranie rozmiaru */
        size = bfd_get_section_size_before_reloc (section );
        sz_reloc = bfd_get_reloc_upper_bound( infile, section );

        if ( ! sz_reloc ) {
            /* brak relokacji */
            bfd_set_reloc( outfile, s, (arelent **) NULL, 0);
        } else if ( sz_reloc  > 0 ) {
            /* budowanie relokacji */
            buf = calloc( sz_reloc, 1 );
            /* zamiana relokacji binarnych na wewntrzn reprezentacj BFD */
            /* Z info: "Tabela SYMS jest potrzebna z jaki 
               magicznych, wewntrznych powodw". Nie artuj. 
               Witamy w dungli. */
            count = bfd_canonicalize_reloc(infile, section, 
                                 (arelent **)buf, syms );
            /* w tym miejscu mona si pozby niepotrzebnych symboli */
            /* ustalenie relokacji sekcji wyjciowej */
            bfd_set_reloc( outfile, s, (arelent **) ((count) ? 
                                    buf : NULL), count );
            free( buf );
        }
    
        /* dziaanie na prywatnych danych BFD bez wyranej przyczyny */
        section->_cooked_size = section->_raw_size;
        section->reloc_done = true;
    
        /* pobranie zawartoci sekcji wejciowej, ustalenie zawartoci sekcji wyjciowej */
        if ( section->flags & SEC_HAS_CONTENTS ) {
            buf = calloc( size, 1 );
            bfd_get_section_contents( infile, section, buf, 0, size );
            bfd_set_section_contents( outfile, s, buf, 0, size );
            free( buf );
        }
        return;
    }


    static void define_section( bfd *infile, asection *section, PTR data ){
        bfd *outfile = (bfd *) data;
        asection *s;

        if ( skip_section( infile, section ) ) 
            return;

        /* nie wiadomo czemu to si nazywa "anyway"... */
        s = bfd_make_section_anyway( outfile, section->name );
        /* rozmiar taki sam, jak w sekcji pliku wejciowego */
        bfd_set_section_size( outfile, s, bfd_section_size(infile, 
                                           section) );
        /* ustalenie adresu wirtualnego */
        s->vma =  section->vma;
        /* ustalenie adresu adowania */
        s->lma =  section->lma;
        /* ustalenie wyrwnania -- uyta zostanie potga liczby 2 */
        s->alignment_power = section->alignment_power;
        bfd_set_section_flags(outfile, s, 
                    bfd_get_section_flags(infile, section));
        /* czenie sekcji wyjciowej z sekcj wejciow -- prosz nie pyta si po co */
        section->output_section = s;
        section->output_offset = 0;
        /* kopiowanie prywatnych danych BFD z sekcji wyjciowej do wyjciowej */
        bfd_copy_private_section_data( infile, section, outfile, s );
        return;
    }

    int file_copy( bfd *infile, bfd *outfile ) {
        struct COPYSECTION_DATA data = {0};
    
        if ( ! infile || ! outfile )    return(0);
    
        /* ustalenie parametrw wyjciowych ustawie infile */
        bfd_set_format( outfile, bfd_get_format(infile) );
        bfd_set_arch_mach(outfile, bfd_get_arch(infile), 
                            bfd_get_mach(infile));
        bfd_set_file_flags( outfile, bfd_get_file_flags(infile) &  
                        bfd_applicable_file_flags(outfile) );
        /* ustalenie punktu wejcia w pliku wyjciowym */
        bfd_set_start_address( outfile, bfd_get_start_address(infile) );
    
        /* definiowanie sekcji pliku wynikowego */
        bfd_map_over_sections( infile, define_section, outfile );
    
        /* pobranie tabeli symboli pliku wejciowego */
        data.sz_syms = bfd_get_symtab_upper_bound( infile );
        data.syms = calloc( data.sz_syms, 1 );
    
        /* zamiana danych symboli binarnych na wewntrzny format BFD */
        data.sym_count = bfd_canonicalize_symtab( infile, data.syms );
    
        /* w tym miejscu tabel symboli mona sprawdza za pomoc instrukcji
               for ( i=0; i < data.sym_count; i++ ) 
                   asymbol *sym = data.syms[i];
           ...i tak dalej, sprawdzajc sym->name, sym->value, and sym->flags */
    
        /* tworzenie tabeli symboli pliku wyjciowego */
        bfd_set_symtab( outfile, data.syms, data.sym_count );
    
        /* kopiowanie zawartoci sekcji z pliku wejciowego do wyjciowego */
        data.output_bfd = outfile;
        bfd_map_over_sections( infile, copy_section, &data );
    
        /* kopiowanie wszystkich dziwnych danych potrzebnych BFD */
        bfd_copy_private_bfd_data( infile, outfile );
        return(1);
    }
    
    int main( int argc, char **argv ) {
             struct stat s;
        bfd *infile, *outfile;

          if ( argc < 3 ) {
                    fprintf(stderr, "Uycie: %s plik_wejciowy plik_wyjciowy\n", argv[0]);
                return(1);
          }
          if ( stat( argv[1], &s) ) {
                fprintf(stderr, "Bd: %s\n", strerror(errno) );
                return(2);
          }

        bfd_init( );

        /* otwarcie pliku wejciowego do czytania */
        infile = bfd_openr( argv[1], NULL );
        if ( ! infile ) {
            bfd_perror( "Bd w pliku wejciowym" );
            return(3);
        }
        /* otwarcie pliku wyjciowego do zapisu */
        outfile = bfd_openw( argv[2], NULL );
        if ( ! outfile ) {
            bfd_perror( "Bd w pliku wyjciowym" );
            return(4);
        }

        if ( bfd_check_format (infile, bfd_object ) ) {
            /* procedura, ktra wykonuje ca prac */
            file_copy( infile, outfile );
        } else if ( bfd_check_format(infile, bfd_archive ) ) {
            fprintf( stderr, "Bd: pliki archiww nie s obsugiwane\n");
            return(5);
        }

        bfd_close(outfile);
        bfd_close(infile);
    
          return(0);
    }
/*---------------------------------------------------------------------------*/
