/*---------------------------------------------------------------------------*/
    #include <elf.h>

    unsigned long elf_header_read( unsigned char *buf, int buf_len ){
        Elf32_Ehdr *ehdr = (Elf32_Ehdr *)buf;
        Elf32_Phdr *ptbl = NULL, *phdr;
        Elf32_Dyn  *dtbl = NULL, *dyn;
        Elf32_Sym  *symtab = NULL, *sym;
        char       *strtab = NULL, *str;
        int         i, j, str_sz, sym_ent, size;
        unsigned long offset, va;    /* pozycja pliku, adres wirtualny */
        unsigned long entry_offset;    /* pooenie w pliku punktu wejcia */

        /* ustawienie pooenia domylnego punktu wejcia */
        entry_offset =  ehdr->e_entry;

        /* przejcie przez tabel nagwkw segmentw programu */
        ptbl = (Elf32_Phdr *)(buf + ehdr->e_phoff);

        for ( i = 0; i < ehdr->e_phnum; i++ ) {        
            phdr = &ptbl[i];

            if ( phdr->p_type == PT_LOAD ) {
                /* Segment adowalny: kod programu lub dane */
                offset = phdr->p_offset;
                va = phdr->p_vaddr;
                size = phdr->p_filesz;

                if ( phdr->p_flags & PF_X ) {
                    /* to jest sekcja kodu */
                } else if ( phdr->p_flags & (PF_R | PF_W) ){
                    /* to s dane do odczytu i do zapisu */
                } else if (phdr->p_flags & PF_R ) {
                    /* to s dane tylko do odczytu */
                }    /* zignorowanie pozostaych sekcji */

                /* sprawd czy zawiera punkt wejcia */
                if ( va <= ehdr->e_entry && 
                     (va + size) > ehdr->e_entry ) {
                    entry_offset = offset + (entry - va);
                }

            } else if ( phdr->p_type == PT_DYNAMIC ) {
                /* informacje czenia dynamicznego: procedury zaimportowane */
                dtbl = (Elf32_Dyn *) (buf + phdr->p_offset);

                for ( j = 0; j < (phdr->p_filesz / 
                        sizeof(Elf32_Dyn)); j++ ) {
                    dyn = &dtbl[j];
                    switch ( dyn->d_tag ) {
                    case DT_STRTAB:
                        strtab = (char *)
                            dyn->d_un.d_ptr;
                        break;
                    case DT_STRSZ:
                        str_sz = dyn->d_un.d_val;
                        break;
                    case DT_SYMTAB:
                        symtab = (Elf32_Sym *)
                            dyn->d_un.d_ptr;
                        break;
                    case DT_SYMENT:
                        sym_ent = dyn->d_un.d_val;
                        break;
                    case DT_NEEDED:
                        /* dyn->d_un.d_val jest indeksem
                           nazwy biblioteki w strtab */
                        break;
                    }
                }
            
            }    /* ignorowanie pozostaych nagwkw programu */
        }

        /* drugi przebieg w poszukiwaniu symtab i strtab */
        for ( i = 0; i < ehdr->e_phnum; i++ ) {
            phdr = &ptbl[i];

            if ( phdr->p_type == PT_LOAD ) {
                if ( strtab >= phdr->p_vaddr && strtab < 
                    phdr->p_vaddr + phdr->p_filesz ) {
                    strtab = buf + phdr->p_offset + 
                        ((int) strtab - phdr->p_vaddr);
                }
                if ( symtab >= phdr->p_vaddr && symtab < 
                            phdr->p_vaddr + 
                            phdr->p_filesz ) {
                    symtab = buf + phdr->p_offset + 
                        ((int) symtab - phdr->p_vaddr);
                }
            }
        }

        if ( ! symtab )    {
            fprintf(stderr, "brak symtab!\n");
            return(0);
        }
        if ( ! strtab )    {
            fprintf(stderr, "brak strtab!\n");
            return(0);
        }
        /* obsuga symboli funkcji i procedur biblioteki wspdzielonej */
        size = strtab - (char *)symtab;    /* strtab wystpuje po symtab */

        for ( i = 0; i < size / sym_ent; i++ ) {
            sym = &symtab[i];
            str = &strtab[sym->st_name];

            if ( ELF32_ST_TYPE( sym->st_info ) == STT_FUNC ){
                /* ten symbol jest nazw funkcji */
                offset = sym->st_value;

                if ( sym->st_shndx ) {
                /* 'str' == procedura w pliku pod adresem 'offset' */
                    ;
                } else {
                /* 'str' == nazwa zaimportowanej funkcji pod adresem 'offset' */
                    ;
                }
            }    /* zignorowanie pozostaych symboli */
        }

        /* powrt do punktu wejcia */
        return( entry_offset );
    }
/*----------------------------------------------------------------------*/
