/* 
 * Bhrama Client-Server Interface 0.3
 * (c)1999 CindyG
 *
 * bhrama_internal.h : internal interface definitions
 */

#ifndef _BHRAMA_INTERNAL_H_
#define _BHRAMA_INTERNAL_H_

#include "bhrama.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Bhrama Server Identification */
#define BHRAMA_SERVER_ID	"ProcDump32 - Dumper Server"
#define BHRAMA_VERSION      0x00000003

/* Bhrama Service Identifiers */
#define BHRAMA_QUERY_PID		0
#define	BHRAMA_DUMP_PID			1
#define BHRAMA_DUMP_PID_PART	2

/* Bhrama Communication Structures */
#ifdef _WIN32
#include <pshpack1.h>	/* force byte packing */
#endif

typedef struct {
	DWORD	handle;
} BHRAMA_QUERY_STRUCT, *PBHRAMA_QUERY_STRUCT;

typedef struct {
	DWORD	eip;
	DWORD	delay;
	BYTE	internal_predump;
	BYTE	delayed_predump;		/* set if delay != 0 */
	BYTE	ignore_faults;
	BYTE	no_eip_confirm;
	BYTE	no_layer_confirm;
	BYTE	trace_api;
	BYTE	recompute_object_size;
	BYTE	optimize_pe;
	BYTE	rebuild_relocations;
	BYTE	rebuild_header;
	BYTE	rebuild_import;
	BYTE	force_raw_mode;
	BYTE	merge_code;
	BYTE	check_header;
	BYTE	show_disassembly;		/* not implemented yet */
	BYTE	_reserved;
} BHRAMA_DUMP_STRUCT, *PBHRAMA_DUMP_STRUCT;

typedef struct {
	DWORD	start;
	DWORD	length;
} BHRAMA_DUMPPART_STRUCT, *PBHRAMA_DUMPPART_STRUCT;

typedef struct {
	DWORD	version;
	DWORD	pid;
	union {
		BHRAMA_QUERY_STRUCT		query;
		BHRAMA_DUMP_STRUCT		dump;
		BHRAMA_DUMPPART_STRUCT	dumppart;
	};
} BHRAMA_IPC_STRUCT, *PBHRAMA_IPC_STRUCT;

#ifdef _WIN32
#include <poppack.h>
#endif

/* Prototypes */
HWND bhrama_getserverhandle();
BOOL bhrama_ipc(DWORD pid, DWORD function, PBHRAMA_IPC_STRUCT bhrama);

#ifdef __cplusplus
};
#endif
#endif /* _BHRAMA_INTERNAL_H_ */