;*************************************************************************
;
;       WIN32.INC - Win32 assembly language structures & constants
;
;
;*************************************************************************
;
; Modified , enhanced by G-RoM.
;
;*************************************************************************
UNICODE=0

UCHAR   EQU <db>
USHORT  EQU <dw>  ; used only if we really need 16 bits
UINT    EQU <dd>  ; 32 bits for WIN32
ULONG   EQU <dd>
HANDLE  EQU <dd>
BOOL	typedef DWORD
LPSTR	typedef DWORD
LPBYTE	typedef DWORD
LPVOID	typedef	DWORD
LPCSTR	typedef	DWORD
L 	equ <LARGE>
WINAPI	EQU PROTO STDCALL
NULL	EQU 0
FALSE	EQU 0
TRUE	EQU 1
;
;------------------------------------------------------------------------------
;
; =====================
; CreateProcess() flags
; =====================
;
DEBUG_PROCESS			equ	00000001h
DEBUG_ONLY_THIS_PROCESS		equ	00000002h
CREATE_SUSPENDED		equ	00000004h
DETACHED_PROCESS		equ	00000008h
CREATE_NEW_CONSOLE		equ	00000010h
NORMAL_PRIORITY_CLASS		equ	00000020h
IDLE_PRIORITY_CLASS		equ	00000040h
HIGH_PRIORITY_CLASS		equ	00000080h
REALTIME_PRIORITY_CLASS		equ	00000100h
;
CREATE_NEW_PROCESS_GROUP	equ	00000200h
CREATE_UNICODE_ENVIRONMENT	equ	00000400h
CREATE_SEPARATE_WOW_VDM		equ	00000800h
CREATE_SHARED_WOW_VDM		equ	00001000h
CREATE_DEFAULT_ERROR_MODE	equ	04000000h
CREATE_NO_WINDOW		equ	08000000h
;
PROFILE_USER			equ	10000000h
PROFILE_KERNEL			equ	20000000h
PROFILE_SERVER			equ	40000000h

THREAD_BASE_PRIORITY_LOWRT 	EQU 15;  { value that gets a thread to LowRealtime-1 }
THREAD_BASE_PRIORITY_MAX 	EQU 2;     { maximum thread base priority boost }
THREAD_BASE_PRIORITY_MIN 	EQU -2;    { minimum thread base priority boost }
THREAD_BASE_PRIORITY_IDLE 	EQU -15;  { value that gets a thread to idle }

SYNCHRONIZE 			EQU 00100000h;
STANDARD_RIGHTS_REQUIRED 	EQU 000F0000h;
EVENT_MODIFY_STATE 		EQU 0002h;
EVENT_ALL_ACCESS 		EQU (STANDARD_RIGHTS_REQUIRED + SYNCHRONIZE + 3h);
MUTANT_QUERY_STATE 		EQU 0001h;
MUTANT_ALL_ACCESS 		EQU (STANDARD_RIGHTS_REQUIRED + SYNCHRONIZE + MUTANT_QUERY_STATE);

PROCESS_TERMINATE         	EQU 0001h;
PROCESS_CREATE_THREAD     	EQU 0002h;
PROCESS_VM_OPERATION      	EQU 0008h;
PROCESS_VM_READ           	EQU 0010h;
PROCESS_VM_WRITE          	EQU 0020h;
PROCESS_DUP_HANDLE        	EQU 0040h;
PROCESS_CREATE_PROCESS    	EQU 0080h;
PROCESS_SET_QUOTA         	EQU 0100h;
PROCESS_SET_INFORMATION   	EQU 0200h;
PROCESS_QUERY_INFORMATION 	EQU 0400h;
PROCESS_ALL_ACCESS        	EQU (STANDARD_RIGHTS_REQUIRED + SYNCHRONIZE + 0FFFh);
;
;------------------------------------------------------------------------------
;
; ===================
; thread access flags
; ===================
;
THREAD_TERMINATE		equ	0001h
THREAD_SUSPEND_RESUME		equ	0002h
THREAD_GET_CONTEXT		equ	0008h
THREAD_SET_CONTEXT		equ	0010h
THREAD_SET_INFORMATION		equ	0020h
THREAD_QUERY_INFORMATION	equ	0040h
THREAD_SET_THREAD_TOKEN		equ	0080h
THREAD_IMPERSONATE		equ	0100h
THREAD_DIRECT_IMPERSONATION	equ	0200h
;
THREAD_ALL_ACCESS		equ	STANDARD_RIGHTS_REQUIRED+\
					SYNCHRONIZE+\
					03FFh
;
;------------------------------------------------------------------------------
;
; =================
; thread priorities
; =================
;
THREAD_BASE_PRIORITY_IDLE	equ	-15
THREAD_BASE_PRIORITY_MIN	equ	 -2
THREAD_BASE_PRIORITY_MAX	equ	  2
THREAD_BASE_PRIORITY_LOWRT	equ	 15
;
THREAD_PRIORITY_LOWEST		equ	THREAD_BASE_PRIORITY_MIN
THREAD_PRIORITY_BELOW_NORMAL	equ	THREAD_PRIORITY_LOWEST+1
THREAD_PRIORITY_NORMAL		equ	  0
THREAD_PRIORITY_ABOVE_NORMAL	equ	THREAD_PRIORITY_HIGHEST-1
THREAD_PRIORITY_HIGHEST		equ	THREAD_BASE_PRIORITY_MAX
;
THREAD_PRIORITY_TIME_CRITICAL	equ	THREAD_BASE_PRIORITY_LOWRT
THREAD_PRIORITY_IDLE		equ	THREAD_BASE_PRIORITY_IDLE
;
THREAD_PRIORITY_ERROR_RETURN	equ	 -1
;
;
;------------------------------------------------------------------------------
;
; =================
; wait status codes
; =================
;
WAIT_FAILED			equ	-1
WAIT_OBJECT_0			equ	STATUS_WAIT_0
;
WAIT_ABANDONED			equ	STATUS_ABANDONED_WAIT_0
WAIT_ABANDONED_0		equ	STATUS_ABANDONED_WAIT_0
;
WAIT_TIMEOUT			equ	STATUS_TIMEOUT
WAIT_IO_COMPLETION		equ	STATUS_USER_APC
STILL_ACTIVE			equ	STATUS_PENDING
;
MAXIMUM_WAIT_OBJECTS		equ	 64
MAXIMUM_SUSPEND_COUNT		equ	127
INFINITE			equ	 -1
;
;------------------------------------------------------------------------------
;
; =================
; file access types
; =================
;
GENERIC_ALL			equ	10000000h
GENERIC_EXECUTE			equ	20000000h
GENERIC_WRITE			equ	40000000h
GENERIC_READ			equ	80000000h
;
GENERIC_READWRITE		equ	GENERIC_READ+GENERIC_WRITE
;
;------------------------------------------------------------------------------
;
; ===============
; file attributes
; ===============
;
FILE_ATTRIBUTE_READONLY		equ	00000001h
FILE_ATTRIBUTE_HIDDEN		equ	00000002h
FILE_ATTRIBUTE_SYSTEM		equ	00000004h
FILE_ATTRIBUTE_DIRECTORY	equ	00000010h
FILE_ATTRIBUTE_ARCHIVE		equ	00000020h
FILE_ATTRIBUTE_NORMAL		equ	00000080h
FILE_ATTRIBUTE_TEMPORARY	equ	00000100h
FILE_ATTRIBUTE_COMPRESSED	equ	00000800h
;
;------------------------------------------------------------------------------
;
; ===================
; file creation flags
; ===================
;
FILE_FLAG_WRITE_THROUGH		equ	80000000h
FILE_FLAG_OVERLAPPED		equ	40000000h
FILE_FLAG_NO_BUFFERING		equ	20000000h
FILE_FLAG_RANDOM_ACCESS		equ	10000000h
FILE_FLAG_SEQUENTIAL_SCAN	equ	08000000h
FILE_FLAG_DELETE_ON_CLOSE	equ	04000000h
FILE_FLAG_BACKUP_SEMANTICS	equ	02000000h
FILE_FLAG_POSIX_SEMANTICS	equ	01000000h
;
;------------------------------------------------------------------------------
;
; ==================
; file notifications
; ==================
;
FILE_NOTIFY_CHANGE_FILE_NAME	equ	0001h
FILE_NOTIFY_CHANGE_DIR_NAME	equ	0002h
FILE_NOTIFY_CHANGE_ATTRIBUTES	equ	0004h
FILE_NOTIFY_CHANGE_SIZE		equ	0008h
FILE_NOTIFY_CHANGE_LAST_WRITE	equ	0010h
FILE_NOTIFY_CHANGE_SECURITY	equ	0100h
;
;------------------------------------------------------------------------------
;
; ================
; file share modes
; ================
;
FILE_SHARE_NONE			equ	0000h
FILE_SHARE_READ			equ	0001h
FILE_SHARE_WRITE		equ	0002h
;
FILE_SHARE_READWRITE		equ	FILE_SHARE_READ+FILE_SHARE_WRITE
;
; ====================
; CreateFile() actions
; ====================
;
CREATE_NEW			equ	1
CREATE_ALWAYS			equ	2
OPEN_EXISTING			equ	3
OPEN_ALWAYS			equ	4
TRUNCATE_EXISTING		equ	5
;
;------------------------------------------------------------------------------
;
; =================
; file system flags
; =================
;
FILE_CASE_SENSITIVE_SEARCH	equ	00000001h
FILE_CASE_PRESERVED_NAMES	equ	00000002h
FILE_UNICODE_ON_DISK		equ	00000004h
FILE_PERSISTENT_ACLS		equ	00000008h
FILE_FILE_COMPRESSION		equ	00000010h
FILE_VOLUME_IS_COMPRESSED	equ	00008000h
;
FS_CASE_SENSITIVE		equ	FILE_CASE_SENSITIVE_SEARCH
FS_CASE_IS_PRESERVED		equ	FILE_CASE_PRESERVED_NAMES
FS_UNICODE_STORED_ON_DISK	equ	FILE_UNICODE_ON_DISK
FS_PERSISTENT_ACLS		equ	FILE_PERSISTENT_ACLS
FS_FILE_COMPRESSION		equ	FILE_FILE_COMPRESSION
FS_VOL_IS_COMPRESSED		equ	FILE_VOLUME_IS_COMPRESSED

;
;------------------------------------------------------------------------------
;
; ========================
; SetFilePointer() methods
; ========================
;
FILE_BEGIN			equ	0
FILE_CURRENT			equ	1
FILE_END			equ	2
;
;------------------------------------------------------------------------------
;
; ===================
; global memory flags
; ===================
;
GMEM_FIXED			equ	0000h
GMEM_MOVEABLE			equ	0002h
GMEM_NOCOMPACT			equ	0010h
GMEM_NODISCARD			equ	0020h
GMEM_ZEROINIT			equ	0040h
GMEM_MODIFY			equ	0080h
GMEM_DISCARDABLE		equ	0100h
GMEM_NOT_BANKED			equ	1000h
GMEM_SHARE			equ	2000h
GMEM_DDESHARE			equ	2000h
GMEM_NOTIFY			equ	4000h
GMEM_INVALID_HANDLE		equ	8000h
;
GMEM_VALID_FLAGS		equ	7F72h
GMEM_LOWER			equ	GMEM_NOT_BANKED
;
; =================
; memory attributes
; =================
;
PAGE_NOACCESS			equ	00000001h
PAGE_READONLY			equ	00000002h
PAGE_READWRITE			equ	00000004h
PAGE_WRITECOPY			equ	00000008h
PAGE_EXECUTE			equ	00000010h
PAGE_EXECUTE_READ		equ	00000020h
PAGE_EXECUTE_READWRITE		equ	00000040h
PAGE_EXECUTE_WRITECOPY		equ	00000080h
PAGE_GUARD			equ	00000100h
PAGE_NOCACHE			equ	00000200h
;
;*******************************************************************
;
;       Rectangle
;
;*******************************************************************

RECT    struc
        rd_left          UINT ?
        rd_top           UINT ?
        rd_right         UINT ?
        rd_bottom        UINT ?
RECT    ends

;*******************************************************************
;
;  Window Class structure
;
;*******************************************************************

_OSVERSIONINFO EQU        4+4+4+4+4+128
OSVERSIONINFO struc
    dwOSVersionInfoSize   DWORD ?
    dwMajorVersion        DWORD ?
    dwMinorVersion        DWORD ?
    dwBuildNumber         DWORD ?
    dwPlatformId          DWORD ?
    szCSDVersion          BYTE 128 dup(?)
OSVERSIONINFO ends

WNDCLASS struc
        clsStyle          UINT     ?   ; class style
        clsLpfnWndProc    ULONG    ?
        clsCbClsExtra     UINT     ?
        clsCbWndExtra     UINT     ?
        clsHInstance      UINT     ?   ; instance handle
        clsHIcon          UINT     ?   ; class icon handle
        clsHCursor        UINT     ?   ; class cursor handle
        clsHbrBackground  UINT     ?   ; class background brush
        clsLpszMenuName   ULONG    ?   ; menu name
        clsLpszClassName  ULONG    ?   ; far ptr to class name
WNDCLASS ends

WNDCLASSEX_ EQU 4*12
WNDCLASSEXA		STRUCT
	wc_cbSize		UINT		?
	wc_style		UINT		?
	wc_lpfnWndProc		DWORD		?
	wc_cbClsExtra		SDWORD		?
	wc_cbWndExtra		SDWORD		?
	wc_hInstance		DWORD		?
	wc_hIcon		DWORD		?
	wc_hCursor		DWORD		?
	wc_hbrBackground	DWORD 		?
	wc_lpszMenuName		LPCSTR		?
	wc_lpszClassName	LPCSTR		?
	wc_hIconSm		DWORD		?
WNDCLASSEXA		ENDS
WNDCLASSEX		TEXTEQU	<WNDCLASSEXA>

DLGWINDOWEXTRA		EQU	00000001Eh

PAINTSTRUCT STRUC
    PShdc         UINT             ?
    PSfErase      UINT             ?
    PSrcPaint     UCHAR            size RECT dup(?)
    PSfRestore    UINT             ?
    PSfIncUpdate  UINT             ?
    PSrgbReserved UCHAR            16 dup(?)
PAINTSTRUCT ENDS

OVERLAPPED		STRUCT
	Internal	DWORD	?
	InternalHigh	DWORD	?
	_Offset		DWORD	?
	OffsetHigh	DWORD	?
	hEvent		HANDLE	?
OVERLAPPED		ENDS
LPOVERLAPPED		TYPEDEF	PTR OVERLAPPED

NMHDR	struct
 hwndFrom	DWORD   ?
 idFrom	UINT    ?
 Code	UINT	?
NMHDR	ends

POINT	struct
 x		DWORD 	?
 y		DWORD 	?
POINT	ends

NM_LISTVIEW	struct
 hdr	NMHDR <?>
 iItem	DWORD 	?
 iSubItem 	DWORD 	?
 uNewState 	UINT 	?
 uOldState 	UINT 	?
 uChanged 	UINT 	?
 ptAction 	POINT <?>
 lParam 	DWORD 	?
NM_LISTVIEW	ends

MSG			struct
ms_hwnd			DWORD	  0		;window handle
ms_message		UINT	  0		;message id
ms_wParam		DWORD 	  0		;additional parameter
ms_lParam		DWORD 	  0		;additional parameter
ms_time			DWORD	  0		;time stamp
ms_x			DWORD  	  0		;x coordinate
ms_y			DWORD  	  0		;y coordinate
MSG			ends
MSG_			equ	  4+4+4+4+4+4+4

MINMAXINFO struc
  res_x               dd ?
  res_y               dd ?
  maxsize_x           dd ?
  maxsize_y           dd ?
  maxposition_x       dd ?
  maxposition_y       dd ?
  mintrackposition_x  dd ?
  mintrackposition_y  dd ?
  maxtrackposition_x  dd ?
  maxtrackposition_y  dd ?
MINMAXINFO ends

LF_FACESIZE     EQU     32

ANSI_CHARSET    = 0
DEFAULT_CHARSET = 1
SYMBOL_CHARSET  = 2
OEM_CHARSET     = 255

LOGFONT 		STRUC
    lfHeight          dd   ?
    lfWidth           dd   ?
    lfEscapement      dd   ?
    lfOrientation     dd   ?
    lfWeight          dd   ?
    lfItalic          db   ?
    lfUnderline       db   ?
    lfStrikeOut       db   ?
    lfCharSet         db   ?
    lfOutPrecision    db   ?
    lfClipPrecision   db   ?
    lfQuality         db   ?
    lfPitchAndFamily  db   ?
    lfFaceName        db   LF_FACESIZE dup(?)
LOGFONT 		ENDS

PROCESSINFORMATION	struct
pi_hProcess		HANDLE	  0		;process handle
pi_hThread		HANDLE	  0		;thread handle
pi_dwProcessId		DWORD	  0		;process id
pi_dwThreadId		DWORD	  0		;thread id
PROCESSINFORMATION	ends
PROCESSINFORMATION_	equ	  4+4+4+4

STARTUPINFO_		equ	  4+4+4+4+4+4+4+4+4+4+4+4+2+2+4+4+4+4
STARTUPINFO		struct
si_cb			DWORD	  STARTUPINFO_  ;structure size
si_lpReserved		LPSTR	  0		;(reserved)
si_lpDesktop		LPSTR	  0		;desktop name
sl_lpTitle		LPSTR	  0		;console window title
si_dwX			DWORD	  0		;window origin (column)
si_dwY			DWORD	  0		;window origin (row)
si_dwXSize		DWORD	  0		;window width
si_dwYSize		DWORD	  0		;window height
si_dwXCountChars	DWORD	  0		;screen buffer width
si_dwYCountChars	DWORD	  0		;screen buffer height
si_dwFillAttribute	DWORD	  0		;console window initialization
si_dwFlags		DWORD	  0		;structure member flags
si_wShowWindow		WORD	  0		;ShowWindow() parameter
si_cbReserved2		WORD	  0		;(reserved)
si_lpReserved2		LPBYTE	  0		;(reserved)
si_hStdInput		HANDLE	  0		;standard input handle
si_hStdOutput		HANDLE	  0		;standard output handle
si_hStdError		HANDLE	  0		;standard error handle
STARTUPINFO		ends

SECURITY_ATTRIBUTES_	equ	  4+4+4
SECURITY_ATTRIBUTES	struct
sa_nLength		DWORD	  SECURITY_ATTRIBUTES_ ;structure size
sa_lpSecurityDescriptor	LPVOID	  30h		;security descriptor
sa_bInheritHandle	BOOL	  0    		;handle inheritance flag
SECURITY_ATTRIBUTES	ends

DBG_CONTINUE                    EQU    10002h
DBG_TERMINATE_THREAD            EQU 40010003h
DBG_TERMINATE_PROCESS           EQU 40010004h
DBG_CONTROL_C                   EQU 40010005h
DBG_CONTROL_BREAK               EQU 40010008h
DBG_EXCEPTION_NOT_HANDLED       EQU 80010001h

EXCEPTION_CONTINUE_EXECUTION	 EQU 00000000h
EXCEPTION_CONTINUE_SEARCH	 EQU 00000001h
EXCEPTION_EXECUTE_HANDLER       EQU 00000002h

SEM_FAILCRITICALERRORS          EQU 00000001h
SEM_NOGPFAULTERRORBOX           EQU 00000002h
SEM_NOALIGNMENTFAULTEXCEPT      EQU 00000004h
SEM_NOOPENFILEERRORBOX          EQU 00008000h
;
;------------------------------------------------------------------------------
;
; ====================
; thread context flags
; ====================
;
CONTEXT_i386			equ	00010000h
CONTEXT_i486			equ	00010000h
;
CONTEXT_CONTROL			equ	CONTEXT_i386+00000001h
CONTEXT_INTEGER			equ	CONTEXT_i386+00000002h
CONTEXT_SEGMENTS		equ	CONTEXT_i386+00000004h
CONTEXT_FLOATING_POINT		equ	CONTEXT_i386+00000008h
CONTEXT_DEBUG_REGISTERS		equ	CONTEXT_i386+00000010h
;
CONTEXT_FULL			equ	CONTEXT_CONTROL+\
					CONTEXT_INTEGER+\
					CONTEXT_SEGMENTS
;
SIZE_OF_80387_REGISTERS		equ	80

CONTEXT			struct
;
cx_ContextFlags		DWORD	  0		;context flags
;
; CONTEXT_DEBUG_REGISTERS
;
cx_Dr0			DWORD	  0		;debug register #0
cx_Dr1			DWORD	  0		;debug register #1
cx_Dr2			DWORD	  0		;debug register #2
cx_Dr3			DWORD	  0		;debug register #3
cx_Dr6			DWORD	  0		;debug register #6
cx_Dr7			DWORD	  0		;debug register #7
;
; CONTEXT_FLOATING_POINT
;
cx_ControlWord		DWORD	  0		;fpu context
cx_StatusWord		DWORD	  0
cx_TagWord		DWORD	  0
cx_ErrorOffset		DWORD	  0
cx_ErrorSelector	DWORD	  0
cx_DataOffset		DWORD	  0
cx_DataSelector		DWORD	  0
cx_RegisterArea		BYTE	  SIZE_OF_80387_REGISTERS dup (0)
cx_Cr0NpxState		DWORD	  0
;
; CONTEXT_SEGMENTS
;
cx_SegGs		DWORD	  0		;gs register
cx_SegFs		DWORD	  0		;fs register
cx_SegEs		DWORD	  0		;es register
cx_SegDs		DWORD	  0		;ds register
;
; CONTEXT_INTEGER
;
cx_Edi			DWORD	  0		;edi register
cx_Esi			DWORD	  0		;esi register
cx_Ebx			DWORD	  0		;ebx register
cx_Edx			DWORD	  0		;edx register
cx_Ecx			DWORD	  0		;ecx register
cx_Eax			DWORD	  0		;eax register
;
; CONTEXT_CONTROL
;
cx_Ebp			DWORD	  0		;ebp register
cx_Eip			DWORD	  0		;eip register
cx_SegCs		DWORD	  0		;cs register
cx_EFlags		DWORD	  0		;eflags register
cx_Esp			DWORD	  0		;esp register
cx_SegSs		DWORD	  0		;ss register
;
CONTEXT			ends
;
CONTEXT_FLAGS_			equ	4
CONTEXT_DEBUG_REGISTERS_	equ	4+4+4+4+4+4
CONTEXT_FLOATING_POINT_	equ	4+4+4+4+4+4+4+SIZE_OF_80387_REGISTERS+4
CONTEXT_SEGMENTS_		equ	4+4+4+4
CONTEXT_INTEGER_		equ	4+4+4+4+4+4

CONTEXT_CONTROL_		equ	4+4+4+4+4+4
;
CONTEXT_FULL_			equ	CONTEXT_FLAGS_+\
					CONTEXT_SEGMENTS_+\
					CONTEXT_INTEGER_+\
					CONTEXT_CONTROL_
CONTEXT_STDREG_	EQU CONTEXT_FLAGS_+CONTEXT_SEGMENTS_+CONTEXT_DEBUG_REGISTERS_+CONTEXT_FLOATING_POINT_

_CONTEXT		EQU CONTEXT_FLAGS_+\
		CONTEXT_DEBUG_REGISTERS_+\
		CONTEXT_FLOATING_POINT_+\
		CONTEXT_SEGMENTS_+\
		CONTEXT_INTEGER_+\
		CONTEXT_CONTROL_

DEBUGEVENT_	EQU	4+4+4+4
DEBUGEVENT	STRUCT
 de_dwDebugEventCode	DWORD 0
 de_dwProcessId 	DWORD 0
 de_dwThreadId		DWORD 0

 de_dwException      	DD    20 dup (0)
 de_dwFirstChance	DWORD 0

 de_dwcreatethread	DWORD 0
 de_dwthreadbase	DWORD 0
 de_dwthreadtstart 	DWORD 0

 de_dwhfile		DWORD 0
 de_dwhprocess		DWORD 0
 de_dwhthread		DWORD 0

 u		DB  40h dup(0)
DEBUGEVENT	ENDS
;
;------------------------------------------------------------------------------
;
; ============
; status codes
; ============
;
STATUS_WAIT_0			equ	000000000h
STATUS_ABANDONED_WAIT_0	equ	000000080h
STATUS_USER_APC		equ	0000000C0h
STATUS_TIMEOUT			equ	000000102h
STATUS_PENDING			equ	000000103h
STATUS_SEGMENT_NOTIFICATION	equ	040000005h
STATUS_GUARD_PAGE_VIOLATION	equ	080000001h
STATUS_DATATYPE_MISALIGNMENT	equ	080000002h
STATUS_BREAKPOINT		equ	080000003h
STATUS_SINGLE_STEP		equ	080000004h
STATUS_ACCESS_VIOLATION	equ	0C0000005h
STATUS_IN_PAGE_ERROR		equ	0C0000006h
STATUS_NO_MEMORY		equ	0C0000017h
STATUS_ILLEGAL_INSTRUCTION	equ	0C000001Dh
STATUS_NONCONTINUABLE_EXCEPTION equ	0C0000025h
STATUS_INVALID_DISPOSITION	equ	0C0000026h
STATUS_ARRAY_BOUNDS_EXCEEDED	equ	0C000008Ch
STATUS_FLOAT_DENORMAL_OPERAND	equ	0C000008Dh
STATUS_FLOAT_DIVIDE_BY_ZERO	equ	0C000008Eh
STATUS_FLOAT_INEXACT_RESULT	equ	0C000008Fh
STATUS_FLOAT_INVALID_OPERATION	equ	0C0000090h
STATUS_FLOAT_OVERFLOW		equ	0C0000091h
STATUS_FLOAT_STACK_CHECK	equ	0C0000092h
STATUS_FLOAT_UNDERFLOW		equ	0C0000093h
STATUS_INTEGER_DIVIDE_BY_ZERO	equ	0C0000094h
STATUS_INTEGER_OVERFLOW	equ	0C0000095h
STATUS_PRIVILEGED_INSTRUCTION	equ	0C0000096h
STATUS_STACK_OVERFLOW		equ	0C00000FDh
STATUS_CONTROL_C_EXIT		equ	0C000013Ah
;
;  Stock Logical Objects
;
WHITE_BRUSH         =  0
LTGRAY_BRUSH        =  1
GRAY_BRUSH          =  2
DKGRAY_BRUSH        =  3
BLACK_BRUSH         =  4
NULL_BRUSH          =  5
HOLLOW_BRUSH        =  5
WHITE_PEN           =  6
BLACK_PEN           =  7
NULL_PEN            =  8
DOT_MARKER          =  9
OEM_FIXED_FONT      = 10
ANSI_FIXED_FONT     = 11
ANSI_VAR_FONT       = 12
SYSTEM_FONT         = 13
DEVICE_DEFAULT_FONT = 14
DEFAULT_PALETTE     = 15
SYSTEM_FIXED_FONT   = 16

;
; Brush Styles
;
BS_SOLID        =   0
BS_NULL         =   1
BS_HOLLOW       =   BS_NULL
BS_HATCHED      =   2
BS_PATTERN      =   3
BS_INDEXED      =   4
BS_DIBPATTERN   =   5
;
; Hatch Styles
;
HS_HORIZONTAL   =   0       ; -----
HS_VERTICAL     =   1       ; |||||
HS_FDIAGONAL    =   2       ; \\\\\
HS_BDIAGONAL    =   3       ; /////
HS_CROSS        =   4       ; +++++
HS_DIAGCROSS    =   5       ; xxxxx
;
; Pen Styles
;
PS_SOLID        =   0
PS_DASH         =   1       ; -------
PS_DOT          =   2       ; .......
PS_DASHDOT      =   3       ; _._._._
PS_DASHDOTDOT   =   4       ; _.._.._
PS_NULL         =   5
PS_INSIDEFRAME  =   6

;============================================================
;===== Win32 Constants ======================================

LVIS_FOCUSED           EQU	0001
LVIS_SELECTED          EQU	0002
LVIS_CUT               EQU	0004
LVIS_DROPHILITED       EQU	0008

LVIS_OVERLAYMASK       EQU	00F00h
LVIS_STATEIMAGEMASK    EQU	0F000h

TPM_LEFTBUTTON  	EQU 	0000h
TPM_RIGHTBUTTON 	EQU 	0002h
TPM_LEFTALIGN   	EQU 	0000h
TPM_CENTERALIGN 	EQU 	0004h
TPM_RIGHTALIGN  	EQU 	0008h
TPM_TOPALIGN        	EQU 	0000h
TPM_VCENTERALIGN    	EQU 	0010h
TPM_BOTTOMALIGN     	EQU 	0020h

TPM_HORIZONTAL      	EQU 	0000h
TPM_VERTICAL        	EQU 	0040h
TPM_NONOTIFY        	EQU 	0080h
TPM_RETURNCMD       	EQU 	0100h
TPM_RECURSE         	EQU 	0001h

NM_FIRST                EQU	0
NM_LAST                 EQU	0-99
NM_OUTOFMEMORY          EQU NM_FIRST-1
NM_CLICK                EQU NM_FIRST-2
NM_DBLCLK               EQU NM_FIRST-3
NM_RETURN               EQU NM_FIRST-4
NM_RCLICK               EQU NM_FIRST-5
NM_RDBLCLK              EQU NM_FIRST-6
NM_SETFOCUS             EQU NM_FIRST-7
NM_KILLFOCUS            EQU NM_FIRST-8
NM_CUSTOMDRAW           EQU NM_FIRST-12
NM_HOVER                EQU NM_FIRST-13
NM_NCHITTEST            EQU NM_FIRST-14
NM_KEYDOWN              EQU NM_FIRST-15
NM_RELEASEDCAPTURE      EQU NM_FIRST-16
NM_SETCURSOR            EQU NM_FIRST-17
NM_CHAR                 EQU NM_FIRST-18
;
;  Window State Messages
BST_UNCHECKED		EQU	00h
BST_CHECKED		EQU	01h
BST_INDETERMINATE	EQU	02h
;
IFNDEF  NOWM
;
;------------------------------------------------------------------------------
;
; ===============
; window messages
; ===============
;
WM_NULL				equ	0000h
WM_CREATE			equ	0001h
WM_DESTROY			equ	0002h
WM_MOVE				equ	0003h
WM_SIZE				equ	0005h
WM_ACTIVATE			equ	0006h
WM_SETFOCUS			equ	0007h
WM_KILLFOCUS			equ	0008h
WM_ENABLE			equ	000Ah
WM_SETREDRAW			equ	000Bh
WM_SETTEXT			equ	000Ch
WM_GETTEXT			equ	000Dh
WM_GETTEXTLENGTH		equ	000Eh
WM_PAINT			equ	000Fh
WM_CLOSE			equ	0010h
WM_QUERYENDSESSION		equ	0011h
WM_QUIT				equ	0012h
WM_QUERYOPEN			equ	0013h
WM_ERASEBKGND			equ	0014h
WM_SYSCOLORCHANGE		equ	0015h
WM_ENDSESSION			equ	0016h
WM_SHOWWINDOW			equ	0018h
WM_WININICHANGE			equ	001Ah
WM_SETTINGCHANGE		equ	WM_WININICHANGE
WM_DEVMODECHANGE		equ	001Bh
WM_ACTIVATEAPP			equ	001Ch
WM_FONTCHANGE			equ	001Dh
WM_TIMECHANGE			equ	001Eh
WM_CANCELMODE			equ	001Fh
WM_SETCURSOR			equ	0020h
WM_MOUSEACTIVATE		equ	0021h
WM_CHILDACTIVATE		equ	0022h
WM_QUEUESYNC			equ	0023h
WM_GETMINMAXINFO		equ	0024h
WM_PAINTICON			equ	0026h
WM_ICONERASEBKGND		equ	0027h
WM_NEXTDLGCTL			equ	0028h
WM_SPOOLERSTATUS		equ	002Ah
WM_DRAWITEM			equ	002Bh
WM_MEASUREITEM			equ	002Ch
WM_DELETEITEM			equ	002Dh
WM_VKEYTOITEM			equ	002Eh
WM_CHARTOITEM			equ	002Fh
WM_SETFONT			equ	0030h
WM_GETFONT			equ	0031h
WM_SETHOTKEY			equ	0032h
WM_GETHOTKEY			equ	0033h
WM_QUERYDRAGICON		equ	0037h
WM_COMPAREITEM			equ	0039h
WM_COMPACTING			equ	0041h
WM_COMMNOTIFY			equ	0044h		;no longer suported
WM_WINDOWPOSCHANGING		equ	0046h
WM_WINDOWPOSCHANGED		equ	0047h
WM_POWER			equ	0048h
WM_COPYDATA			equ	004Ah
WM_CANCELJOURNAL		equ	004Bh
WM_NOTIFY			equ	004Eh
WM_INPUTLANGCHANGEREQUEST	equ	0050h
WM_INPUTLANGCHANGE		equ	0051h
WM_TCARD			equ	0052h
WM_HELP				equ	0053h
WM_USERCHANGED			equ	0054h
WM_NOTIFYFORMAT			equ	0055h
WM_CONTEXTMENU			equ	007Bh
WM_STYLECHANGING		equ	007Ch
WM_STYLECHANGED			equ	007Dh
WM_DISPLAYCHANGE		equ	007Eh
WM_GETICON			equ	007Fh
WM_SETICON			equ	0080h
WM_NCCREATE			equ	0081h
WM_NCDESTROY			equ	0082h
WM_NCCALCSIZE			equ	0083h
WM_NCHITTEST			equ	0084h
WM_NCPAINT			equ	0085h
WM_NCACTIVATE			equ	0086h
WM_GETDLGCODE			equ	0087h
;
WM_NCMOUSEMOVE			equ	00A0h
WM_NCLBUTTONDOWN		equ	00A1h
WM_NCLBUTTONUP			equ	00A2h
WM_NCLBUTTONDBLCLK		equ	00A3h
WM_NCRBUTTONDOWN		equ	00A4h
WM_NCRBUTTONUP			equ	00A5h
WM_NCRBUTTONDBLCLK		equ	00A6h
WM_NCMBUTTONDOWN		equ	00A7h
WM_NCMBUTTONUP			equ	00A8h
WM_NCMBUTTONDBLCLK		equ	00A9h
;
WM_KEYFIRST			equ	0100h
WM_KEYDOWN			equ	0100h
WM_KEYUP			equ	0101h
WM_CHAR				equ	0102h
WM_DEADCHAR			equ	0103h
WM_SYSKEYDOWN			equ	0104h
WM_SYSKEYUP			equ	0105h
WM_SYSCHAR			equ	0106h
WM_SYSDEADCHAR			equ	0107h
WM_KEYLAST			equ	0108h
;
WM_IME_STARTCOMPOSITION		equ	010Dh
WM_IME_ENDCOMPOSITION		equ	010Eh
WM_IME_COMPOSITION		equ	010Fh
WM_IME_KEYLAST			equ	010Fh
WM_INITDIALOG			equ	0110h
WM_COMMAND			equ	0111h
WM_SYSCOMMAND			equ	0112h
WM_TIMER			equ	0113h
WM_HSCROLL			equ	0114h
WM_VSCROLL			equ	0115h
WM_INITMENU			equ	0116h
WM_INITMENUPOPUP		equ	0117h
WM_MENUSELECT			equ	011Fh
WM_MENUCHAR			equ	0120h
WM_ENTERIDLE			equ	0121h
WM_CTLCOLORMSGBOX		equ	0132h
WM_CTLCOLOREDIT			equ	0133h
WM_CTLCOLORLISTBOX		equ	0134h
WM_CTLCOLORBTN			equ	0135h
WM_CTLCOLORDLG			equ	0136h
WM_CTLCOLORSCROLLBAR		equ	0137h
WM_CTLCOLORSTATIC		equ	0138h
;
WM_MOUSEFIRST			equ	0200h
WM_MOUSEMOVE			equ	0200h
WM_LBUTTONDOWN			equ	0201h
WM_LBUTTONUP			equ	0202h
WM_LBUTTONDBLCLK		equ	0203h
WM_RBUTTONDOWN			equ	0204h
WM_RBUTTONUP			equ	0205h
WM_RBUTTONDBLCLK		equ	0206h
WM_MBUTTONDOWN			equ	0207h
WM_MBUTTONUP			equ	0208h
WM_MBUTTONDBLCLK		equ	0209h
WM_MOUSELAST			equ	0209h
;
WM_PARENTNOTIFY			equ	0210h
WM_ENTERMENULOOP		equ	0211h
WM_EXITMENULOOP			equ	0212h
WM_NEXTMENU			equ	0213h
WM_SIZING			equ	0214h
WM_CAPTURECHANGED		equ	0215h
WM_MOVING			equ	0216h
WM_POWERBROADCAST		equ	0218h
WM_DEVICECHANGE			equ	0219h
WM_MDICREATE			equ	0220h
WM_MDIDESTROY			equ	0221h
WM_MDIACTIVATE			equ	0222h
WM_MDIRESTORE			equ	0223h
WM_MDINEXT			equ	0224h
WM_MDIMAXIMIZE			equ	0225h
WM_MDITILE			equ	0226h
WM_MDICASCADE			equ	0227h
WM_MDIICONARRANGE		equ	0228h
WM_MDIGETACTIVE			equ	0229h
WM_MDISETMENU			equ	0230h
WM_ENTERSIZEMOVE		equ	0231h
WM_EXITSIZEMOVE			equ	0232h
WM_DROPFILES			equ	0233h
WM_MDIREFRESHMENU		equ	0234h
;
WM_IME_SETCONTEXT		equ	0281h
WM_IME_NOTIFY			equ	0282h
WM_IME_CONTROL			equ	0283h
WM_IME_COMPOSITIONFULL		equ	0284h
WM_IME_SELECT			equ	0285h
WM_IME_CHAR			equ	0286h
WM_IME_KEYDOWN			equ	0290h
WM_IME_KEYUP			equ	0291h
;
WM_CUT				equ	0300h
WM_COPY				equ	0301h
WM_PASTE			equ	0302h
WM_CLEAR			equ	0303h
WM_UNDO				equ	0304h
WM_RENDERFORMAT			equ	0305h
WM_RENDERALLFORMATS		equ	0306h
WM_DESTROYCLIPBOARD		equ	0307h
WM_DRAWCLIPBOARD		equ	0308h
WM_PAINTCLIPBOARD		equ	0309h
WM_VSCROLLCLIPBOARD		equ	030Ah
WM_SIZECLIPBOARD		equ	030Bh
WM_ASKCBFORMATNAME		equ	030Ch
WM_CHANGECBCHAIN		equ	030Dh
WM_HSCROLLCLIPBOARD		equ	030Eh
WM_QUERYNEWPALETTE		equ	030Fh
WM_PALETTEISCHANGING		equ	0310h
WM_PALETTECHANGED		equ	0311h
WM_HOTKEY			equ	0312h
WM_PRINT			equ	0317h
WM_PRINTCLIENT			equ	0318h
;
WM_HANDHELDFIRST		equ	0358h
WM_HANDHELDLAST			equ	035Fh
;
WM_AFXFIRST			equ	0360h
WM_AFXLAST			equ	037Fh
;
WM_PENWINFIRST			equ	0380h
WM_PENWINLAST			equ	038Fh
;
WM_DDE_FIRST			equ	03E0h
WM_DDE_INITIATE			equ	WM_DDE_FIRST
WM_DDE_TERMINATE		equ	WM_DDE_FIRST+1
WM_DDE_ADVISE			equ	WM_DDE_FIRST+2
WM_DDE_UNADVISE			equ	WM_DDE_FIRST+3
WM_DDE_ACK			equ	WM_DDE_FIRST+4
WM_DDE_DATA			equ	WM_DDE_FIRST+5
WM_DDE_REQUEST			equ	WM_DDE_FIRST+6
WM_DDE_POKE			equ	WM_DDE_FIRST+7
WM_DDE_EXECUTE			equ	WM_DDE_FIRST+8
WM_DDE_LAST			equ	03E8h
;
WM_USER				equ	0400h
WM_APP				equ	8000h

ENDIF           ; NOWM

; WM_MOUSEACTIVATE Return Codes
MA_ACTIVATE       =  1
MA_ACTIVATEANDEAT =  2
MA_NOACTIVATE     =  3

; Size message commands
SIZENORMAL       = 0
SIZEICONIC       = 1
SIZEFULLSCREEN   = 2
SIZEZOOMSHOW     = 3
SIZEZOOMHIDE     = 4

; ShowWindow() Commands
SW_HIDE            = 0
SW_SHOWNORMAL      = 1
SW_NORMAL          = 1
SW_SHOWMINIMIZED   = 2
SW_SHOWMAXIMIZED   = 3
SW_MAXIMIZE        = 3
SW_SHOWNOACTIVATE  = 4
SW_SHOW            = 5
SW_MINIMIZE        = 6
SW_SHOWMINNOACTIVE = 7
SW_SHOWNA          = 8
SW_RESTORE         = 9

; Old ShowWindow() Commands
HIDE_WINDOW        = 0
SHOW_OPENWINDOW    = 1
SHOW_ICONWINDOW    = 2
SHOW_FULLSCREEN    = 3
SHOW_OPENNOACTIVATE= 4

;  identifiers for the WM_SHOWWINDOW message
SW_PARENTCLOSING =  1
SW_OTHERZOOM     =  2
SW_PARENTOPENING =  3
SW_OTHERUNZOOM   =  4
;
; Key state masks for mouse messages
;
MK_LBUTTON       = 0001h
MK_RBUTTON       = 0002h
MK_SHIFT         = 0004h
MK_CONTROL       = 0008h
MK_MBUTTON       = 0010h
;
; Class styles
;
CS_VREDRAW         = 0001h
CS_HREDRAW         = 0002h
CS_KEYCVTWINDOW    = 0004H
CS_DBLCLKS         = 0008h
;                    0010h reserved
CS_OWNDC           = 0020h
CS_CLASSDC         = 0040h
CS_PARENTDC        = 0080h
CS_NOKEYCVT        = 0100h
CS_SAVEBITS        = 0800h
CS_NOCLOSE         = 0200h
CS_BYTEALIGNCLIENT = 1000h
CS_BYTEALIGNWINDOW = 2000h
CS_GLOBALCLASS     = 4000h    ; Global window class

;
; Special CreateWindow position value
;

;
; Windows styles
;
WS_OVERLAPPED   = 000000000h
WS_ICONICPOPUP  = 0C0000000h
WS_POPUP        = 080000000h
WS_CHILD        = 040000000h
WS_MINIMIZE     = 020000000h
WS_VISIBLE      = 010000000h
WS_DISABLED     = 008000000h
WS_CLIPSIBLINGS = 004000000h
WS_CLIPCHILDREN = 002000000h
WS_MAXIMIZE     = 001000000h
WS_CAPTION      = 000C00000h     ; WS_BORDER | WS_DLGFRAME
WS_BORDER       = 000800000h
WS_DLGFRAME     = 000400000h
WS_VSCROLL      = 000200000h
WS_HSCROLL      = 000100000h
WS_SYSMENU      = 000080000h
WS_THICKFRAME   = 000040000h
WS_HREDRAW      = 000020000h
WS_VREDRAW      = 000010000h
WS_GROUP        = 000020000h
WS_TABSTOP      = 000010000h
WS_MINIMIZEBOX  = 000020000h
WS_MAXIMIZEBOX  = 000010000h

; Common Window Styles

WS_OVERLAPPEDWINDOW = WS_OVERLAPPED OR WS_CAPTION OR WS_SYSMENU OR WS_THICKFRAME OR WS_MINIMIZEBOX OR WS_MAXIMIZEBOX
WS_POPUPWINDOW  = WS_POPUP OR WS_BORDER OR WS_SYSMENU
WS_CHILDWINDOW  = WS_CHILD
WS_TILEDWINDOW  = WS_OVERLAPPEDWINDOW

WS_TILED        = WS_OVERLAPPED
WS_ICONIC       = WS_MINIMIZE
WS_SIZEBOX      = WS_THICKFRAME

; Extended Window Styles (low words)
WS_EX_DLGMODALFRAME  = 0001
WS_EX_DRAGOBJECT     = 0002
WS_EX_NOPARENTNOTIFY = 0004
WS_EX_TOPMOST        = 0008
;
;------------------------------------------------------------------------------
;
; ======================
; extended window styles
; ======================
;
WS_EX_NONE			equ	00000000h
WS_EX_DLGMODALFRAME		equ	00000001h
WS_EX_NOPARENTNOTIFY		equ	00000004h
WS_EX_TOPMOST			equ	00000008h
WS_EX_ACCEPTFILES		equ	00000010h
WS_EX_TRANSPARENT		equ	00000020h
WS_EX_MDICHILD			equ	00000040h
WS_EX_TOOLWINDOW		equ	00000080h
WS_EX_WINDOWEDGE		equ	00000100h
WS_EX_CLIENTEDGE		equ	00000200h
WS_EX_CONTEXTHELP		equ	00000400h
WS_EX_RIGHT			equ	00001000h
WS_EX_LEFT			equ	00000000h
WS_EX_RTLREADING		equ	00002000h
WS_EX_LTRREADING		equ	00000000h
WS_EX_LEFTSCROLLBAR		equ	00004000h
WS_EX_RIGHTSCROLLBAR		equ	00000000h
WS_EX_CONTROLPARENT		equ	00010000h
WS_EX_STATICEDGE		equ	00020000h
WS_EX_APPWINDOW		equ	00040000h
;
WS_EX_OVERLAPPEDWINDOW		equ	00000300h
WS_EX_PALETTEWINDOW		equ	00000188h
;

; PeekMessage() Options
PM_NOREMOVE    = 0000h
PM_REMOVE      = 0001h
PM_NOYIELD     = 0002h

; SetWindowPos Flags
SWP_NOSIZE       =  0001h
SWP_NOMOVE       =  0002h
SWP_NOZORDER     =  0004h
SWP_NOREDRAW     =  0008h
SWP_NOACTIVATE   =  0010h
SWP_DRAWFRAME    =  0020h
SWP_SHOWWINDOW   =  0040h
SWP_HIDEWINDOW   =  0080h
SWP_NOCOPYBITS   =  0100h
SWP_NOREPOSITION =  0200h
;
;  Predefined cursor & icon IDs
;
IDC_ARROW       = 32512
IDC_IBEAM       = 32513
IDC_WAIT        = 32514
IDC_CROSS       = 32515
IDC_UPARROW     = 32516
IDC_SIZE        = 32640
IDC_ICON        = 32641
IDC_SIZENWSE    = 32642
IDC_SIZENESW    = 32643
IDC_SIZEWE      = 32644
IDC_SIZENS      = 32645

IDI_APPLICATION = 32512
IDI_HAND        = 32513
IDI_QUESTION    = 32514
IDI_EXCLAMATION = 32515
IDI_ASTERISK    = 32516

COLOR_SCROLLBAR           = 0
COLOR_BACKGROUND          = 1
COLOR_ACTIVECAPTION       = 2
COLOR_INACTIVECAPTION     = 3
COLOR_MENU                = 4
COLOR_WINDOW              = 5
COLOR_WINDOWFRAME         = 6
COLOR_MENUTEXT            = 7
COLOR_WINDOWTEXT          = 8
COLOR_CAPTIONTEXT         = 9
COLOR_ACTIVEBORDER        = 10
COLOR_INACTIVEBORDER      = 11
COLOR_APPWORKSPACE        = 12
COLOR_HIGHLIGHT           = 13
COLOR_HIGHLIGHTTEXT       = 14
COLOR_BTNFACE             = 15
COLOR_BTNSHADOW           = 16
COLOR_GRAYTEXT            = 17
COLOR_BTNTEXT             = 18

;
;  MessageBox type flags
;
MB_OK                   = 0000H
MB_OKCANCEL             = 0001H
MB_ABORTRETRYIGNORE     = 0002H
MB_YESNOCANCEL          = 0003H
MB_YESNO                = 0004H
MB_RETRYCANCEL          = 0005H

MB_ICONHAND             = 0010H
MB_ICONQUESTION         = 0020H
MB_ICONEXCLAMATION      = 0030H
MB_ICONASTERISK         = 0040H

MB_DEFBUTTON1           = 0000H
MB_DEFBUTTON2           = 0100H
MB_DEFBUTTON3           = 0200H

MB_APPLMODAL            = 0000H
MB_SYSTEMMODAL          = 1000H
MB_TASKMODAL            = 2000H

MB_NOFOCUS              = 8000H

;
;  Conventional dialog box and message box command IDs
;
IDOK     =   1
IDCANCEL =   2
IDABORT  =   3
IDRETRY  =   4
IDIGNORE =   5
IDYES    =   6
IDNO     =   7

;
; ========================
; bitmap compression types
; ========================
;
BI_RGB				equ	0
BI_RLE8				equ	1
BI_RLE4				equ	2
BI_BITFIELDS			equ	3
;
;------------------------------------------------------------------------------
;
; =======================
; button control messages
; =======================
;
BM_GETCHECK			equ	00F0h
BM_SETCHECK			equ	00F1h
BM_GETSTATE			equ	00F2h
BM_SETSTATE			equ	00F3h
BM_SETSTYLE			equ	00F4h
BM_CLICK			equ	00F5h
BM_GETIMAGE			equ	00F6h
BM_SETIMAGE			equ	00F7h
;
;------------------------------------------------------------------------------
;
; ============================
; button control notifications
; ============================
;
BN_CLICKED			equ	0000h
BN_PAINT			equ	0001h
BN_HILITE			equ	0002h
BN_UNHILITE			equ	0003h
BN_DISABLE			equ	0004h
BN_DOUBLECLICKED		equ	0005h
BN_SETFOCUS			equ	0006h
BN_KILLFOCUS			equ	0007h
;
BN_PUSHED			equ	BN_HILITE
BN_UNPUSHED			equ	BN_UNHILITE
BN_DBLCLK			equ	BN_DOUBLECLICKED
;
;------------------------------------------------------------------------------
;
; =====================
; button control styles
; =====================
;
BS_PUSHBUTTON			equ	0000h
BS_DEFPUSHBUTTON		equ	0001h
BS_CHECKBOX			equ	0002h
BS_AUTOCHECKBOX			equ	0003h
BS_RADIOBUTTON			equ	0004h
BS_3STATE			equ	0005h
BS_AUTO3STATE			equ	0006h
BS_GROUPBOX			equ	0007h
BS_USERBUTTON			equ	0008h
BS_AUTORADIOBUTTON		equ	0009h
BS_OWNERDRAW			equ	000Bh
BS_LEFTTEXT			equ	0020h
BS_TEXT				equ	0000h
BS_ICON				equ	0040h
BS_BITMAP			equ	0080h
BS_LEFT				equ	0100h
BS_RIGHT			equ	0200h
BS_CENTER			equ	0300h
BS_TOP				equ	0400h
BS_BOTTOM			equ	0800h
BS_VCENTER			equ	0C00h
BS_PUSHLIKE			equ	1000h
BS_MULTILINE			equ	2000h
BS_NOTIFY			equ	4000h
BS_FLAT				equ	8000h
;
BS_RIGHTBUTTON			equ	BS_LEFTTEXT
;
;------------------------------------------------------------------------------
;
; ==================
; combo box messages
; ==================
;
CB_GETEDITSEL			equ	0140h
CB_LIMITTEXT			equ	0141h
CB_SETEDITSEL			equ	0142h
CB_ADDSTRING			equ	0143h
CB_DELETESTRING			equ	0144h
CB_DIR				equ	0145h
CB_GETCOUNT			equ	0146h
CB_GETCURSEL			equ	0147h
CB_GETLBTEXT			equ	0148h
CB_GETLBTEXTLEN			equ	0149h
CB_INSERTSTRING			equ	014Ah
CB_RESETCONTENT			equ	014Bh
CB_FINDSTRING			equ	014Ch
CB_SELECTSTRING			equ	014Dh
CB_SETCURSEL			equ	014Eh
CB_SHOWDROPDOWN			equ	014Fh
CB_GETITEMDATA			equ	0150h
CB_SETITEMDATA			equ	0151h
CB_GETDROPPEDCONTROLRECT	equ	0152h
CB_SETITEMHEIGHT		equ	0153h
CB_GETITEMHEIGHT		equ	0154h
CB_SETEXTENDEDUI		equ	0155h
CB_GETEXTENDEDUI		equ	0156h
CB_GETDROPPEDSTATE		equ	0157h
CB_FINDSTRINGEXACT		equ	0158h
CB_SETLOCALE			equ	0159h
CB_GETLOCALE			equ	015Ah
CB_GETTOPINDEX			equ	015Bh
CB_SETTOPINDEX			equ	015Ch
CB_GETHORIZONTALEXTENT		equ	015Dh
CB_SETHORIZONTALEXTENT		equ	015Eh
CB_GETDROPPEDWIDTH		equ	015Fh
CB_SETDROPPEDWIDTH		equ	0160h
CB_INITSTORAGE			equ	0161h
CB_MSGMAX			equ	0162h
;
;------------------------------------------------------------------------------
;
; =======================
; combo box return values
; =======================
;
CB_OKAY				equ	 0
CB_ERR				equ	-1
CB_ERRSPACE			equ	-2
;
;------------------------------------------------------------------------------
;
; ======================
; CreateDIBitmap() codes
; ======================
;
CBM_INIT			equ	4
;
;------------------------------------------------------------------------------
;
; ============================
; combo box notification codes
; ============================
;
CBN_ERRSPACE			equ	-1
CBN_SELCHANGE			equ	 1
CBN_DBLCLK			equ	 2
CBN_SETFOCUS			equ	 3
CBN_KILLFOCUS			equ	 4
CBN_EDITCHANGE			equ	 5
CBN_EDITUPDATE			equ	 6
CBN_DROPDOWN			equ	 7
CBN_CLOSEUP			equ	 8
CBN_SELENDOK			equ	 9
CBN_SELENDCANCEL		equ	10
;
;------------------------------------------------------------------------------
;
; ================
; combo box styles
; ================
;
CBS_SIMPLE			equ	0001h
CBS_DROPDOWN			equ	0002h
CBS_DROPDOWNLIST		equ	0003h
CBS_OWNERDRAWFIXED		equ	0010h
CBS_OWNERDRAWVARIABLE		equ	0020h
CBS_AUTOHSCROLL			equ	0040h
CBS_OEMCONVERT			equ	0080h
CBS_SORT			equ	0100h
CBS_HASSTRINGS			equ	0200h
CBS_NOINTEGRALHEIGHT		equ	0400h
CBS_DISABLENOSCROLL		equ	0800h
CBS_UPPERCASE			equ	2000h
CBS_LOWERCASE			equ	4000h
;
;------------------------------------------------------------------------------
;
; =================
; clipboard formats
; =================
;
CF_TEXT				equ	0001h
CF_BITMAP			equ	0002h
CF_METAFILEPICT			equ	0003h
CF_SYLK				equ	0004h
CF_DIF				equ	0005h
CF_TIFF				equ	0006h
CF_OEMTEXT			equ	0007h
CF_DIB				equ	0008h
CF_PALETTE			equ	0009h
CF_PENDATA			equ	000Ah
CF_RIFF				equ	000Bh
CF_WAVE				equ	000Ch
CF_UNICODETEXT			equ	000Dh
CF_ENHMETAFILE			equ	000Eh
CF_HDROP			equ	000Fh
CF_LOCALE			equ	0010h
CF_MAX				equ	0011h
;
CF_OWNERDISPLAY			equ	0080h
CF_DSPTEXT			equ	0081h
CF_DSPBITMAP			equ	0082h
CF_DSPMETAFILEPICT		equ	0083h
CF_DSPENHMETAFILE		equ	008Eh
;
CF_PRIVATEFIRST			equ	0200h
CF_PRIVATELAST			equ	02FFh
;
CF_GDIOBJFIRST			equ	0300h
CF_GDIOBJLAST			equ	03FFh
;
;------------------------------------------------------------------------------
;
; ===========
; color types
; ===========
;
COLOR_SCROLLBAR			equ	 0
COLOR_BACKGROUND		equ	 1
COLOR_ACTIVECAPTION		equ	 2
COLOR_INACTIVECAPTION		equ	 3
COLOR_MENU			equ	 4
COLOR_WINDOW			equ	 5
COLOR_WINDOWFRAME		equ	 6
COLOR_MENUTEXT			equ	 7
COLOR_WINDOWTEXT		equ	 8
COLOR_CAPTIONTEXT		equ	 9
COLOR_ACTIVEBORDER		equ	10
COLOR_INACTIVEBORDER		equ	11
COLOR_APPWORKSPACE		equ	12
COLOR_HIGHLIGHT			equ	13
COLOR_HIGHLIGHTTEXT		equ	14
COLOR_BTNFACE			equ	15
COLOR_BTNSHADOW			equ	16
COLOR_GRAYTEXT			equ	17
COLOR_BTNTEXT			equ	18
COLOR_INACTIVECAPTIONTEXT	equ	19
COLOR_BTNHIGHLIGHT		equ	20
COLOR_3DDKSHADOW		equ	21
COLOR_3DLIGHT			equ	22
COLOR_INFOTEXT			equ	23
COLOR_INFOBK			equ	24
;
COLOR_DESKTOP			equ	COLOR_BACKGROUND
COLOR_3DFACE			equ	COLOR_BTNFACE
COLOR_3DSHADOW			equ	COLOR_BTNSHADOW
COLOR_3DHIGHLIGHT		equ	COLOR_BTNHIGHLIGHT
COLOR_3DHILIGHT			equ	COLOR_BTNHIGHLIGHT
COLOR_BTNHILIGHT		equ	COLOR_BTNHIGHLIGHT
;
;------------------------------------------------------------------------------
;
; ===================
; network connections
; ===================
;
CONNECT_UPDATE_PROFILE		equ	00000001h
CONNECT_UPDATE_RECENT		equ	00000002h
CONNECT_TEMPORARY		equ	00000004h
CONNECT_INTERACTIVE		equ	00000008h
CONNECT_PROMPT			equ	00000010h
CONNECT_NEED_DRIVE		equ	00000020h
CONNECT_REFCOUNT		equ	00000040h
CONNECT_REDIRECT		equ	00000080h
CONNECT_LOCALDRIVE		equ	00000100h
CONNECT_CURRENT_MEDIA		equ	00000200h
;
NETPROPERTY_PERSISTENT		equ	1
;
;------------------------------------------------------------------------------
;
; ==========
; code pages
; ==========
;
CP_ACP				equ	0
CP_OEMCP			equ	1
CP_MACCP			equ	2
;
;------------------------------------------------------------------------------
;
; ============
; class styles
; ============
;
CS_VREDRAW			equ	00000001h
CS_HREDRAW			equ	00000002h
CS_KEYCVTWINDOW			equ	00000004h
CS_DBLCLKS			equ	00000008h
CS_OWNDC			equ	00000020h
CS_CLASSDC			equ	00000040h
CS_PARENTDC			equ	00000080h
CS_NOKEYCVT			equ	00000100h
CS_NOCLOSE			equ	00000200h
CS_SAVEBITS			equ	00000800h
CS_BYTEALIGNCLIENT		equ	00001000h
CS_BYTEALIGNWINDOW		equ	00002000h
CS_GLOBALCLASS			equ	00004000h
CS_IME				equ	00010000h
;
;------------------------------------------------------------------------------
;
; ===================
; control color types
; ===================
;
CTLCOLOR_MSGBOX			equ	0
CTLCOLOR_EDIT			equ	1
CTLCOLOR_LISTBOX		equ	2
CTLCOLOR_BTN			equ	3
CTLCOLOR_DLG			equ	4
CTLCOLOR_SCROLLBAR		equ	5
CTLCOLOR_STATIC			equ	6
CTLCOLOR_MAX			equ	7
;
;------------------------------------------------------------------------------
;
; =======================
; CreateWindow() commands
; =======================
;
CW_USEDEFAULT			equ	80000000h
;
;------------------------------------------------------------------------------
;
; ===================
; device capabilities
; ===================
;
DC_FIELDS			equ	 1
DC_PAPERS			equ	 2
DC_PAPERSIZE			equ	 3
DC_MINEXTENT			equ	 4
DC_MAXEXTENT			equ	 5
DC_BINS				equ	 6
DC_DUPLEX			equ	 7
DC_SIZE				equ	 8
DC_EXTRA			equ	 9
DC_VERSION			equ	10
DC_DRIVER			equ	11
DC_BINNAMES			equ	12
DC_ENUMRESOLUTIONS		equ	13
DC_FILEDEPENDENCIES		equ	14
DC_TRUETYPE			equ	15
DC_PAPERNAMES			equ	16
DC_ORIENTATION			equ	17
DC_COPIES			equ	18
;
;------------------------------------------------------------------------------
;
; ====================
; dib color table id's
; ====================
;
DIB_RGB_COLORS			equ	0
DIB_PAL_COLORS			equ	1
;
;------------------------------------------------------------------------------
;
; ====================
; DLL LibMain() events
; ====================
;
DLL_PROCESS_DETACH		equ	0
DLL_PROCESS_ATTACH		equ	1
DLL_THREAD_ATTACH		equ	2
DLL_THREAD_DETACH		equ	3
;
;------------------------------------------------------------------------------
;
; ======================
; device mode selections
; ======================
;
DM_UPDATE			equ	1
DM_COPY				equ	2
DM_PROMPT			equ	4
DM_MODIFY			equ	8
;
DM_IN_BUFFER			equ	DM_MODIFY
DM_IN_PROMPT			equ	DM_PROMPT
DM_OUT_BUFFER			equ	DM_COPY
DM_OUT_DEFAULT			equ	DM_UPDATE
;
;------------------------------------------------------------------------------
;
; =============
; dialog styles
; =============
;
DS_ABSALIGN			equ	0001h
DS_SYSMODAL			equ	0002h
DS_3DLOOK			equ	0004h
DS_FIXEDSYS			equ	0008h
DS_NOFAILCREATE			equ	0010h
DS_LOCALEDIT			equ	0020h	;edit items get local storage
DS_SETFONT			equ	0040h	;user specified font
DS_MODALFRAME			equ	0080h	;combinable with WS_CAPTION
DS_NOIDLEMSG			equ	0100h	;don't send WM_ENTERIDLE
DS_SETFOREGROUND		equ	0200h
DS_CONTROL			equ	0400h
DS_CENTER			equ	0800h
DS_CENTERMOUSE			equ	1000h
DS_CONTEXTHELP			equ	2000h
;
DS_MODAL			equ	DS_ABSALIGN+DS_MODALFRAME
DS_MODELESS			equ	DS_ABSALIGN
;
;------------------------------------------------------------------------------
;
; =======================
; DrawText() format flags
; =======================
;
DT_TOP				equ	00000000h
DT_LEFT				equ	00000000h
DT_CENTER			equ	00000001h
DT_RIGHT			equ	00000002h
DT_VCENTER			equ	00000004h
DT_BOTTOM			equ	00000008h
DT_WORDBREAK			equ	00000010h
DT_SINGLELINE			equ	00000020h
DT_EXPANDTABS			equ	00000040h
DT_TABSTOP			equ	00000080h
DT_NOCLIP			equ	00000100h
DT_EXTERNALLEADING		equ	00000200h
DT_CALCRECT			equ	00000400h
DT_NOPREFIX			equ	00000800h
DT_INTERNAL			equ	00001000h
DT_EDITCONTROL			equ	00002000h
DT_PATH_ELLIPSIS		equ	00004000h
DT_END_ELLIPSIS			equ	00008000h
DT_MODIFYSTRING			equ	00010000h
DT_RTLREADING			equ	00020000h
DT_WORD_ELLIPSIS		equ	00040000h
;
;------------------------------------------------------------------------------
;
; =====================
; edit control messages
; =====================
;
EM_GETSEL			equ	00B0h
EM_SETSEL			equ	00B1h
EM_GETRECT			equ	00B2h
EM_SETRECT			equ	00B3h
EM_SETRECTNP			equ	00B4h
EM_SCROLL			equ	00B5h
EM_LINESCROLL			equ	00B6h
EM_SCROLLCARET			equ	00B7h
EM_GETMODIFY			equ	00B8h
EM_SETMODIFY			equ	00B9h
EM_GETLINECOUNT			equ	00BAh
EM_LINEINDEX			equ	00BBh
EM_SETHANDLE			equ	00BCh
EM_GETHANDLE			equ	00BDh
EM_GETTHUMB			equ	00BEh
EM_LINELENGTH			equ	00C1h
EM_REPLACESEL			equ	00C2h
EM_GETLINE			equ	00C4h
EM_LIMITTEXT			equ	00C5h
EM_CANUNDO			equ	00C6h
EM_UNDO				equ	00C7h
EM_FMTLINES			equ	00C8h
EM_LINEFROMCHAR			equ	00C9h
EM_SETTABSTOPS			equ	00CBh
EM_SETPASSWORDCHAR		equ	00CCh
EM_EMPTYUNDOBUFFER		equ	00CDh
EM_GETFIRSTVISIBLELINE		equ	00CEh
EM_SETREADONLY			equ	00CFh
EM_SETWORDBREAKPROC		equ	00D0h
EM_GETWORDBREAKPROC		equ	00D1h
EM_GETPASSWORDCHAR		equ	00D2h
EM_SETMARGINS			equ	00D3h
EM_GETMARGINS			equ	00D4h
EM_GETLIMITTEXT			equ	00D5h
EM_POSFROMCHAR			equ	00D6h
EM_CHARFROMPOS			equ	00D7h
;
EM_SETLIMITTEXT			equ	EM_LIMITTEXT
;
;------------------------------------------------------------------------------
;
; ==========================
; edit control notifications
; ==========================
;
EN_SETFOCUS			equ	0100h
EN_KILLFOCUS			equ	0200h
EN_CHANGE			equ	0300h
EN_UPDATE			equ	0400h
EN_ERRSPACE			equ	0500h
EN_MAXTEXT			equ	0501h
EN_HSCROLL			equ	0601h
EN_VSCROLL			equ	0602h
;
;------------------------------------------------------------------------------
;
; ===========
; error codes
; ===========
;
ERROR_SUCCESS				equ	   0
NO_ERROR				equ	   0
;
ERROR_INVALID_FUNCTION			equ	   1
ERROR_FILE_NOT_FOUND			equ	   2
ERROR_PATH_NOT_FOUND			equ	   3
ERROR_TOO_MANY_OPEN_FILES		equ	   4
ERROR_ACCESS_DENIED			equ	   5
ERROR_INVALID_HANDLE			equ	   6
ERROR_ARENA_TRASHED			equ	   7
ERROR_NOT_ENOUGH_MEMORY			equ	   8
ERROR_INVALID_BLOCK			equ	   9
ERROR_BAD_ENVIRONMENT			equ	  10
ERROR_BAD_FORMAT			equ	  11
ERROR_INVALID_ACCESS			equ	  12
ERROR_INVALID_DATA			equ	  13
ERROR_OUTOFMEMORY			equ	  14
ERROR_INVALID_DRIVE			equ	  15
ERROR_CURRENT_DIRECTORY			equ	  16
ERROR_NOT_SAME_DEVICE			equ	  17
ERROR_NO_MORE_FILES			equ	  18
ERROR_WRITE_PROTECT			equ	  19
ERROR_BAD_UNIT				equ	  20
ERROR_NOT_READY				equ	  21
ERROR_BAD_COMMAND			equ	  22
ERROR_CRC				equ	  23
ERROR_BAD_LENGTH			equ	  24
ERROR_SEEK				equ	  25
ERROR_NOT_DOS_DISK			equ	  26
ERROR_SECTOR_NOT_FOUND			equ	  27
ERROR_OUT_OF_PAPER			equ	  28
ERROR_WRITE_FAULT			equ	  29
ERROR_READ_FAULT			equ	  30
ERROR_GEN_FAILURE			equ	  31
ERROR_SHARING_VIOLATION			equ	  32
ERROR_LOCK_VIOLATION			equ	  33
ERROR_WRONG_DISK			equ	  34
ERROR_SHARING_BUFFER_EXCEEDED		equ	  36
ERROR_HANDLE_EOF			equ	  38
ERROR_HANDLE_DISK_FULL			equ	  39
ERROR_NOT_SUPPORTED			equ	  50
ERROR_REM_NOT_LIST			equ	  51
ERROR_DUP_NAME				equ	  52
ERROR_BAD_NETPATH			equ	  53
ERROR_NETWORK_BUSY			equ	  54
ERROR_DEV_NOT_EXIST			equ	  55
ERROR_TOO_MANY_CMDS			equ	  56
ERROR_ADAP_HDW_ERR			equ	  57
ERROR_BAD_NET_RESP			equ	  58
ERROR_UNEXP_NET_ERR			equ	  59
ERROR_BAD_REM_ADAP			equ	  60
ERROR_PRINTQ_FULL			equ	  61
ERROR_NO_SPOOL_SPACE			equ	  62
ERROR_PRINT_CANCELLED			equ	  63
ERROR_NETNAME_DELETED			equ	  64
ERROR_NETWORK_ACCESS_DENIED		equ	  65
ERROR_BAD_DEV_TYPE			equ	  66
ERROR_BAD_NET_NAME			equ	  67
ERROR_TOO_MANY_NAMES			equ	  68
ERROR_TOO_MANY_SESS			equ	  69
ERROR_SHARING_PAUSED			equ	  70
ERROR_REQ_NOT_ACCEP			equ	  71
ERROR_REDIR_PAUSED			equ	  72
ERROR_FILE_EXISTS			equ	  80
ERROR_CANNOT_MAKE			equ	  82
ERROR_FAIL_I24				equ	  83
ERROR_OUT_OF_STRUCTURES			equ	  84
ERROR_ALREADY_ASSIGNED			equ	  85
ERROR_INVALID_PASSWORD			equ	  86
ERROR_INVALID_PARAMETER			equ	  87
ERROR_NET_WRITE_FAULT			equ	  88
ERROR_NO_PROC_SLOTS			equ	  89
ERROR_TOO_MANY_SEMAPHORES		equ	 100
ERROR_EXCL_SEM_ALREADY_OWNED		equ	 101
ERROR_SEM_IS_SET			equ	 102
ERROR_TOO_MANY_SEM_REQUESTS		equ	 103
ERROR_INVALID_AT_INTERRUPT_TIME		equ	 104
ERROR_SEM_OWNER_DIED			equ	 105
ERROR_SEM_USER_LIMIT			equ	 106
ERROR_DISK_CHANGE			equ	 107
ERROR_DRIVE_LOCKED			equ	 108
ERROR_BROKEN_PIPE			equ	 109
ERROR_OPEN_FAILED			equ	 110
ERROR_BUFFER_OVERFLOW			equ	 111
ERROR_DISK_FULL				equ	 112
ERROR_NO_MORE_SEARCH_HANDLES		equ	 113
ERROR_INVALID_TARGET_HANDLE		equ	 114
ERROR_INVALID_CATEGORY			equ	 117
ERROR_INVALID_VERIFY_SWITCH		equ	 118
ERROR_BAD_DRIVER_LEVEL			equ	 119
ERROR_CALL_NOT_IMPLEMENTED		equ	 120
ERROR_SEM_TIMEOUT			equ	 121
ERROR_INSUFFICIENT_BUFFER		equ	 122
ERROR_INVALID_NAME			equ	 123
ERROR_INVALID_LEVEL			equ	 124
ERROR_NO_VOLUME_LABEL			equ	 125
ERROR_MOD_NOT_FOUND			equ	 126
ERROR_PROC_NOT_FOUND			equ	 127
ERROR_WAIT_NO_CHILDREN			equ	 128
ERROR_CHILD_NOT_COMPLETE		equ	 129
ERROR_DIRECT_ACCESS_HANDLE		equ	 130
ERROR_NEGATIVE_SEEK			equ	 131
ERROR_SEEK_ON_DEVICE			equ	 132
ERROR_IS_JOIN_TARGET			equ	 133
ERROR_IS_JOINED				equ	 134
ERROR_IS_SUBSTED			equ	 135
ERROR_NOT_JOINED			equ	 136
ERROR_NOT_SUBSTED			equ	 137
ERROR_JOIN_TO_JOIN			equ	 138
ERROR_SUBST_TO_SUBST			equ	 139
ERROR_JOIN_TO_SUBST			equ	 140
ERROR_SUBST_TO_JOIN			equ	 141
ERROR_BUSY_DRIVE			equ	 142
ERROR_SAME_DRIVE			equ	 143
ERROR_DIR_NOT_ROOT			equ	 144
ERROR_DIR_NOT_EMPTY			equ	 145
ERROR_IS_SUBST_PATH			equ	 146
ERROR_IS_JOIN_PATH			equ	 147
ERROR_PATH_BUSY				equ	 148
ERROR_IS_SUBST_TARGET			equ	 149
ERROR_SYSTEM_TRACE			equ	 150
ERROR_INVALID_EVENT_COUNT		equ	 151
ERROR_TOO_MANY_MUXWAITERS		equ	 152
ERROR_INVALID_LIST_FORMAT		equ	 153
ERROR_LABEL_TOO_LONG			equ	 154
ERROR_TOO_MANY_TCBS			equ	 155
ERROR_SIGNAL_REFUSED			equ	 156
ERROR_DISCARDED				equ	 157
ERROR_NOT_LOCKED			equ	 158
ERROR_BAD_THREADID_ADDR			equ	 159
ERROR_BAD_ARGUMENTS			equ	 160
ERROR_BAD_PATHNAME			equ	 161
ERROR_SIGNAL_PENDING			equ	 162
ERROR_MAX_THRDS_REACHED			equ	 164
ERROR_LOCK_FAILED			equ	 167
ERROR_BUSY				equ	 170
ERROR_CANCEL_VIOLATION			equ	 173
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED	equ	 174
ERROR_INVALID_SEGMENT_NUMBER		equ	 180
ERROR_INVALID_ORDINAL			equ	 182
ERROR_ALREADY_EXISTS			equ	 183
ERROR_INVALID_FLAG_NUMBER		equ	 186
ERROR_SEM_NOT_FOUND			equ	 187
ERROR_INVALID_STARTING_CODESEG		equ	 188
ERROR_INVALID_STACKSEG			equ	 189
ERROR_INVALID_MODULETYPE		equ	 190
ERROR_INVALID_EXE_SIGNATURE		equ	 191
ERROR_EXE_MARKED_INVALID		equ	 192
ERROR_BAD_EXE_FORMAT			equ	 193
ERROR_ITERATED_DATA_EXCEEDS_64k		equ	 194
ERROR_INVALID_MINALLOCSIZE		equ	 195
ERROR_DYNLINK_FROM_INVALID_RING		equ	 196
ERROR_IOPL_NOT_ENABLED			equ	 197
ERROR_INVALID_SEGDPL			equ	 198
ERROR_AUTODATASEG_EXCEEDS_64k		equ	 199
ERROR_RING2SEG_MUST_BE_MOVABLE		equ	 200
ERROR_RELOC_CHAIN_XEEDS_SEGLIM		equ	 201
ERROR_INFLOOP_IN_RELOC_CHAIN		equ	 202
ERROR_ENVVAR_NOT_FOUND			equ	 203
ERROR_NO_SIGNAL_SENT			equ	 205
ERROR_FILENAME_EXCED_RANGE		equ	 206
ERROR_RING2_STACK_IN_USE		equ	 207
ERROR_META_EXPANSION_TOO_LONG		equ	 208
ERROR_INVALID_SIGNAL_NUMBER		equ	 209
ERROR_THREAD_1_INACTIVE			equ	 210
ERROR_LOCKED				equ	 212
ERROR_TOO_MANY_MODULES			equ	 214
ERROR_NESTING_NOT_ALLOWED		equ	 215
ERROR_BAD_PIPE				equ	 230
ERROR_PIPE_BUSY				equ	 231
ERROR_NO_DATA				equ	 232
ERROR_PIPE_NOT_CONNECTED		equ	 233
ERROR_MORE_DATA				equ	 234
ERROR_VC_DISCONNECTED			equ	 240
ERROR_INVALID_EA_NAME			equ	 254
ERROR_EA_LIST_INCONSISTENT		equ	 255
ERROR_NO_MORE_ITEMS			equ	 259
ERROR_CANNOT_COPY			equ	 266
ERROR_DIRECTORY				equ	 267
ERROR_EAS_DIDNT_FIT			equ	 275
ERROR_EA_FILE_CORRUPT			equ	 276
ERROR_EA_TABLE_FULL			equ	 277
ERROR_INVALID_EA_HANDLE			equ	 278
ERROR_EAS_NOT_SUPPORTED			equ	 282
ERROR_NOT_OWNER				equ	 288
ERROR_TOO_MANY_POSTS			equ	 298
ERROR_PARTIAL_COPY			equ	 299
ERROR_MR_MID_NOT_FOUND			equ	 317
ERROR_INVALID_ADDRESS			equ	 487
ERROR_ARITHMETIC_OVERFLOW		equ	 534
ERROR_PIPE_CONNECTED			equ	 535
ERROR_PIPE_LISTENING			equ	 536
ERROR_EA_ACCESS_DENIED			equ	 994
ERROR_OPERATION_ABORTED			equ	 995
ERROR_IO_INCOMPLETE			equ	 996
ERROR_IO_PENDING			equ	 997
ERROR_NOACCESS				equ	 998
ERROR_SWAPERROR				equ	 999
ERROR_STACK_OVERFLOW			equ	1001
ERROR_INVALID_MESSAGE			equ	1002
ERROR_CAN_NOT_COMPLETE			equ	1003
ERROR_INVALID_FLAGS			equ	1004
ERROR_UNRECOGNIZED_VOLUME		equ	1005
ERROR_FILE_INVALID			equ	1006
ERROR_FULLSCREEN_MODE			equ	1007
ERROR_NO_TOKEN				equ	1008
ERROR_BADDB				equ	1009
ERROR_BADKEY				equ	1010
ERROR_CANTOPEN				equ	1011
ERROR_CANTREAD				equ	1012
ERROR_CANTWRITE				equ	1013
ERROR_REGISTRY_RECOVERED		equ	1014
ERROR_REGISTRY_CORRUPT			equ	1015
ERROR_REGISTRY_IO_FAILED		equ	1016
ERROR_NOT_REGISTRY_FILE			equ	1017
ERROR_KEY_DELETED			equ	1018
ERROR_NO_LOG_SPACE			equ	1019
ERROR_KEY_HAS_CHILDREN			equ	1020
ERROR_CHILD_MUST_BE_VOLATILE		equ	1021
ERROR_NOTIFY_ENUM_DIR			equ	1022
ERROR_DEPENDENT_SERVICES_RUNNING	equ	1051
ERROR_INVALID_SERVICE_CONTROL		equ	1052
ERROR_SERVICE_REQUEST_TIMEOUT		equ	1053
ERROR_SERVICE_NO_THREAD			equ	1054
ERROR_SERVICE_DATABASE_LOCKED		equ	1055
ERROR_SERVICE_ALREADY_RUNNING		equ	1056
ERROR_INVALID_SERVICE_ACCOUNT		equ	1057
ERROR_SERVICE_DISABLED			equ	1058
ERROR_CIRCULAR_DEPENDENCY		equ	1059
ERROR_SERVICE_DOES_NOT_EXIST		equ	1060
ERROR_SERVICE_CANNOT_ACCEPT_CTRL	equ	1061
ERROR_SERVICE_NOT_ACTIVE		equ	1062
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT	equ	1063
ERROR_EXCEPTION_IN_SERVICE		equ	1064
ERROR_DATABASE_DOES_NOT_EXIST		equ	1065
ERROR_SERVICE_SPECIFIC_ERROR		equ	1066
ERROR_PROCESS_ABORTED			equ	1067
ERROR_SERVICE_DEPENDENCY_FAIL		equ	1068
ERROR_SERVICE_LOGON_FAILED		equ	1069
ERROR_SERVICE_START_HANG		equ	1070
ERROR_INVALID_SERVICE_LOCK		equ	1071
ERROR_SERVICE_MARKED_FOR_DELETE		equ	1072
ERROR_SERVICE_EXISTS			equ	1073
ERROR_ALREADY_RUNNING_LKG		equ	1074
ERROR_SERVICE_DEPENDENCY_DELETED	equ	1075
ERROR_BOOT_ALREADY_ACCEPTED		equ	1076
ERROR_SERVICE_NEVER_STARTED		equ	1077
ERROR_DUPLICATE_SERVICE_NAME		equ	1078
ERROR_END_OF_MEDIA			equ	1100
ERROR_FILEMARK_DETECTED			equ	1101
ERROR_BEGINNING_OF_MEDIA		equ	1102
ERROR_SETMARK_DETECTED			equ	1103
ERROR_NO_DATA_DETECTED			equ	1104
ERROR_PARTITION_FAILURE			equ	1105
ERROR_INVALID_BLOCK_LENGTH		equ	1106
ERROR_DEVICE_NOT_PARTITIONED		equ	1107
ERROR_UNABLE_TO_LOCK_MEDIA		equ	1108
ERROR_UNABLE_TO_UNLOAD_MEDIA		equ	1109
ERROR_MEDIA_CHANGED			equ	1110
ERROR_BUS_RESET				equ	1111
ERROR_NO_MEDIA_IN_DRIVE			equ	1112
ERROR_NO_UNICODE_TRANSLATION		equ	1113
ERROR_DLL_INIT_FAILED			equ	1114
ERROR_SHUTDOWN_IN_PROGRESS		equ	1115
ERROR_NO_SHUTDOWN_IN_PROGRESS		equ	1116
ERROR_IO_DEVICE				equ	1117
ERROR_SERIAL_NO_DEVICE			equ	1118
ERROR_IRQ_BUSY				equ	1119
ERROR_MORE_WRITES			equ	1120
ERROR_COUNTER_TIMEOUT			equ	1121
ERROR_FLOPPY_ID_MARK_NOT_FOUND		equ	1122
ERROR_FLOPPY_WRONG_CYLINDER		equ	1123
ERROR_FLOPPY_UNKNOWN_ERROR		equ	1124
ERROR_FLOPPY_BAD_REGISTERS		equ	1125
ERROR_DISK_RECALIBRATE_FAILED		equ	1126
ERROR_DISK_OPERATION_FAILED		equ	1127
ERROR_DISK_RESET_FAILED			equ	1128
ERROR_EOM_OVERFLOW			equ	1129
ERROR_NOT_ENOUGH_SERVER_MEMORY		equ	1130
ERROR_POSSIBLE_DEADLOCK			equ	1131
ERROR_MAPPED_ALIGNMENT			equ	1132
ERROR_SET_POWER_STATE_VETOED		equ	1140
ERROR_SET_POWER_STATE_FAILED		equ	1141
ERROR_OLD_WIN_VERSION			equ	1150
ERROR_APP_WRONG_OS			equ	1151
ERROR_SINGLE_INSTANCE_APP		equ	1152
ERROR_RMODE_APP				equ	1153
ERROR_INVALID_DLL			equ	1154
ERROR_NO_ASSOCIATION			equ	1155
ERROR_DDE_FAIL				equ	1156
ERROR_DLL_NOT_FOUND			equ	1157
ERROR_BAD_USERNAME			equ	2202
ERROR_NOT_CONNECTED			equ	2250
ERROR_OPEN_FILES			equ	2401
ERROR_ACTIVE_CONNECTIONS		equ	2402
ERROR_DEVICE_IN_USE			equ	2404
ERROR_BAD_DEVICE			equ	1200
ERROR_CONNECTION_UNAVAIL		equ	1201
ERROR_DEVICE_ALREADY_REMEMBERED		equ	1202
ERROR_NO_NET_OR_BAD_PATH		equ	1203
ERROR_BAD_PROVIDER			equ	1204
ERROR_CANNOT_OPEN_PROFILE		equ	1205
ERROR_BAD_PROFILE			equ	1206
ERROR_NOT_CONTAINER			equ	1207
ERROR_EXTENDED_ERROR			equ	1208
ERROR_INVALID_GROUPNAME			equ	1209
ERROR_INVALID_COMPUTERNAME		equ	1210
ERROR_INVALID_EVENTNAME			equ	1211
ERROR_INVALID_DOMAINNAME		equ	1212
ERROR_INVALID_SERVICENAME		equ	1213
ERROR_INVALID_NETNAME			equ	1214
ERROR_INVALID_SHARENAME			equ	1215
ERROR_INVALID_PASSWORDNAME		equ	1216
ERROR_INVALID_MESSAGENAME		equ	1217
ERROR_INVALID_MESSAGEDEST		equ	1218
ERROR_SESSION_CREDENTIAL_CONFLICT	equ	1219
ERROR_REMOTE_SESSION_LIMIT_EXCEEDED	equ	1220
ERROR_DUP_DOMAINNAME			equ	1221
ERROR_NO_NETWORK			equ	1222
ERROR_CANCELLED				equ	1223
ERROR_USER_MAPPED_FILE			equ	1224
ERROR_CONNECTION_REFUSED		equ	1225
ERROR_GRACEFUL_DISCONNECT		equ	1226
ERROR_ADDRESS_ALREADY_ASSOCIATED	equ	1227
ERROR_ADDRESS_NOT_ASSOCIATED		equ	1228
ERROR_CONNECTION_INVALID		equ	1229
ERROR_CONNECTION_ACTIVE			equ	1230
ERROR_NETWORK_UNREACHABLE		equ	1231
ERROR_HOST_UNREACHABLE			equ	1232
ERROR_PROTOCOL_UNREACHABLE		equ	1233
ERROR_PORT_UNREACHABLE			equ	1234
ERROR_REQUEST_ABORTED			equ	1235
ERROR_CONNECTION_ABORTED		equ	1236
ERROR_RETRY				equ	1237
ERROR_CONNECTION_COUNT_LIMIT		equ	1238
ERROR_LOGIN_TIME_RESTRICTION		equ	1239
ERROR_LOGIN_WKSTA_RESTRICTION		equ	1240
ERROR_INCORRECT_ADDRESS			equ	1241
ERROR_ALREADY_REGISTERED		equ	1242
ERROR_SERVICE_NOT_FOUND			equ	1243
ERROR_NOT_AUTHENTICATED			equ	1244
ERROR_NOT_LOGGED_ON			equ	1245
ERROR_CONTINUE				equ	1246
ERROR_ALREADY_INITIALIZED		equ	1247
ERROR_NO_MORE_DEVICES			equ	1248
ERROR_NOT_ALL_ASSIGNED			equ	1300
ERROR_SOME_NOT_MAPPED			equ	1301
ERROR_NO_QUOTAS_FOR_ACCOUNT		equ	1302
ERROR_LOCAL_USER_SESSION_KEY		equ	1303
ERROR_NULL_LM_PASSWORD			equ	1304
ERROR_UNKNOWN_REVISION			equ	1305
ERROR_REVISION_MISMATCH			equ	1306
ERROR_INVALID_OWNER			equ	1307
ERROR_INVALID_PRIMARY_GROUP		equ	1308
ERROR_NO_IMPERSONATION_TOKEN		equ	1309
ERROR_CANT_DISABLE_MANDATORY		equ	1310
ERROR_NO_LOGON_SERVERS			equ	1311
ERROR_NO_SUCH_LOGON_SESSION		equ	1312
ERROR_NO_SUCH_PRIVILEGE			equ	1313
ERROR_PRIVILEGE_NOT_HELD		equ	1314
ERROR_INVALID_ACCOUNT_NAME		equ	1315
ERROR_USER_EXISTS			equ	1316
ERROR_NO_SUCH_USER			equ	1317
ERROR_GROUP_EXISTS			equ	1318
ERROR_NO_SUCH_GROUP			equ	1319
ERROR_MEMBER_IN_GROUP			equ	1320
ERROR_MEMBER_NOT_IN_GROUP		equ	1321
ERROR_LAST_ADMIN			equ	1322
ERROR_WRONG_PASSWORD			equ	1323
ERROR_ILL_FORMED_PASSWORD		equ	1324
ERROR_PASSWORD_RESTRICTION		equ	1325
ERROR_LOGON_FAILURE			equ	1326
ERROR_ACCOUNT_RESTRICTION		equ	1327
ERROR_INVALID_LOGON_HOURS		equ	1328
ERROR_INVALID_WORKSTATION		equ	1329
ERROR_PASSWORD_EXPIRED			equ	1330
ERROR_ACCOUNT_DISABLED			equ	1331
ERROR_NONE_MAPPED			equ	1332
ERROR_TOO_MANY_LUIDS_REQUESTED		equ	1333
ERROR_LUIDS_EXHAUSTED			equ	1334
ERROR_INVALID_SUB_AUTHORITY		equ	1335
ERROR_INVALID_ACL			equ	1336
ERROR_INVALID_SID			equ	1337
ERROR_INVALID_SECURITY_DESCR		equ	1338
ERROR_BAD_INHERITANCE_ACL		equ	1340
ERROR_SERVER_DISABLED			equ	1341
ERROR_SERVER_NOT_DISABLED		equ	1342
ERROR_INVALID_ID_AUTHORITY		equ	1343
ERROR_ALLOTTED_SPACE_EXCEEDED		equ	1344
ERROR_INVALID_GROUP_ATTRIBUTES		equ	1345
ERROR_BAD_IMPERSONATION_LEVEL		equ	1346
ERROR_CANT_OPEN_ANONYMOUS		equ	1347
ERROR_BAD_VALIDATION_CLASS		equ	1348
ERROR_BAD_TOKEN_TYPE			equ	1349
ERROR_NO_SECURITY_ON_OBJECT		equ	1350
ERROR_CANT_ACCESS_DOMAIN_INFO		equ	1351
ERROR_INVALID_SERVER_STATE		equ	1352
ERROR_INVALID_DOMAIN_STATE		equ	1353
ERROR_INVALID_DOMAIN_ROLE		equ	1354
ERROR_NO_SUCH_DOMAIN			equ	1355
ERROR_DOMAIN_EXISTS			equ	1356
ERROR_DOMAIN_LIMIT_EXCEEDED		equ	1357
ERROR_INTERNAL_DB_CORRUPTION		equ	1358
ERROR_INTERNAL_ERROR			equ	1359
ERROR_GENERIC_NOT_MAPPED		equ	1360
ERROR_BAD_DESCRIPTOR_FORMAT		equ	1361
ERROR_NOT_LOGON_PROCESS			equ	1362
ERROR_LOGON_SESSION_EXISTS		equ	1363
ERROR_NO_SUCH_PACKAGE			equ	1364
ERROR_BAD_LOGON_SESSION_STATE		equ	1365
ERROR_LOGON_SESSION_COLLISION		equ	1366
ERROR_INVALID_LOGON_TYPE		equ	1367
ERROR_CANNOT_IMPERSONATE		equ	1368
ERROR_RXACT_INVALID_STATE		equ	1369
ERROR_RXACT_COMMIT_FAILURE		equ	1370
ERROR_SPECIAL_ACCOUNT			equ	1371
ERROR_SPECIAL_GROUP			equ	1372
ERROR_SPECIAL_USER			equ	1373
ERROR_MEMBERS_PRIMARY_GROUP		equ	1374
ERROR_TOKEN_ALREADY_IN_USE		equ	1375
ERROR_NO_SUCH_ALIAS			equ	1376
ERROR_MEMBER_NOT_IN_ALIAS		equ	1377
ERROR_MEMBER_IN_ALIAS			equ	1378
ERROR_ALIAS_EXISTS			equ	1379
ERROR_LOGON_NOT_GRANTED			equ	1380
ERROR_TOO_MANY_SECRETS			equ	1381
ERROR_SECRET_TOO_LONG			equ	1382
ERROR_INTERNAL_DB_ERROR			equ	1383
ERROR_TOO_MANY_CONTEXT_IDS		equ	1384
ERROR_LOGON_TYPE_NOT_GRANTED		equ	1385
ERROR_NT_CROSS_ENCRYPTION_REQUIRED	equ	1386
ERROR_NO_SUCH_MEMBER			equ	1387
ERROR_INVALID_MEMBER			equ	1388
ERROR_TOO_MANY_SIDS			equ	1389
ERROR_LM_CROSS_ENCRYPTION_REQUIRED	equ	1390
ERROR_NO_INHERITANCE			equ	1391
ERROR_FILE_CORRUPT			equ	1392
ERROR_DISK_CORRUPT			equ	1393
ERROR_NO_USER_SESSION_KEY		equ	1394
ERROR_LICENSE_QUOTA_EXCEEDED		equ	1395
ERROR_INVALID_WINDOW_HANDLE		equ	1400
ERROR_INVALID_MENU_HANDLE		equ	1401
ERROR_INVALID_CURSOR_HANDLE		equ	1402
ERROR_INVALID_ACCEL_HANDLE		equ	1403
ERROR_INVALID_HOOK_HANDLE		equ	1404
ERROR_INVALID_DWP_HANDLE		equ	1405
ERROR_TLW_WITH_WSCHILD			equ	1406
ERROR_CANNOT_FIND_WND_CLASS		equ	1407
ERROR_WINDOW_OF_OTHER_THREAD		equ	1408
ERROR_HOTKEY_ALREADY_REGISTERED		equ	1409
ERROR_CLASS_ALREADY_EXISTS		equ	1410
ERROR_CLASS_DOES_NOT_EXIST		equ	1411
ERROR_CLASS_HAS_WINDOWS			equ	1412
ERROR_INVALID_INDEX			equ	1413
ERROR_INVALID_ICON_HANDLE		equ	1414
ERROR_PRIVATE_DIALOG_INDEX		equ	1415
ERROR_LISTBOX_ID_NOT_FOUND		equ	1416
ERROR_NO_WILDCARD_CHARACTERS		equ	1417
ERROR_CLIPBOARD_NOT_OPEN		equ	1418
ERROR_HOTKEY_NOT_REGISTERED		equ	1419
ERROR_WINDOW_NOT_DIALOG			equ	1420
ERROR_CONTROL_ID_NOT_FOUND		equ	1421
ERROR_INVALID_COMBOBOX_MESSAGE		equ	1422
ERROR_WINDOW_NOT_COMBOBOX		equ	1423
ERROR_INVALID_EDIT_HEIGHT		equ	1424
ERROR_DC_NOT_FOUND			equ	1425
ERROR_INVALID_HOOK_FILTER		equ	1426
ERROR_INVALID_FILTER_PROC		equ	1427
ERROR_HOOK_NEEDS_HMOD			equ	1428
ERROR_GLOBAL_ONLY_HOOK			equ	1429
ERROR_JOURNAL_HOOK_SET			equ	1430
ERROR_HOOK_NOT_INSTALLED		equ	1431
ERROR_INVALID_LB_MESSAGE		equ	1432
ERROR_SETCOUNT_ON_BAD_LB		equ	1433
ERROR_LB_WITHOUT_TABSTOPS		equ	1434
ERROR_DESTROY_OBJECT_OF_OTHER_THREAD	equ	1435
ERROR_CHILD_WINDOW_MENU			equ	1436
ERROR_NO_SYSTEM_MENU			equ	1437
ERROR_INVALID_MSGBOX_STYLE		equ	1438
ERROR_INVALID_SPI_VALUE			equ	1439
ERROR_SCREEN_ALREADY_LOCKED		equ	1440
ERROR_HWNDS_HAVE_DIFF_PARENT		equ	1441
ERROR_NOT_CHILD_WINDOW			equ	1442
ERROR_INVALID_GW_COMMAND		equ	1443
ERROR_INVALID_THREAD_ID			equ	1444
ERROR_NON_MDICHILD_WINDOW		equ	1445
ERROR_POPUP_ALREADY_ACTIVE		equ	1446
ERROR_NO_SCROLLBARS			equ	1447
ERROR_INVALID_SCROLLBAR_RANGE		equ	1448
ERROR_INVALID_SHOWWIN_COMMAND		equ	1449
ERROR_NO_SYSTEM_RESOURCES		equ	1450
ERROR_NONPAGED_SYSTEM_RESOURCES		equ	1451
ERROR_PAGED_SYSTEM_RESOURCES		equ	1452
ERROR_WORKING_SET_QUOTA			equ	1453
ERROR_PAGEFILE_QUOTA			equ	1454
ERROR_COMMITMENT_LIMIT			equ	1455
ERROR_MENU_ITEM_NOT_FOUND		equ	1456
ERROR_EVENTLOG_FILE_CORRUPT		equ	1500
ERROR_EVENTLOG_CANT_START		equ	1501
ERROR_LOG_FILE_FULL			equ	1502
ERROR_EVENTLOG_FILE_CHANGED		equ	1503
ERROR_INVALID_USER_BUFFER		equ	1784
ERROR_UNRECOGNIZED_MEDIA		equ	1785
ERROR_NO_TRUST_LSA_SECRET		equ	1786
ERROR_NO_TRUST_SAM_ACCOUNT		equ	1787
ERROR_TRUSTED_DOMAIN_FAILURE		equ	1788
ERROR_TRUSTED_RELATIONSHIP_FAILURE	equ	1789
ERROR_TRUST_FAILURE			equ	1790
ERROR_NETLOGON_NOT_STARTED		equ	1792
ERROR_ACCOUNT_EXPIRED			equ	1793
ERROR_REDIRECTOR_HAS_OPEN_HANDLES	equ	1794
ERROR_PRINTER_DRIVER_ALREADY_INSTALLED	equ	1795
ERROR_UNKNOWN_PORT			equ	1796
ERROR_UNKNOWN_PRINTER_DRIVER		equ	1797
ERROR_UNKNOWN_PRINTPROCESSOR		equ	1798
ERROR_INVALID_SEPARATOR_FILE		equ	1799
ERROR_INVALID_PRIORITY			equ	1800
ERROR_INVALID_PRINTER_NAME		equ	1801
ERROR_PRINTER_ALREADY_EXISTS		equ	1802
ERROR_INVALID_PRINTER_COMMAND		equ	1803
ERROR_INVALID_DATATYPE			equ	1804
ERROR_INVALID_ENVIRONMENT		equ	1805
ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT	equ	1807
ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT	equ	1808
ERROR_NOLOGON_SERVER_TRUST_ACCOUNT	equ	1809
ERROR_DOMAIN_TRUST_INCONSISTENT		equ	1810
ERROR_SERVER_HAS_OPEN_HANDLES		equ	1811
ERROR_RESOURCE_DATA_NOT_FOUND		equ	1812
ERROR_RESOURCE_TYPE_NOT_FOUND		equ	1813
ERROR_RESOURCE_NAME_NOT_FOUND		equ	1814
ERROR_RESOURCE_LANG_NOT_FOUND		equ	1815
ERROR_NOT_ENOUGH_QUOTA			equ	1816
ERROR_INVALID_TIME			equ	1901
ERROR_INVALID_FORM_NAME			equ	1902
ERROR_INVALID_FORM_SIZE			equ	1903
ERROR_ALREADY_WAITING			equ	1904
ERROR_PRINTER_DELETED			equ	1905
ERROR_INVALID_PRINTER_STATE		equ	1906
ERROR_PASSWORD_MUST_CHANGE		equ	1907
ERROR_DOMAIN_CONTROLLER_NOT_FOUND	equ	1908
ERROR_ACCOUNT_LOCKED_OUT		equ	1909
ERROR_INVALID_PIXEL_FORMAT		equ	2000
ERROR_BAD_DRIVER			equ	2001
ERROR_INVALID_WINDOW_STYLE		equ	2002
ERROR_METAFILE_NOT_SUPPORTED		equ	2003
ERROR_TRANSFORM_NOT_SUPPORTED		equ	2004
ERROR_CLIPPING_NOT_SUPPORTED		equ	2005
ERROR_UNKNOWN_PRINT_MONITOR		equ	3000
ERROR_PRINTER_DRIVER_IN_USE		equ	3001
ERROR_SPOOL_FILE_NOT_FOUND		equ	3002
ERROR_SPL_NO_STARTDOC			equ	3003
ERROR_SPL_NO_ADDJOB			equ	3004
ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED	equ	3005
ERROR_PRINT_MONITOR_ALREADY_INSTALLED	equ	3006
ERROR_WINS_INTERNAL			equ	4000
ERROR_CAN_NOT_DEL_LOCAL_WINS		equ	4001
ERROR_STATIC_INIT			equ	4002
ERROR_INC_BACKUP			equ	4003
ERROR_FULL_BACKUP			equ	4004
ERROR_REC_NON_EXISTENT			equ	4005
ERROR_RPL_NOT_ALLOWED			equ	4006
ERROR_NO_BROWSER_SERVERS_FOUND		equ	6118
;
;------------------------------------------------------------------------------
;
; ===================
; edit control styles
; ===================
;
ES_LEFT				equ	0000h
ES_CENTER			equ	0001h
ES_RIGHT			equ	0002h
ES_MULTILINE			equ	0004h
ES_UPPERCASE			equ	0008h
ES_LOWERCASE			equ	0010h
ES_PASSWORD			equ	0020h
ES_AUTOVSCROLL			equ	0040h
ES_AUTOHSCROLL			equ	0080h
ES_NOHIDESEL			equ	0100h
ES_OEMCONVERT			equ	0400h
ES_READONLY			equ	0800h
ES_WANTRETURN			equ	1000h
ES_NUMBER			equ	2000h
;
ES_DEFAULT			equ	ES_MULTILINE+ES_AUTOHSCROLL
;
;------------------------------------------------------------------------------
;
; =============
; font families
; =============
;
FF_DONTCARE			equ	0000h
FF_ROMAN			equ	0010h
FF_SWISS			equ	0020h
FF_MODERN			equ	0030h
FF_SCRIPT			equ	0040h
FF_DECORATIVE			equ	0050h
;
;------------------------------------------------------------------------------
;
; ===============
; file attributes
; ===============
;
FILE_ATTRIBUTE_READONLY		equ	00000001h
FILE_ATTRIBUTE_HIDDEN		equ	00000002h
FILE_ATTRIBUTE_SYSTEM		equ	00000004h
FILE_ATTRIBUTE_DIRECTORY	equ	00000010h
FILE_ATTRIBUTE_ARCHIVE		equ	00000020h
FILE_ATTRIBUTE_NORMAL		equ	00000080h
FILE_ATTRIBUTE_TEMPORARY	equ	00000100h
FILE_ATTRIBUTE_COMPRESSED	equ	00000800h
;
;------------------------------------------------------------------------------
;
; ===================
; file creation flags
; ===================
;
FILE_FLAG_WRITE_THROUGH		equ	80000000h
FILE_FLAG_OVERLAPPED		equ	40000000h
FILE_FLAG_NO_BUFFERING		equ	20000000h
FILE_FLAG_RANDOM_ACCESS		equ	10000000h
FILE_FLAG_SEQUENTIAL_SCAN	equ	08000000h
FILE_FLAG_DELETE_ON_CLOSE	equ	04000000h
FILE_FLAG_BACKUP_SEMANTICS	equ	02000000h
FILE_FLAG_POSIX_SEMANTICS	equ	01000000h
;
;------------------------------------------------------------------------------
;
; ==================
; file notifications
; ==================
;
FILE_NOTIFY_CHANGE_FILE_NAME	equ	0001h
FILE_NOTIFY_CHANGE_DIR_NAME	equ	0002h
FILE_NOTIFY_CHANGE_ATTRIBUTES	equ	0004h
FILE_NOTIFY_CHANGE_SIZE		equ	0008h
FILE_NOTIFY_CHANGE_LAST_WRITE	equ	0010h
FILE_NOTIFY_CHANGE_SECURITY	equ	0100h
;
;------------------------------------------------------------------------------
;
; ================
; file share modes
; ================
;
FILE_SHARE_NONE			equ	0000h
FILE_SHARE_READ			equ	0001h
FILE_SHARE_WRITE		equ	0002h
;
FILE_SHARE_READWRITE		equ	FILE_SHARE_READ+FILE_SHARE_WRITE
;
;------------------------------------------------------------------------------
;
; ========================
; SetFilePointer() methods
; ========================
;
FILE_BEGIN			equ	0
FILE_CURRENT			equ	1
FILE_END			equ	2
;
;------------------------------------------------------------------------------
;
; =================
; file system flags
; =================
;
FILE_CASE_SENSITIVE_SEARCH	equ	00000001h
FILE_CASE_PRESERVED_NAMES	equ	00000002h
FILE_UNICODE_ON_DISK		equ	00000004h
FILE_PERSISTENT_ACLS		equ	00000008h
FILE_FILE_COMPRESSION		equ	00000010h
FILE_VOLUME_IS_COMPRESSED	equ	00008000h
;
FS_CASE_SENSITIVE		equ	FILE_CASE_SENSITIVE_SEARCH
FS_CASE_IS_PRESERVED		equ	FILE_CASE_PRESERVED_NAMES
FS_UNICODE_STORED_ON_DISK	equ	FILE_UNICODE_ON_DISK
FS_PERSISTENT_ACLS		equ	FILE_PERSISTENT_ACLS
FS_FILE_COMPRESSION		equ	FILE_FILE_COMPRESSION
FS_VOL_IS_COMPRESSED		equ	FILE_VOLUME_IS_COMPRESSED
;
;------------------------------------------------------------------------------
;
; ============
; font weights
; ============
;
FW_DONTCARE			equ	000
FW_THIN				equ	100
FW_EXTRALIGHT			equ	200
FW_LIGHT			equ	300
FW_NORMAL			equ	400
FW_MEDIUM			equ	500
FW_SEMIBOLD			equ	600
FW_BOLD				equ	700
FW_EXTRABOLD			equ	800
FW_HEAVY			equ	900
;
FW_ULTRALIGHT			equ	FW_EXTRALIGHT
FW_REGULAR			equ	FW_NORMAL
FW_DEMIBOLD			equ	FW_SEMIBOLD
FW_ULTRABOLD			equ	FW_EXTRABOLD
FW_BLACK			equ	FW_HEAVY
;
;------------------------------------------------------------------------------
;
; =================
; file access types
; =================
;
GENERIC_ALL			equ	10000000h
GENERIC_EXECUTE			equ	20000000h
GENERIC_WRITE			equ	40000000h
GENERIC_READ			equ	80000000h
;
GENERIC_READWRITE		equ	GENERIC_READ+GENERIC_WRITE
;
;------------------------------------------------------------------------------
;
; ===================
; global memory flags
; ===================
;
GMEM_FIXED			equ	0000h
GMEM_MOVEABLE			equ	0002h
GMEM_NOCOMPACT			equ	0010h
GMEM_NODISCARD			equ	0020h
GMEM_ZEROINIT			equ	0040h
GMEM_MODIFY			equ	0080h
GMEM_DISCARDABLE		equ	0100h
GMEM_NOT_BANKED			equ	1000h
GMEM_SHARE			equ	2000h
GMEM_DDESHARE			equ	2000h
GMEM_NOTIFY			equ	4000h
GMEM_INVALID_HANDLE		equ	8000h
;
GMEM_VALID_FLAGS		equ	7F72h
GMEM_LOWER			equ	GMEM_NOT_BANKED
;
;------------------------------------------------------------------------------
;
; ================
; GetWindow() id's
; ================
;
GW_HWNDFIRST			equ	0
GW_HWNDLAST			equ	1
GW_HWNDNEXT			equ	2
GW_HWNDPREV			equ	3
GW_OWNER			equ	4
GW_CHILD			equ	5
;
GW_MAX				equ	5
;
;------------------------------------------------------------------------------
;
; =======================
; GetWindowLong() offsets
; =======================
;
GWL_WNDPROC			equ	-04
GWL_HINSTANCE			equ	-06
GWL_HWNDPARENT			equ	-08
GWL_STYLE			equ	-16
GWL_EXSTYLE			equ	-20
GWL_USERDATA			equ	-21
GWL_ID				equ	-12
;
;------------------------------------------------------------------------------
;
; ==================
; WinHelp() commands
; ==================
;
HELP_CONTEXT			equ	0001h
HELP_QUIT			equ	0002h
HELP_INDEX			equ	0003h
HELP_CONTENTS			equ	0003h
HELP_HELPONHELP			equ	0004h
HELP_SETINDEX			equ	0005h
HELP_SETCONTENTS		equ	0005h
HELP_CONTEXTPOPUP		equ	0008h
HELP_FORCEFILE			equ	0009h
HELP_CONTEXTMENU		equ	000Ah
HELP_FINDER			equ	000Bh
HELP_WM_HELP			equ	000Ch
HELP_SETPOPUP_POS		equ	000Dh
HELP_TCARD_DATA			equ	0010h
HELP_TCARD_OTHER_CALLER		equ	0011h
HELP_KEY			equ	0101h
HELP_COMMAND			equ	0102h
HELP_PARTIALKEY			equ	0105h
HELP_MULTIKEY			equ	0201h
HELP_SETWINPOS			equ	0203h
HELP_TCARD			equ	8000h
;
;------------------------------------------------------------------------------
;
; =======================
; hit test position codes
; =======================
;
HTERROR				equ	-2
HTTRANSPARENT			equ	-1
HTNOWHERE			equ	 0
HTCLIENT			equ	 1
HTCAPTION			equ	 2
HTSYSMENU			equ	 3
HTGROWBOX			equ	 4
HTMENU				equ	 5
HTHSCROLL			equ	 6
HTVSCROLL			equ	 7
HTMINBUTTON			equ	 8
HTMAXBUTTON			equ	 9
;
HTSIZEFIRST			equ	HTLEFT
HTLEFT				equ	10
HTRIGHT				equ	11
HTTOP				equ	12
HTTOPLEFT			equ	13
HTTOPRIGHT			equ	14
HTBOTTOM			equ	15
HTBOTTOMLEFT			equ	16
HTBOTTOMRIGHT			equ	17
HTSIZELAST			equ	HTBOTTOMRIGHT
;
HTBORDER			equ	18
HTOBJECT			equ	19
HTCLOSE				equ	20
HTHELP				equ	21
;
HTSIZE				equ	HTGROWBOX
HTREDUCE			equ	HTMINBUTTON
HTZOOM				equ	HTMAXBUTTON
;
;------------------------------------------------------------------------------
;
; ===================
; toolbar bitmap id's
; ===================
;
IDB_STD_SMALL_COLOR		equ	 0
IDB_STD_LARGE_COLOR		equ	 1
IDB_VIEW_SMALL_COLOR		equ	 4
IDB_VIEW_LARGE_COLOR		equ	 5
;
HINST_COMMCTRL			equ	-1
;
;------------------------------------------------------------------------------
;
; ====================
; standard cursor id's
; ====================
;
IDC_ARROW			equ	32512
IDC_IBEAM			equ	32513
IDC_WAIT			equ	32514
IDC_CROSS			equ	32515
IDC_UPARROW			equ	32516
IDC_SIZE			equ	32640	;obsolete, use IDC_SIZEALL
IDC_ICON			equ	32641	;obsolete, use IDC_ARROW
IDC_SIZENWSE			equ	32642
IDC_SIZENESW			equ	32643
IDC_SIZEWE			equ	32644
IDC_SIZENS			equ	32645
IDC_SIZEALL			equ	32646
IDC_NO				equ	32648
IDC_APPSTARTING			equ	32650
IDC_HELP			equ	32651
;
;------------------------------------------------------------------------------
;
; ==================
; standard icon id's
; ==================
;
IDI_APPLICATION			equ	32512
IDI_HAND			equ	32513
IDI_QUESTION			equ	32514
IDI_EXCLAMATION			equ	32515
IDI_ASTERISK			equ	32516
IDI_WINLOGO			equ	32517
;
;------------------------------------------------------------------------------
;
; ===================
; dialog command id's
; ===================
;
IDOK				equ	1
IDCANCEL			equ	2
IDABORT				equ	3
IDRETRY				equ	4
IDIGNORE			equ	5
IDYES				equ	6
IDNO				equ	7
IDCLOSE				equ	8
IDHELP				equ	9
;
;------------------------------------------------------------------------------
;
; =============================
; keyboard message lParam flags
; =============================
;
KF_EXTENDED			equ	0100h
KF_DLGMODE			equ	0800h
KF_MENUMODE			equ	1000h
KF_ALTDOWN			equ	2000h
KF_REPEAT			equ	4000h
KF_UP				equ	8000h
;
;------------------------------------------------------------------------------
;
; ================
; listbox messages
; ================
;
LB_ADDSTRING			equ	0180h
LB_INSERTSTRING			equ	0181h
LB_DELETESTRING			equ	0182h
LB_SELITEMRANGEEX		equ	0183h
LB_RESETCONTENT			equ	0184h
LB_SETSEL			equ	0185h
LB_SETCURSEL			equ	0186h
LB_GETSEL			equ	0187h
LB_GETCURSEL			equ	0188h
LB_GETTEXT			equ	0189h
LB_GETTEXTLEN			equ	018Ah
LB_GETCOUNT			equ	018Bh
LB_SELECTSTRING			equ	018Ch
LB_DIR				equ	018Dh
LB_GETTOPINDEX			equ	018Eh
LB_FINDSTRING			equ	018Fh
LB_GETSELCOUNT			equ	0190h
LB_GETSELITEMS			equ	0191h
LB_SETTABSTOPS			equ	0192h
LB_GETHORIZONTALEXTENT		equ	0193h
LB_SETHORIZONTALEXTENT		equ	0194h
LB_SETCOLUMNWIDTH		equ	0195h
LB_ADDFILE			equ	0196h
LB_SETTOPINDEX			equ	0197h
LB_GETITEMRECT			equ	0198h
LB_GETITEMDATA			equ	0199h
LB_SETITEMDATA			equ	019Ah
LB_SELITEMRANGE			equ	019Bh
LB_SETANCHORINDEX		equ	019Ch
LB_GETANCHORINDEX		equ	019Dh
LB_SETCARETINDEX		equ	019Eh
LB_GETCARETINDEX		equ	019Fh
LB_SETITEMHEIGHT		equ	01A0h
LB_GETITEMHEIGHT		equ	01A1h
LB_FINDSTRINGEXACT		equ	01A2h
LB_SETLOCALE			equ	01A5h
LB_GETLOCALE			equ	01A6h
LB_SETCOUNT			equ	01A7h
LB_INITSTORAGE			equ	01A8h
LB_ITEMFROMPOINT		equ	01A9h
LB_MSGMAX			equ	01B0h
;
;------------------------------------------------------------------------------
;
; =====================
; listbox return values
; =====================
;
LB_OKAY				equ	 0
LB_ERR				equ	-1
LB_ERRSPACE			equ	-2
;
;------------------------------------------------------------------------------
;
; ==========================
; listbox notification codes
; ==========================
;
LBN_ERRSPACE			equ	-2
LBN_SELCHANGE			equ	 1
LBN_DBLCLK			equ	 2
LBN_SELCANCEL			equ	 3
LBN_SETFOCUS			equ	 4
LBN_KILLFOCUS			equ	 5
;
;------------------------------------------------------------------------------
;
; ==============
; listbox styles
; ==============
;
LBS_NOTIFY			equ	00000001h
LBS_SORT			equ	00000002h
LBS_NOREDRAW			equ	00000004h
LBS_MULTIPLESEL			equ	00000008h
LBS_OWNERDRAWFIXED		equ	00000010h
LBS_OWNERDRAWVARIABLE		equ	00000020h
LBS_HASSTRINGS			equ	00000040h
LBS_USETABSTOPS			equ	00000080h
LBS_NOINTEGRALHEIGHT		equ	00000100h
LBS_MULTICOLUMN			equ	00000200h
LBS_WANTKEYBOARDINPUT		equ	00000400h
LBS_EXTENDEDSEL			equ	00000800h
LBS_DISABLENOSCROLL		equ	00001000h
LBS_NODATA			equ	00002000h
LBS_NOSEL			equ	00004000h
LBS_STANDARD			equ	00A00003h
;
;------------------------------------------------------------------------------
;
; ==================
; local memory flags
; ==================
;
LMEM_FIXED			equ	0000h
LMEM_MOVEABLE			equ	0002h
LMEM_NOCOMPACT			equ	0010h
LMEM_NODISCARD			equ	0020h
LMEM_ZEROINIT			equ	0040h
LMEM_MODIFY			equ	0080h
LMEM_LOCKCOUNT			equ	00FFh
LMEM_DISCARDABLE		equ	0F00h
LMEM_DISCARDED			equ	4000h
LMEM_INVALID_HANDLE		equ	8000h
;
LMEM_VALID_FLAGS		equ	0F72h
;
NONZEROLHND			equ	LMEM_MOVEABLE
NONZEROLPTR			equ	LMEM_FIXED
;
LHND				equ	LMEM_ZEROINIT+LMEM_MOVEABLE
LPTR				equ	LMEM_ZEROINIT+LMEM_FIXED
;
;------------------------------------------------------------------------------
;
; ==================
; list view messages
; ==================
;
LVM_FIRST			equ	1000h
;
LVM_GETBKCOLOR			equ	LVM_FIRST+000
LVM_SETBKCOLOR			equ	LVM_FIRST+001
LVM_GETIMAGELIST		equ	LVM_FIRST+002
LVM_SETIMAGELIST		equ	LVM_FIRST+003
LVM_GETITEMCOUNT		equ	LVM_FIRST+004
LVM_GETITEMA			equ	LVM_FIRST+005
LVM_SETITEMA			equ	LVM_FIRST+006
LVM_INSERTITEMA			equ	LVM_FIRST+007
LVM_DELETEITEM			equ	LVM_FIRST+008
LVM_DELETEALLITEMS		equ	LVM_FIRST+009
LVM_GETCALLBACKMASK		equ	LVM_FIRST+010
LVM_SETCALLBACKMASK		equ	LVM_FIRST+011
LVM_GETNEXTITEM			equ	LVM_FIRST+012
LVM_FINDITEMA			equ	LVM_FIRST+013
LVM_GETITEMRECT			equ	LVM_FIRST+014
LVM_SETITEMPOSITION		equ	LVM_FIRST+015
LVM_GETITEMPOSITION		equ	LVM_FIRST+016
LVM_GETSTRINGWIDTHA		equ	LVM_FIRST+017
LVM_HITTEST			equ	LVM_FIRST+018
LVM_ENSUREVISIBLE		equ	LVM_FIRST+019
LVM_SCROLL			equ	LVM_FIRST+020
LVM_REDRAWITEMS			equ	LVM_FIRST+021
LVM_ARRANGE			equ	LVM_FIRST+022
LVM_EDITLABELA			equ	LVM_FIRST+023
LVM_GETEDITCONTROL		equ	LVM_FIRST+024
LVM_GETCOLUMNA			equ	LVM_FIRST+025
LVM_SETCOLUMNA			equ	LVM_FIRST+026
LVM_INSERTCOLUMNA		equ	LVM_FIRST+027
LVM_DELETECOLUMN		equ	LVM_FIRST+028
LVM_GETCOLUMNWIDTH		equ	LVM_FIRST+029
LVM_SETCOLUMNWIDTH		equ	LVM_FIRST+030
LVM_CREATEDRAGIMAGE		equ	LVM_FIRST+033
LVM_GETVIEWRECT			equ	LVM_FIRST+034
LVM_GETTEXTCOLOR		equ	LVM_FIRST+035
LVM_SETTEXTCOLOR		equ	LVM_FIRST+036
LVM_GETTEXTBKCOLOR		equ	LVM_FIRST+037
LVM_SETTEXTBKCOLOR		equ	LVM_FIRST+038
LVM_GETTOPINDEX			equ	LVM_FIRST+039
LVM_GETCOUNTPERPAGE		equ	LVM_FIRST+040
LVM_GETORIGIN			equ	LVM_FIRST+041
LVM_UPDATE			equ	LVM_FIRST+042
LVM_SETITEMSTATE		equ	LVM_FIRST+043
LVM_GETITEMSTATE		equ	LVM_FIRST+044
LVM_GETITEMTEXTA		equ	LVM_FIRST+045
LVM_SETITEMTEXTA		equ	LVM_FIRST+046
LVM_SETITEMCOUNT		equ	LVM_FIRST+047
LVM_SORTITEMS			equ	LVM_FIRST+048
LVM_SETITEMPOSITION32		equ	LVM_FIRST+049
LVM_GETSELECTEDCOUNT		equ	LVM_FIRST+050
LVM_GETITEMSPACING		equ	LVM_FIRST+051
LVM_GETISEARCHSTRINGA		equ	LVM_FIRST+052
;
LVM_GETITEMW			equ	LVM_FIRST+075
LVM_SETITEMW			equ	LVM_FIRST+076
LVM_INSERTITEMW			equ	LVM_FIRST+077
LVM_FINDITEMW			equ	LVM_FIRST+083
LVM_GETSTRINGWIDTHW		equ	LVM_FIRST+087
LVM_GETCOLUMNW			equ	LVM_FIRST+095
LVM_SETCOLUMNW			equ	LVM_FIRST+096
LVM_INSERTCOLUMNW		equ	LVM_FIRST+097
LVM_GETITEMTEXTW		equ	LVM_FIRST+115
LVM_SETITEMTEXTW		equ	LVM_FIRST+116
LVM_GETISEARCHSTRINGW		equ	LVM_FIRST+117
LVM_EDITLABELW			equ	LVM_FIRST+118
;
				if	UNICODE
LVM_GETITEM			equ	LVM_GETITEMW
LVM_SETITEM			equ	LVM_SETITEMW
LVM_INSERTITEM			equ	LVM_INSERTITEMW
LVM_FINDITEM			equ	LVM_FINDITEMW
LVM_GETSTRINGWIDTH		equ	LVM_GETSTRINGWIDTHW
LVM_GETCOLUMN			equ	LVM_GETCOLUMNW
LVM_SETCOLUMN			equ	LVM_SETCOLUMNW
LVM_INSERTCOLUMN		equ	LVM_INSERTCOLUMNW
LVM_GETITEMTEXT	 		equ	LVM_GETITEMTEXTW
LVM_SETITEMTEXT 		equ	LVM_SETITEMTEXTW
LVM_GETISEARCHSTRING		equ	LVM_GETISEARCHSTRINGW
LVM_EDITLABEL			equ	LVM_EDITLABELW
				else
LVM_GETITEM			equ	LVM_GETITEMA
LVM_SETITEM			equ	LVM_SETITEMA
LVM_INSERTITEM			equ	LVM_INSERTITEMA
LVM_FINDITEM			equ	LVM_FINDITEMA
LVM_GETSTRINGWIDTH		equ	LVM_GETSTRINGWIDTHA
LVM_GETCOLUMN			equ	LVM_GETCOLUMNA
LVM_SETCOLUMN			equ	LVM_SETCOLUMNA
LVM_INSERTCOLUMN		equ	LVM_INSERTCOLUMNA
LVM_GETITEMTEXT	 		equ	LVM_GETITEMTEXTA
LVM_SETITEMTEXT 		equ	LVM_SETITEMTEXTA
LVM_GETISEARCHSTRING		equ	LVM_GETISEARCHSTRINGA
LVM_EDITLABEL			equ	LVM_EDITLABELA
				endif
;
;------------------------------------------------------------------------------
;
; =======================
; list view notifications
; =======================
;
LVN_FIRST			equ	-100
LVN_LAST			equ	LVN_FIRST-99
;
LVN_ITEMCHANGING		equ	LVN_FIRST-00
LVN_ITEMCHANGED			equ	LVN_FIRST-01
LVN_INSERTITEM			equ	LVN_FIRST-02
LVN_DELETEITEM			equ	LVN_FIRST-03
LVN_DELETEALLITEMS		equ	LVN_FIRST-04
LVN_BEGINLABELEDITA		equ	LVN_FIRST-05
LVN_ENDLABELEDITA		equ	LVN_FIRST-06
LVN_COLUMNCLICK			equ	LVN_FIRST-08
LVN_BEGINDRAG			equ	LVN_FIRST-09
LVN_BEGINRDRAG			equ	LVN_FIRST-11
LVN_GETDISPINFOA		equ	LVN_FIRST-50
LVN_SETDISPINFOA		equ	LVN_FIRST-51
;
LVN_BEGINLABELEDITW		equ	LVN_FIRST-75
LVN_ENDLABELEDITW		equ	LVN_FIRST-76
LVN_GETDISPINFOW		equ	LVN_FIRST-77
LVN_SETDISPINFOW		equ	LVN_FIRST-78
;
				if	UNICODE
LVN_BEGINLABELEDIT		equ	LVN_BEGINLABELEDITW
LVN_ENDLABELEDIT		equ	LVN_ENDLABELEDITW
LVN_GETDISPINFO			equ	LVN_GETDISPINFOW
LVN_SETDISPINFO			equ	LVN_SETDISPINFOW
				else
LVN_BEGINLABELEDIT		equ	LVN_BEGINLABELEDITA
LVN_ENDLABELEDIT		equ	LVN_ENDLABELEDITA
LVN_GETDISPINFO			equ	LVN_GETDISPINFOA
LVN_SETDISPINFO			equ	LVN_SETDISPINFOA
				endif
;
;------------------------------------------------------------------------------
;
; ================
; list view styles
; ================
;
LVS_TYPEMASK			equ	00000003h
LVS_ICON			equ	00000000h
LVS_REPORT			equ	00000001h
LVS_SMALLICON			equ	00000002h
LVS_LIST			equ	00000003h
;
LVS_SINGLESEL			equ	00000004h
LVS_SHOWSELALWAYS		equ	00000008h
LVS_SORTASCENDING		equ	00000010h
LVS_SORTDESCENDING		equ	00000020h
LVS_SHAREIMAGELISTS		equ	00000040h
LVS_NOLABELWRAP			equ	00000080h
LVS_AUTOARRANGE			equ	00000100h
LVS_EDITLABELS			equ	00000200h
;
LVS_TYPESTYLEMASK		equ	0000FC00h
;
LVS_ALIGNMASK			equ	00000C00h
LVS_ALIGNTOP			equ	00000000h
LVS_OWNERDRAWFIXED		equ	00000400h
LVS_ALIGNLEFT			equ	00000800h
;
LVS_NOSCROLL			equ	00002000h
LVS_NOCOLUMNHEADER		equ	00004000h
LVS_NOSORTHEADER		equ	00008000h
;
;------------------------------------------------------------------------------
;
; ==================
; MessageBox() flags
; ==================
;
MB_OK				equ	00000000h
MB_OKCANCEL			equ	00000001h
MB_ABORTRETRYIGNORE		equ	00000002h
MB_YESNOCANCEL			equ	00000003h
MB_YESNO			equ	00000004h
MB_RETRYCANCEL			equ	00000005h
;
MB_ICONHAND			equ	00000010h
MB_ICONQUESTION			equ	00000020h
MB_ICONEXCLAMATION		equ	00000030h
MB_ICONASTERISK			equ	00000040h
;
MB_ICONWARNING			equ	MB_ICONEXCLAMATION
MB_ICONERROR			equ	MB_ICONHAND
MB_ICONINFORMATION		equ	MB_ICONASTERISK
MB_ICONSTOP			equ	MB_ICONHAND
;
MB_DEFBUTTON1			equ	00000000h
MB_DEFBUTTON2			equ	00000100h
MB_DEFBUTTON3			equ	00000200h
MB_DEFBUTTON4			equ	00000300h
;
MB_APPLMODAL			equ	00000000h
MB_SYSTEMMODAL			equ	00001000h
MB_TASKMODAL			equ	00002000h
MB_HELP				equ	00004000h
MB_RIGHT			equ	00080000h
MB_RTLREADING			equ	00100000h
;
MB_NOFOCUS			equ	00008000h
MB_SETFOREGROUND		equ	00010000h
MB_DEFAULT_DESKTOP_ONLY		equ	00020000h
MB_SERVICE_NOTIFICATION		equ	00040000h
;
MB_TYPEMASK			equ	0000000Fh
MB_USERICON			equ	00000080h
MB_ICONMASK			equ	000000F0h
MB_DEFMASK			equ	00000F00h
MB_MODEMASK			equ	00003000h
MB_MISCMASK			equ	0000C000h
;
;------------------------------------------------------------------------------
;
; ==========
; menu flags
; ==========
;
MF_INSERT			equ	00000000h
MF_CHANGE			equ	00000080h
MF_APPEND			equ	00000100h
MF_DELETE			equ	00000200h
MF_REMOVE			equ	00001000h
;
MF_BYCOMMAND			equ	00000000h
MF_BYPOSITION			equ	00000400h
;
MF_SEPARATOR			equ	00000800h
;
MF_ENABLED			equ	00000000h
MF_GRAYED			equ	00000001h
MF_DISABLED			equ	00000002h
;
MF_UNCHECKED			equ	00000000h
MF_CHECKED			equ	00000008h
MF_USECHECKBITMAPS		equ	00000200h
;
MF_STRING			equ	00000000h
MF_BITMAP			equ	00000004h
MF_OWNERDRAW			equ	00000100h
;
MF_POPUP			equ	00000010h
MF_MENUBARBREAK			equ	00000020h
MF_MENUBREAK			equ	00000040h
;
MF_UNHILITE			equ	00000000h
MF_HILITE			equ	00000080h
;
MF_DEFAULT			equ	00001000h
MF_SYSMENU			equ	00002000h
MF_HELP				equ	00004000h
MF_RIGHTJUSTIFY			equ	00004000h
;
MF_MOUSESELECT			equ	00008000h
MF_END				equ	00000080h	;obsolete
;
MFT_STRING			equ	MF_STRING
MFT_BITMAP			equ	MF_BITMAP
MFT_MENUBARBREAK		equ	MF_MENUBARBREAK
MFT_MENUBREAK			equ	MF_MENUBREAK
MFT_OWNERDRAW			equ	MF_OWNERDRAW
MFT_RADIOCHECK			equ	00000200h
MFT_SEPARATOR			equ	MF_SEPARATOR
MFT_RIGHTORDER			equ	00002000h
MFT_RIGHTJUSTIFY		equ	MF_RIGHTJUSTIFY
;
MFS_GRAYED			equ	00000003h
MFS_DISABLED			equ	MFS_GRAYED
MFS_CHECKED			equ	MF_CHECKED
MFS_HILITE			equ	MF_HILITE
MFS_ENABLED			equ	MF_ENABLED
MFS_UNCHECKED			equ	MF_UNCHECKED
MFS_UNHILITE			equ	MF_UNHILITE
MFS_DEFAULT			equ	MF_DEFAULT
;
;------------------------------------------------------------------------------
;
; ========================
; mouse message key states
; ========================
;
MK_LBUTTON			equ	0001h
MK_RBUTTON			equ	0002h
MK_SHIFT			equ	0004h
MK_CONTROL			equ	0008h
MK_MBUTTON			equ	0010h
;
;------------------------------------------------------------------------------
;
; ==================
; owner draw actions
; ==================
;
ODA_DRAWENTIRE			equ	0001h
ODA_SELECT			equ	0002h
ODA_FOCUS			equ	0004h
;
;------------------------------------------------------------------------------
;
; =================
; owner draw states
; =================
;
ODS_SELECTED			equ	0001h
ODS_GRAYED			equ	0002h
ODS_DISABLED			equ	0004h
ODS_CHECKED			equ	0008h
ODS_FOCUS			equ	0010h
ODS_DEFAULT			equ	0020h
ODS_COMBOBOXEDIT		equ	1000h
;
;------------------------------------------------------------------------------
;
; ================
; owner draw types
; ================
;
ODT_MENU			equ	1
ODT_LISTBOX			equ	2
ODT_COMBOBOX			equ	3
ODT_BUTTON			equ	4
ODT_STATIC			equ	5
;
;------------------------------------------------------------------------------
;
; ==================
; OPENFILENAME flags
; ==================
;
OFN_READONLY			equ	00000001h
OFN_OVERWRITEPROMPT		equ	00000002h
OFN_HIDEREADONLY		equ	00000004h
OFN_NOCHANGEDIR			equ	00000008h
OFN_SHOWHELP			equ	00000010h
OFN_ENABLEHOOK			equ	00000020h
OFN_ENABLETEMPLATE		equ	00000040h
OFN_ENABLETEMPLATEHANDLE	equ	00000080h
OFN_NOVALIDATE			equ	00000100h
OFN_ALLOWMULTISELECT		equ	00000200h
OFN_EXTENSIONDIFFERENT		equ	00000400h
OFN_PATHMUSTEXIST		equ	00000800h
OFN_FILEMUSTEXIST		equ	00001000h
OFN_CREATEPROMPT		equ	00002000h
OFN_SHAREAWARE			equ	00004000h
OFN_NOREADONLYRETURN		equ	00008000h
OFN_NOTESTFILECREATE		equ	00010000h
OFN_NONETWORKBUTTON		equ	00020000h
OFN_NOLONGNAMES			equ	00040000h
OFN_EXPLORER			equ	00080000h
OFN_NODEREFERENCELINKS		equ	00100000h
OFN_LONGNAMES			equ	00200000h
;
;------------------------------------------------------------------------------
;
; ==============================
; OPENFILENAME hook return codes
; ==============================
;
OFN_SHAREWARN			equ	0
OFN_SHARENOWARN			equ	1
OFN_SHAREFALLTHROUGH		equ	2
;
;------------------------------------------------------------------------------
;
; ================
; pipe definitions
; ================
;
PIPE_ACCESS_INBOUND		equ	00000001h
PIPE_ACCESS_OUTBOUND		equ	00000002h
PIPE_ACCESS_DUPLEX		equ	00000003h
;
PIPE_CLIENT_END			equ	00000000h
PIPE_SERVER_END			equ	00000001h
;
PIPE_WAIT			equ	00000000h
PIPE_NOWAIT			equ	00000001h
;
PIPE_READMODE_BYTE		equ	00000000h
PIPE_READMODE_MESSAGE		equ	00000002h
;
PIPE_TYPE_BYTE			equ	00000000h
PIPE_TYPE_MESSAGE		equ	00000004h
;
PIPE_UNLIMITED_INSTANCES	equ	255

