﻿// BIURO TELEFONICZNEJ OBSŁUGI KLIENTA ZE WSPARCIEM PRIORYTETOWYM
// Rozdział 5. (Stosy i kolejki)
// Struktury danych i algorytmy w języku C#, wydanie drugie

Random random = new();

CallCenter center = new();
center.Call(1234, false);
center.Call(5678, true);
center.Call(1468, false);
center.Call(9641, true);

while (center.AreWaitingCalls())
{
    IncomingCall call = center.Answer("Marcin")!;
    Log($"Połączenie nr {call.Id} od klienta {call.ClientId} odebrał { call.Consultant}.", call.IsPriority);
    await Task.Delay(random.Next(1000, 10000));
    center.End(call);
    Log($"Połączenie nr {call.Id} z klientem {call.ClientId} zakończył { call.Consultant}.", call.IsPriority);
}

void Log(string text, bool isPriority)
{
    Console.ForegroundColor = isPriority ? ConsoleColor.Red : ConsoleColor.Gray;
    Console.WriteLine($"[{DateTime.Now:HH:mm:ss}] {text}");
    Console.ResetColor();
}
